/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.cmd;

import io.ballerina.asyncapi.cmd.AsyncApiConstants;
import io.ballerina.asyncapi.cmd.AsyncApiMessages;
import io.ballerina.asyncapi.cmd.websockets.AsyncApiDiagnostic;
import io.ballerina.asyncapi.cmd.websockets.AsyncApiToBallerinaGenerator;
import io.ballerina.asyncapi.cmd.websockets.BallerinaToAsyncApiGenerator;
import io.ballerina.asyncapi.cmd.websockets.CmdUtils;
import io.ballerina.asyncapi.codegenerator.application.CodeGenerator;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.DiagnosticMessages;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.ExceptionDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.IncompatibleRemoteDiagnostic;
import io.ballerina.cli.BLauncherCmd;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.formatter.core.FormatterException;
import picocli.CommandLine;

@CommandLine.Command(name="asyncapi", description={"Generate the Ballerina sources for a given AsyncAPI definition."})
public class AsyncApiCmd
implements BLauncherCmd {
    private static final String CMD_NAME = "asyncapi";
    private PrintStream outStream;
    private boolean exitWhenFinish;
    private Path executionPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    private Path targetOutputPath;
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"-i", "--input"}, description={"File path to the AsyncAPI specification"})
    private boolean inputPath;
    @CommandLine.Option(names={"-o", "--output"}, description={"Directory to store the generated Ballerina service. If this is not provided, the generated files will be stored in the the current execution directory"})
    private String outputPath;
    @CommandLine.Option(names={"--protocol"}, description={"The protocol to be used for the service"})
    private String protocol = "http";
    @CommandLine.Option(names={"--license"}, description={"Location of the file which contains the license header"})
    private String licenseFilePath;
    @CommandLine.Option(names={"--service"}, description={"Service name that need to documented as asyncapi contract"})
    private String service;
    @CommandLine.Option(names={"--with-tests"}, hidden=true, description={"Generate test files"})
    private boolean includeTestFiles;
    @CommandLine.Option(names={"--json"}, description={"Generate json file"})
    private boolean generatedFileType;
    @CommandLine.Parameters
    private List<String> argList;

    public AsyncApiCmd() {
        this.outStream = System.err;
        this.exitWhenFinish = true;
    }

    public AsyncApiCmd(PrintStream outStream, Path executionDir) {
        new AsyncApiCmd(outStream, executionDir, true);
    }

    public AsyncApiCmd(PrintStream outStream, Path executionDir, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.executionPath = executionDir;
        this.exitWhenFinish = exitWhenFinish;
    }

    public AsyncApiCmd(Path executionDir, boolean exitWhenFinish) {
        this.outStream = System.err;
        this.executionPath = executionDir;
        this.exitWhenFinish = exitWhenFinish;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)CMD_NAME);
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (this.inputPath) {
            if (this.argList == null) {
                this.outStream.println("An AsyncApi definition file is required to generate the listener. \ne.g: bal asyncapi --input <AsyncAPIContract>");
                AsyncApiCmd.exitError(this.exitWhenFinish);
                return;
            }
            String fileName = this.argList.get(0);
            if (AsyncApiConstants.VALID_HTTP_NAMES.contains(this.protocol.toLowerCase())) {
                this.verifyValidInputsForHttp();
                CodeGenerator codeGenerator = new CodeGenerator();
                try {
                    codeGenerator.generate(fileName, this.outputPath == null ? String.valueOf(this.executionPath) : this.outputPath);
                }
                catch (BallerinaAsyncApiException e) {
                    this.outStream.println(e.getMessage());
                    AsyncApiCmd.exitError(this.exitWhenFinish);
                }
            } else if (AsyncApiConstants.VALID_WS_NAMES.contains(this.protocol.toLowerCase())) {
                this.outStream.println(AsyncApiConstants.EXPERIMENTAL_WARNING);
                if (fileName.endsWith(".yaml") || fileName.endsWith(".json") || fileName.endsWith(".yml")) {
                    this.giveWarningsForInvalidClientGenOptions();
                    try {
                        this.asyncApiToBallerinaWs(fileName);
                    }
                    catch (IOException e) {
                        this.outStream.println(e.getLocalizedMessage());
                        AsyncApiCmd.exitError(this.exitWhenFinish);
                    }
                } else if (fileName.endsWith(".bal")) {
                    this.giveWarningsForInvalidSpecGenOptions();
                    try {
                        this.ballerinaToAsyncApiWs(fileName);
                    }
                    catch (Exception e) {
                        this.outStream.println(e.getLocalizedMessage());
                        AsyncApiCmd.exitError(this.exitWhenFinish);
                    }
                } else {
                    this.outStream.println("Bal service file is required to generate the asyncapi definition. \ne.g: bal asyncapi --input <Ballerina file path>");
                    AsyncApiCmd.exitError(this.exitWhenFinish);
                }
            } else {
                this.outStream.println(String.format("ERROR invalid protocol: %s. Supported protocols are `http` and `ws`.", this.protocol));
                AsyncApiCmd.exitError(this.exitWhenFinish);
            }
        } else {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)this.getName());
            this.outStream.println(commandUsageInfo);
            AsyncApiCmd.exitError(this.exitWhenFinish);
            return;
        }
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private void giveWarningsForInvalidSpecGenOptions() {
        if (this.licenseFilePath != null) {
            this.outStream.println(AsyncApiMessages.INVALID_USE_OF_LICENSE_FLAG_WARNING);
        }
        if (this.includeTestFiles) {
            this.outStream.println(AsyncApiMessages.INVALID_USE_OF_TEST_FLAG_WARNING);
        }
    }

    private void giveWarningsForInvalidClientGenOptions() {
        if (this.generatedFileType) {
            this.outStream.println(AsyncApiMessages.INVALID_USE_OF_JSON_FLAG_WARNING);
        }
        if (this.service != null) {
            this.outStream.println(AsyncApiMessages.INVALID_USE_OF_SERVICE_FLAG_WARNING);
        }
    }

    private void verifyValidInputsForHttp() {
        if (this.licenseFilePath != null) {
            this.outStream.println(String.format("ERROR unsupported %s flag for http protocol", "--license"));
            AsyncApiCmd.exitError(this.exitWhenFinish);
        }
        if (this.service != null) {
            this.outStream.println(String.format("ERROR unsupported %s flag for http protocol", "--service"));
            AsyncApiCmd.exitError(this.exitWhenFinish);
        }
        if (this.includeTestFiles) {
            this.outStream.println(String.format("ERROR unsupported %s flag for http protocol", "--with-tests"));
            AsyncApiCmd.exitError(this.exitWhenFinish);
        }
        if (this.generatedFileType) {
            this.outStream.println(String.format("ERROR unsupported %s flag for http protocol", "--json"));
            AsyncApiCmd.exitError(this.exitWhenFinish);
        }
    }

    private void ballerinaToAsyncApiWs(String fileName) {
        ArrayList<AsyncApiConverterDiagnostic> errors = new ArrayList<AsyncApiConverterDiagnostic>();
        File balFile = new File(fileName);
        try {
            Path balFilePath = Paths.get(balFile.getCanonicalPath(), new String[0]);
            this.setOutputPathWs();
            List<AsyncApiConverterDiagnostic> generationErrors = BallerinaToAsyncApiGenerator.generateAsyncAPIDefinitionsAllService(balFilePath, this.targetOutputPath, this.service, this.generatedFileType, this.outStream);
            errors.addAll(generationErrors);
        }
        catch (IOException e) {
            DiagnosticMessages message = DiagnosticMessages.AAS_CONVERTOR_102;
            ExceptionDiagnostic error = new ExceptionDiagnostic(message.getCode(), message.getDescription(), null, e.getLocalizedMessage());
            errors.add(error);
        }
        if (!errors.isEmpty()) {
            for (AsyncApiConverterDiagnostic error : errors) {
                AsyncApiDiagnostic diagnostic;
                if (error instanceof ExceptionDiagnostic) {
                    ExceptionDiagnostic exceptionDiagnostic = (ExceptionDiagnostic)error;
                    diagnostic = CmdUtils.constructAsyncAPIDiagnostic(exceptionDiagnostic.getCode(), exceptionDiagnostic.getMessage(), exceptionDiagnostic.getDiagnosticSeverity(), exceptionDiagnostic.getLocation().orElse(null), new Object[0]);
                    this.outStream.println((Object)diagnostic);
                    AsyncApiCmd.exitError(this.exitWhenFinish);
                    continue;
                }
                if (!(error instanceof IncompatibleRemoteDiagnostic)) continue;
                IncompatibleRemoteDiagnostic incompatibleError = (IncompatibleRemoteDiagnostic)error;
                diagnostic = CmdUtils.constructAsyncAPIDiagnostic(incompatibleError.getCode(), incompatibleError.getMessage(), incompatibleError.getDiagnosticSeverity(), incompatibleError.getLocation().get(), new Object[0]);
                this.outStream.println((Object)diagnostic);
            }
        }
    }

    private void asyncApiToBallerinaWs(String fileName) throws IOException {
        AsyncApiToBallerinaGenerator generator = new AsyncApiToBallerinaGenerator(this.extractLicenseHeaderWs(), this.includeTestFiles);
        File asyncApiFile = new File(fileName);
        this.setOutputPathWs();
        Path resourcePath = Paths.get(asyncApiFile.getCanonicalPath(), new String[0]);
        this.generatesClientFileWs(generator, resourcePath);
    }

    private String extractLicenseHeaderWs() {
        try {
            if (this.licenseFilePath != null && !this.licenseFilePath.isBlank()) {
                Path filePath = Paths.get(new File(this.licenseFilePath).getCanonicalPath(), new String[0]);
                Object licenseHeader = Files.readString(Paths.get(filePath.toString(), new String[0]));
                if (!((String)licenseHeader).endsWith(AsyncApiConstants.LINE_SEPARATOR)) {
                    licenseHeader = (String)licenseHeader + AsyncApiConstants.LINE_SEPARATOR + AsyncApiConstants.LINE_SEPARATOR;
                } else if (!((String)licenseHeader).endsWith(AsyncApiConstants.LINE_SEPARATOR + AsyncApiConstants.LINE_SEPARATOR)) {
                    licenseHeader = (String)licenseHeader + AsyncApiConstants.LINE_SEPARATOR;
                }
                return licenseHeader;
            }
        }
        catch (IOException e) {
            this.outStream.println(String.format("Invalid license file path : %s. %s.", this.licenseFilePath, e.getMessage()));
            AsyncApiCmd.exitError(this.exitWhenFinish);
        }
        return "";
    }

    private void setOutputPathWs() {
        this.targetOutputPath = this.executionPath;
        if (this.outputPath != null) {
            this.targetOutputPath = Paths.get(this.outputPath, new String[0]).isAbsolute() ? Paths.get(this.outputPath, new String[0]) : Paths.get(this.targetOutputPath.toString(), this.outputPath);
        }
    }

    private void generatesClientFileWs(AsyncApiToBallerinaGenerator generator, Path resourcePath) {
        try {
            generator.generateClient(resourcePath, this.targetOutputPath);
        }
        catch (BallerinaAsyncApiExceptionWs | IOException | FormatterException e) {
            if (e.getLocalizedMessage() != null) {
                this.outStream.println(e.getLocalizedMessage());
                AsyncApiCmd.exitError(this.exitWhenFinish);
            }
            this.outStream.println("Error occurred when generating client for AsyncAPI contract");
            AsyncApiCmd.exitError(this.exitWhenFinish);
        }
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder stringBuilder) {
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream("ballerina-asyncapi.help");
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String content;
            while ((content = br.readLine()) != null) {
                stringBuilder.append(content).append('\n');
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printUsage(StringBuilder stringBuilder) {
    }

    public void setParentCmdParser(CommandLine commandLine) {
    }

    private static void exitError(boolean exit) {
        if (exit) {
            Runtime.getRuntime().exit(1);
        }
    }
}

