/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.cmd.websockets;

import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;

public class AsyncApiDiagnostic
extends Diagnostic {
    private final DiagnosticInfo diagnosticInfo;
    private final Location location;
    private final String message;

    public AsyncApiDiagnostic(DiagnosticInfo diagnosticInfo, Location location, Object[] args) {
        this.diagnosticInfo = diagnosticInfo;
        this.location = location;
        this.message = MessageFormat.format(diagnosticInfo.messageFormat(), args);
    }

    static LineRange getOneBasedLineRange(LineRange lineRange) {
        return LineRange.from((String)lineRange.filePath(), (LinePosition)LinePosition.from((int)(lineRange.startLine().line() + 1), (int)(lineRange.startLine().offset() + 1)), (LinePosition)LinePosition.from((int)(lineRange.endLine().line() + 1), (int)(lineRange.endLine().offset() + 1)));
    }

    public Location location() {
        return this.location;
    }

    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    public String message() {
        return this.message;
    }

    public List<DiagnosticProperty<?>> properties() {
        return Collections.emptyList();
    }

    public String toString() {
        LineRange lineRange = AsyncApiDiagnostic.getOneBasedLineRange(this.location().lineRange());
        String var10000 = this.diagnosticInfo().severity().toString();
        return var10000 + " [" + lineRange.filePath() + ":" + String.valueOf(lineRange) + "] " + this.message();
    }
}

