/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.cmd.websockets;

import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.ballerina.asyncapi.cmd.websockets.CmdUtils;
import io.ballerina.asyncapi.websocketscore.GeneratorConstants;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.CodegenUtils;
import io.ballerina.asyncapi.websocketscore.generators.client.IntermediateClientGenerator;
import io.ballerina.asyncapi.websocketscore.generators.client.TestGenerator;
import io.ballerina.asyncapi.websocketscore.generators.client.model.AasClientConfig;
import io.ballerina.asyncapi.websocketscore.generators.schema.BallerinaTypesGenerator;
import io.ballerina.asyncapi.websocketscore.model.GenSrcFile;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class AsyncApiToBallerinaGenerator {
    private static final PrintStream outStream = System.err;
    private final String licenseHeader;
    private final boolean includeTestFiles;

    public AsyncApiToBallerinaGenerator(String licenseHeader, boolean includeTestFiles) {
        this.licenseHeader = licenseHeader;
        this.includeTestFiles = includeTestFiles;
    }

    public void generateClient(Path definitionPath, Path outPath) throws IOException, BallerinaAsyncApiExceptionWs, FormatterException {
        this.writeGeneratedSources(this.generateClientFiles(definitionPath), outPath, GeneratorConstants.GenType.GEN_CLIENT);
    }

    private void writeGeneratedSources(List<GenSrcFile> sources, Path srcPath, GeneratorConstants.GenType type) throws IOException {
        Object files;
        ArrayList<File> listFiles = new ArrayList<File>();
        if (Files.notExists(srcPath, new LinkOption[0])) {
            Files.createDirectories(srcPath, new FileAttribute[0]);
        }
        if (Files.exists(srcPath, new LinkOption[0]) && (files = new File(String.valueOf(srcPath)).listFiles()) != null) {
            listFiles.addAll(Arrays.asList(files));
            for (Object file : files) {
                File[] innerFiles;
                if (!((File)file).isDirectory() || !((File)file).getName().equals("tests") || (innerFiles = new File(String.valueOf(srcPath) + "/tests").listFiles()) == null) continue;
                listFiles.addAll(Arrays.asList(innerFiles));
            }
        }
        for (File file : listFiles) {
            for (GenSrcFile gFile : sources) {
                String userInput;
                if (!file.getName().equals(gFile.getFileName()) || System.console() == null || Objects.equals((userInput = System.console().readLine("There is already a/an " + file.getName() + " in the location. Do you want to override the file? [y/N] ", new Object[0])).toLowerCase(Locale.ENGLISH), "y")) continue;
                int duplicateCount = 0;
                CmdUtils.setGeneratedFileName(listFiles, gFile, duplicateCount);
            }
        }
        for (GenSrcFile genSrcFile : sources) {
            boolean isDuplicatedFileInTests;
            Path filePath;
            if (!genSrcFile.getType().isOverwritable()) {
                filePath = srcPath.resolve(genSrcFile.getFileName());
                if (!Files.notExists(filePath, new LinkOption[0])) continue;
                String fileContent = genSrcFile.getFileName().endsWith(".bal") ? this.licenseHeader + genSrcFile.getContent() : genSrcFile.getContent();
                CodegenUtils.writeFile(filePath, fileContent);
                continue;
            }
            boolean bl = isDuplicatedFileInTests = genSrcFile.getFileName().matches("test.+[0-9]+.bal") || genSrcFile.getFileName().matches("Config.+[0-9]+.toml");
            if (genSrcFile.getFileName().equals("test.bal") || genSrcFile.getFileName().equals("Config.toml") || isDuplicatedFileInTests) {
                Files.createDirectories(Paths.get(String.valueOf(srcPath) + "/tests", new String[0]), new FileAttribute[0]);
                filePath = Paths.get(srcPath.resolve("tests/" + genSrcFile.getFileName()).toFile().getCanonicalPath(), new String[0]);
            } else {
                filePath = Paths.get(srcPath.resolve(genSrcFile.getFileName()).toFile().getCanonicalPath(), new String[0]);
            }
            String fileContent = genSrcFile.getFileName().endsWith(".bal") ? this.licenseHeader + genSrcFile.getContent() : genSrcFile.getContent();
            CodegenUtils.writeFile(filePath, fileContent);
        }
        outStream.println("Client generated successfully.");
        outStream.println("Following files were created.");
        Iterator<GenSrcFile> iterator = sources.iterator();
        while (iterator.hasNext()) {
            outStream.println("-- " + iterator.next().getFileName());
        }
    }

    private List<GenSrcFile> generateClientFiles(Path asyncApi) throws IOException, BallerinaAsyncApiExceptionWs, FormatterException {
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        AsyncApi25DocumentImpl asyncApiDef = GeneratorUtils.normalizeAsyncAPI(asyncApi);
        AasClientConfig.Builder clientMetaDataBuilder = new AasClientConfig.Builder();
        AasClientConfig asyncApiClientConfig = clientMetaDataBuilder.withAsyncApi(asyncApiDef).withLicense(this.licenseHeader).build();
        IntermediateClientGenerator intermediateClientGenerator = new IntermediateClientGenerator(asyncApiClientConfig);
        String mainContent = Formatter.format((SyntaxTree)intermediateClientGenerator.generateSyntaxTree()).toString();
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, "client.bal", mainContent));
        String utilContent = Formatter.format((SyntaxTree)intermediateClientGenerator.getBallerinaUtilGenerator().generateUtilSyntaxTree()).toString();
        if (!utilContent.isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.UTIL_SRC, "utils.bal", utilContent));
        }
        ArrayList<TypeDefinitionNode> preGeneratedTypeDefNodes = new ArrayList<TypeDefinitionNode>(intermediateClientGenerator.getBallerinaAuthConfigGenerator().getAuthRelatedTypeDefinitionNodes());
        preGeneratedTypeDefNodes.addAll(intermediateClientGenerator.getTypeDefinitionNodeList());
        BallerinaTypesGenerator ballerinaSchemaGenerator = new BallerinaTypesGenerator(asyncApiDef, preGeneratedTypeDefNodes);
        SyntaxTree schemaSyntaxTree = ballerinaSchemaGenerator.generateSyntaxTree();
        String schemaContent = Formatter.format((SyntaxTree)schemaSyntaxTree).toString();
        if (!schemaContent.isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.MODEL_SRC, "types.bal", schemaContent));
        }
        if (this.includeTestFiles) {
            TestGenerator testGenerator = new TestGenerator(intermediateClientGenerator);
            String testContent = Formatter.format((SyntaxTree)testGenerator.generateSyntaxTree()).toString();
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, "test.bal", testContent));
            String configContent = testGenerator.getConfigTomlFile();
            if (!configContent.isBlank()) {
                sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, "Config.toml", configContent));
            }
        }
        return sourceFiles;
    }
}

