/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.controller;

import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.controller.BalController;
import io.ballerina.asyncapi.codegenerator.entity.ServiceType;
import io.ballerina.asyncapi.codegenerator.usecase.GenerateListenerStatementNode;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class ListenerController
implements BalController {
    private final List<ServiceType> serviceTypes;

    public ListenerController(List<ServiceType> serviceTypes) {
        this.serviceTypes = serviceTypes;
    }

    @Override
    public String generateBalCode(String balTemplate) throws BallerinaAsyncApiException {
        TextDocument textDocument = TextDocuments.from((String)balTemplate);
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        ModulePartNode oldRoot = (ModulePartNode)syntaxTree.rootNode();
        FunctionDefinitionNode functionDefinitionNode = this.getServiceTypeStrFuncNode(oldRoot);
        if (functionDefinitionNode == null) {
            throw new BallerinaAsyncApiException("Function 'getServiceTypeStr', is not found in the listener.bal");
        }
        FunctionBodyBlockNode functionBodyBlockNode = (FunctionBodyBlockNode)functionDefinitionNode.functionBody();
        List<String> serviceTypeNames = this.serviceTypes.stream().map(ServiceType::getServiceTypeName).collect(Collectors.toList());
        GenerateListenerStatementNode genIfElseNode = new GenerateListenerStatementNode(serviceTypeNames);
        StatementNode ifElseStatementNode = (StatementNode)genIfElseNode.generate();
        NodeList statements = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{ifElseStatementNode});
        FunctionBodyBlockNode functionBodyBlockNodeNew = functionBodyBlockNode.modify().withStatements(statements).apply();
        SyntaxTree modifiedTree = syntaxTree.replaceNode((Node)functionBodyBlockNode, (Node)functionBodyBlockNodeNew);
        try {
            return Formatter.format((SyntaxTree)modifiedTree).toSourceCode();
        }
        catch (FormatterException e) {
            throw new BallerinaAsyncApiException("Could not format the generated code, may be a syntax issue in the generated code", e);
        }
    }

    private FunctionDefinitionNode getServiceTypeStrFuncNode(ModulePartNode oldRoot) {
        for (ModuleMemberDeclarationNode node : oldRoot.members()) {
            if (node.kind() != SyntaxKind.CLASS_DEFINITION) continue;
            for (Node funcNode : ((ClassDefinitionNode)node).members()) {
                if (funcNode.kind() != SyntaxKind.OBJECT_METHOD_DEFINITION || !((FunctionDefinitionNode)funcNode).functionName().text().equals("getServiceTypeStr")) continue;
                return (FunctionDefinitionNode)funcNode;
            }
        }
        return null;
    }
}

