/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.controller;

import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.controller.BalController;
import io.ballerina.asyncapi.codegenerator.usecase.GenerateModuleMemberDeclarationNode;
import io.ballerina.asyncapi.codegenerator.usecase.GenerateUnionDescriptorNode;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.Map;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class SchemaController
implements BalController {
    private final Map<String, AsyncApiSchema> schemas;

    public SchemaController(Map<String, AsyncApiSchema> schemas) {
        this.schemas = schemas;
    }

    @Override
    public String generateBalCode(String balTemplate) throws BallerinaAsyncApiException {
        ArrayList<ModuleMemberDeclarationNode> recordNodes = new ArrayList<ModuleMemberDeclarationNode>();
        ArrayList<TypeDescriptorNode> typeDescriptorNodes = new ArrayList<TypeDescriptorNode>();
        for (Map.Entry<String, AsyncApiSchema> fields : this.schemas.entrySet()) {
            GenerateModuleMemberDeclarationNode generateRecordNode = new GenerateModuleMemberDeclarationNode(fields);
            ModuleMemberDeclarationNode typeDefinitionNode = (ModuleMemberDeclarationNode)generateRecordNode.generate();
            if (typeDefinitionNode instanceof TypeDefinitionNode) {
                typeDescriptorNodes.add((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)((TypeDefinitionNode)typeDefinitionNode).typeName().text())));
            }
            recordNodes.add(typeDefinitionNode);
        }
        GenerateUnionDescriptorNode generateUnionNode = new GenerateUnionDescriptorNode(typeDescriptorNodes, "GenericDataType");
        recordNodes.add((ModuleMemberDeclarationNode)generateUnionNode.generate());
        TextDocument textDocument = TextDocuments.from((String)balTemplate);
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        ModulePartNode oldRoot = (ModulePartNode)syntaxTree.rootNode();
        ModulePartNode newRoot = oldRoot.modify().withMembers(oldRoot.members().addAll(recordNodes)).apply();
        SyntaxTree modifiedTree = syntaxTree.replaceNode((Node)oldRoot, (Node)newRoot);
        try {
            return Formatter.format((SyntaxTree)modifiedTree).toSourceCode();
        }
        catch (FormatterException e) {
            throw new BallerinaAsyncApiException("Could not format the generated code, may be a syntax issue in the generated code", e);
        }
    }
}

