/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.repository;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.repository.FileRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileRepositoryImpl
implements FileRepository {
    @Override
    public String getFileContent(String filePath) throws BallerinaAsyncApiException {
        String string;
        File mainFile = new File(filePath);
        FileInputStream inputStream = new FileInputStream(mainFile);
        try {
            string = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new BallerinaAsyncApiException("File not found in the given path: ".concat(filePath), e);
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }

    @Override
    public String getFileContentFromResources(String fileName) throws BallerinaAsyncApiException {
        String string;
        block8: {
            InputStream inputStream = this.getFileFromResourceAsStream(fileName);
            try {
                string = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new BallerinaAsyncApiException("File not found in the resources: ".concat(fileName), e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    @Override
    public void writeToFile(String filePath, String content) throws BallerinaAsyncApiException {
        File file = new File(filePath);
        try {
            FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new BallerinaAsyncApiException("Could not write the contents to the relevant path: ".concat(filePath), e);
        }
    }

    @Override
    public String convertYamlToJson(String yaml) throws BallerinaAsyncApiException {
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            Object obj = yamlReader.readValue(yaml, Object.class);
            ObjectMapper jsonWriter = new ObjectMapper();
            return jsonWriter.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new BallerinaAsyncApiException("Error when converting the given yaml file to json, Please validate the yaml file", e);
        }
    }

    @Override
    public boolean validateJson(String jsonString) throws BallerinaAsyncApiException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
            objectMapper.readTree(jsonString);
            return true;
        }
        catch (JsonProcessingException e) {
            throw new BallerinaAsyncApiException("Error parsing the json, please validate the json file", e);
        }
    }

    private InputStream getFileFromResourceAsStream(String fileName) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("File not found: ".concat(fileName));
        }
        return inputStream;
    }
}

