/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase;

import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.usecase.Generator;
import io.ballerina.asyncapi.codegenerator.usecase.utils.CodegenUtils;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import java.util.List;

public class GenerateListenerStatementNode
implements Generator {
    private final List<String> serviceTypes;
    private final CodegenUtils codegenUtils = new CodegenUtils();

    public GenerateListenerStatementNode(List<String> serviceTypes) {
        this.serviceTypes = serviceTypes;
    }

    public StatementNode generate() throws BallerinaAsyncApiException {
        if (this.serviceTypes.isEmpty()) {
            throw new BallerinaAsyncApiException("No service types found, probably there are no channels defined in the async api spec");
        }
        if (this.serviceTypes.size() == 1) {
            return this.getReturnStatementNode(this.serviceTypes.get(0));
        }
        return this.createIfElseNode(this.serviceTypes);
    }

    private IfElseStatementNode createIfElseNode(List<String> remainingList) {
        String serviceType = remainingList.get(0);
        SimpleNameReferenceNode serviceTypeNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"serviceRef"));
        TypeTestExpressionNode condition = NodeFactory.createTypeTestExpressionNode((ExpressionNode)serviceTypeNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IS_KEYWORD), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.codegenUtils.getServiceTypeNameByServiceName(serviceType))));
        ReturnStatementNode returnStatementNode = this.getReturnStatementNode(serviceType);
        return NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)condition, (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{returnStatementNode}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN)), (Node)this.getElseNode(remainingList));
    }

    private ReturnStatementNode getReturnStatementNode(String serviceType) {
        return NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), (ExpressionNode)NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + this.codegenUtils.getServiceTypeNameByServiceName(serviceType) + "\""), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList())), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private Node getElseNode(List<String> list) {
        if (list.size() == 2) {
            return NodeFactory.createElseBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELSE_KEYWORD), (StatementNode)NodeFactory.createBlockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{this.getReturnStatementNode(list.get(1))}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN)));
        }
        return NodeFactory.createElseBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELSE_KEYWORD), (StatementNode)this.createIfElseNode(list.subList(1, list.size())));
    }
}

