/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.model;

import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import java.util.Optional;

public class AsyncApiInfo {
    private final String title;
    private final String version;
    private final String contractPath;

    public AsyncApiInfo(AsyncAPIInfoBuilder asyncAPIInfoBuilder) {
        this.title = asyncAPIInfoBuilder.title;
        this.version = asyncAPIInfoBuilder.version;
        this.contractPath = asyncAPIInfoBuilder.contractPath;
    }

    public Optional<String> getTitle() {
        return Optional.ofNullable(ConverterCommonUtils.normalizeTitle(this.title));
    }

    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public Optional<String> getContractPath() {
        return Optional.ofNullable(this.contractPath);
    }

    public static class AsyncAPIInfoBuilder {
        private String title;
        private String version;
        private String contractPath;

        public AsyncAPIInfoBuilder title(String title) {
            this.title = title;
            return this;
        }

        public AsyncAPIInfoBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AsyncAPIInfoBuilder contractPath(String contractPath) {
            this.contractPath = contractPath;
            return this;
        }

        public AsyncApiInfo build() {
            AsyncApiInfo asyncAPIInfo = new AsyncApiInfo(this);
            return asyncAPIInfo;
        }
    }
}

