/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ComponentsImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.Constants;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiComponentMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Arrays;
import java.util.Map;

public class AsyncApiQueryParameterMapper {
    private final AsyncApi25ComponentsImpl components;
    private final SemanticModel semanticModel;
    private final Map<String, String> apidocs;
    private final SyntaxKind[] validExpressionKind = new SyntaxKind[]{SyntaxKind.STRING_LITERAL, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.BOOLEAN_LITERAL, SyntaxKind.LIST_CONSTRUCTOR, SyntaxKind.NIL_LITERAL, SyntaxKind.MAPPING_CONSTRUCTOR};

    public AsyncApiQueryParameterMapper(Map<String, String> apidocs, AsyncApi25ComponentsImpl components, SemanticModel semanticModel) {
        this.apidocs = apidocs;
        this.components = components;
        this.semanticModel = semanticModel;
    }

    public void createQueryParameter(RequiredParameterNode queryParam, BalAsyncApi25SchemaImpl bindingObject) {
        String queryParamName = ConverterCommonUtils.unescapeIdentifier(((Token)queryParam.paramName().get()).text());
        if (queryParam.typeName() instanceof BuiltinSimpleNameReferenceNode) {
            BalAsyncApi25SchemaImpl asyncApiQueryParamSchema = ConverterCommonUtils.getAsyncApiSchema(queryParam.typeName().toString().trim());
            if (!this.apidocs.isEmpty() && queryParam.paramName().isPresent() && this.apidocs.containsKey(queryParamName)) {
                asyncApiQueryParamSchema.setDescription(this.apidocs.get(queryParamName.trim()));
            }
            bindingObject.addProperty(queryParamName, asyncApiQueryParamSchema);
        } else if (queryParam.typeName().kind() == SyntaxKind.OPTIONAL_TYPE_DESC) {
            BalAsyncApi25SchemaImpl asyncApiQueryParamSchema = this.setOptionalQueryParameter(queryParamName, (OptionalTypeDescriptorNode)queryParam.typeName());
            bindingObject.addProperty(queryParamName, asyncApiQueryParamSchema);
        } else if (queryParam.typeName().kind() == SyntaxKind.ARRAY_TYPE_DESC) {
            ArrayTypeDescriptorNode arrayNode = (ArrayTypeDescriptorNode)queryParam.typeName();
            BalAsyncApi25SchemaImpl asyncApiQueryParamSchema = this.handleArrayTypeQueryParameter(queryParamName, arrayNode);
            bindingObject.addProperty(queryParamName, asyncApiQueryParamSchema);
        } else if (queryParam.typeName() instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode queryNode = (SimpleNameReferenceNode)queryParam.typeName();
            AsyncApiComponentMapper componentMapper = new AsyncApiComponentMapper(this.components);
            TypeSymbol typeSymbol = (TypeSymbol)this.semanticModel.symbol((Node)queryNode).orElseThrow();
            componentMapper.createComponentSchema(typeSymbol, null);
            BalAsyncApi25SchemaImpl schema = new BalAsyncApi25SchemaImpl();
            schema.set$ref("#/components/schemas/" + ConverterCommonUtils.unescapeIdentifier(queryNode.name().text().trim()));
            if (!this.apidocs.isEmpty() && queryParam.paramName().isPresent() && this.apidocs.containsKey(queryParamName)) {
                schema.setDescription(this.apidocs.get(queryParamName.trim()));
            }
            bindingObject.addProperty(queryParamName, schema);
        } else {
            BalAsyncApi25SchemaImpl schema = this.createContentTypeForMapJson(queryParamName, false);
            if (!this.apidocs.isEmpty() && queryParam.paramName().isPresent() && this.apidocs.containsKey(queryParamName)) {
                schema.setDescription(this.apidocs.get(queryParamName.trim()));
            }
            bindingObject.addProperty(queryParamName, schema);
        }
    }

    public void createQueryParameter(DefaultableParameterNode defaultableQueryParam, BalAsyncApi25SchemaImpl bindingQueryObject) {
        String queryParamName = ((Token)defaultableQueryParam.paramName().get()).text();
        BalAsyncApi25SchemaImpl asyncApiQueryParamDefaultSchema = null;
        if (defaultableQueryParam.typeName() instanceof BuiltinSimpleNameReferenceNode) {
            asyncApiQueryParamDefaultSchema = ConverterCommonUtils.getAsyncApiSchema(defaultableQueryParam.typeName().toString().trim());
            if (!this.apidocs.isEmpty() && defaultableQueryParam.paramName().isPresent() && this.apidocs.containsKey(queryParamName)) {
                asyncApiQueryParamDefaultSchema.setDescription(this.apidocs.get(queryParamName.trim()));
            }
        } else if (defaultableQueryParam.typeName().kind() == SyntaxKind.OPTIONAL_TYPE_DESC) {
            asyncApiQueryParamDefaultSchema = this.setOptionalQueryParameter(queryParamName, (OptionalTypeDescriptorNode)defaultableQueryParam.typeName());
        } else if (defaultableQueryParam.typeName() instanceof ArrayTypeDescriptorNode) {
            ArrayTypeDescriptorNode arrayNode = (ArrayTypeDescriptorNode)defaultableQueryParam.typeName();
            asyncApiQueryParamDefaultSchema = this.handleArrayTypeQueryParameter(queryParamName, arrayNode);
        } else {
            asyncApiQueryParamDefaultSchema = this.createContentTypeForMapJson(queryParamName, false);
            if (!this.apidocs.isEmpty() && defaultableQueryParam.paramName().isPresent() && this.apidocs.containsKey(queryParamName)) {
                asyncApiQueryParamDefaultSchema.setDescription(this.apidocs.get(queryParamName.trim()));
            }
        }
        if (Arrays.stream(this.validExpressionKind).anyMatch(syntaxKind -> syntaxKind == defaultableQueryParam.expression().kind())) {
            String defaultValue = defaultableQueryParam.expression().toString().trim().replaceAll("\"", "");
            if (defaultableQueryParam.expression().kind() == SyntaxKind.NIL_LITERAL) {
                defaultValue = null;
            }
            asyncApiQueryParamDefaultSchema.setDefault((JsonNode)new TextNode(defaultValue));
            bindingQueryObject.addProperty(queryParamName, asyncApiQueryParamDefaultSchema);
        } else {
            bindingQueryObject.addProperty(queryParamName, asyncApiQueryParamDefaultSchema);
        }
    }

    private BalAsyncApi25SchemaImpl handleArrayTypeQueryParameter(String queryParamName, ArrayTypeDescriptorNode arrayNode) {
        BalAsyncApi25SchemaImpl itemSchema;
        BalAsyncApi25SchemaImpl arraySchema = new BalAsyncApi25SchemaImpl();
        arraySchema.setType(Constants.AsyncAPIType.ARRAY.toString());
        TypeDescriptorNode itemTypeNode = arrayNode.memberTypeDesc();
        if (arrayNode.memberTypeDesc().kind() == SyntaxKind.OPTIONAL_TYPE_DESC) {
            itemSchema = ConverterCommonUtils.getAsyncApiSchema(((OptionalTypeDescriptorNode)itemTypeNode).typeDescriptor().toString().trim());
            itemSchema.addExtension("x-nullable", (JsonNode)BooleanNode.TRUE);
        } else {
            itemSchema = ConverterCommonUtils.getAsyncApiSchema(itemTypeNode.toString().trim());
        }
        arraySchema.setItems(itemSchema);
        if (!this.apidocs.isEmpty() && this.apidocs.containsKey(queryParamName)) {
            arraySchema.setDescription(this.apidocs.get(queryParamName));
        }
        return arraySchema;
    }

    private BalAsyncApi25SchemaImpl setOptionalQueryParameter(String queryParamName, OptionalTypeDescriptorNode typeNode) {
        Node node = typeNode.typeDescriptor();
        if (node.kind() == SyntaxKind.ARRAY_TYPE_DESC) {
            BalAsyncApi25SchemaImpl arraySchema = ConverterCommonUtils.getAsyncApiSchema(Constants.AsyncAPIType.ARRAY.toString());
            arraySchema.addExtension("x-nullable", (JsonNode)BooleanNode.TRUE);
            ArrayTypeDescriptorNode arrayNode = (ArrayTypeDescriptorNode)node;
            TypeDescriptorNode itemTypeNode = arrayNode.memberTypeDesc();
            BalAsyncApi25SchemaImpl itemSchema = ConverterCommonUtils.getAsyncApiSchema(itemTypeNode.toString().trim());
            arraySchema.setItems(itemSchema);
            if (!this.apidocs.isEmpty() && this.apidocs.containsKey(queryParamName)) {
                arraySchema.setDescription(this.apidocs.get(queryParamName));
            }
            return arraySchema;
        }
        if (node.kind() == SyntaxKind.MAP_TYPE_DESC) {
            BalAsyncApi25SchemaImpl mapJsonSchema = this.createContentTypeForMapJson(queryParamName, true);
            if (!this.apidocs.isEmpty() && this.apidocs.containsKey(queryParamName)) {
                mapJsonSchema.setDescription(this.apidocs.get(queryParamName));
            }
            return mapJsonSchema;
        }
        BalAsyncApi25SchemaImpl asyncApiSchema = ConverterCommonUtils.getAsyncApiSchema(node.toString().trim());
        asyncApiSchema.addExtension("x-nullable", (JsonNode)BooleanNode.TRUE);
        if (!this.apidocs.isEmpty() && this.apidocs.containsKey(queryParamName)) {
            asyncApiSchema.setDescription(this.apidocs.get(queryParamName));
        }
        return asyncApiSchema;
    }

    private BalAsyncApi25SchemaImpl createContentTypeForMapJson(String queryParamName, boolean nullable) {
        BalAsyncApi25SchemaImpl objectSchema = ConverterCommonUtils.getAsyncApiSchema(Constants.AsyncAPIType.OBJECT.toString());
        BalAsyncApi25SchemaImpl emptyObjectSchema = ConverterCommonUtils.getAsyncApiSchema(queryParamName);
        if (nullable) {
            objectSchema.addExtension("x-nullable", (JsonNode)BooleanNode.TRUE);
        }
        objectSchema.setAdditionalProperties(emptyObjectSchema);
        return objectSchema;
    }
}

