/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.document;

import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;

public class DocCommentsGenerator {
    public static List<MarkdownDocumentationLineNode> createAPIDescriptionDoc(String description, boolean addExtraLine) {
        String[] descriptionLines = description.split("\n");
        ArrayList<MarkdownDocumentationLineNode> documentElements = new ArrayList<MarkdownDocumentationLineNode>();
        Token hashToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        for (String line : descriptionLines) {
            MarkdownDocumentationLineNode documentationLineNode = NodeFactory.createMarkdownDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, (Token)hashToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DOCUMENTATION_DESCRIPTION, (String)line, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)GeneratorUtils.SINGLE_END_OF_LINE_MINUTIAE)}));
            documentElements.add(documentationLineNode);
        }
        if (addExtraLine) {
            MarkdownDocumentationLineNode newLine = NodeFactory.createMarkdownDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN), (NodeList)AbstractNodeFactory.createEmptyNodeList());
            documentElements.add(newLine);
        }
        return documentElements;
    }

    public static MarkdownParameterDocumentationLineNode createAPIParamDoc(String paramName, String description) {
        String[] paramDescriptionLines = description.split("\n");
        ArrayList<IdentifierToken> documentElements = new ArrayList<IdentifierToken>();
        for (String line : paramDescriptionLines) {
            if (line.isBlank()) continue;
            documentElements.add(AbstractNodeFactory.createIdentifierToken((String)(line + " ")));
        }
        return NodeFactory.createMarkdownParameterDocumentationLineNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PLUS_TOKEN), (Token)AbstractNodeFactory.createIdentifierToken((String)paramName), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.MINUS_TOKEN), (NodeList)AbstractNodeFactory.createNodeList(documentElements));
    }
}

