/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators;

import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.schema.TypeGeneratorUtils;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.RecordTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.ReferencedTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.TypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.model.GeneratorMetaData;
import io.ballerina.asyncapi.websocketscore.generators.schema.model.RecordMetadata;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AllOfRecordTypeGenerator
extends RecordTypeGenerator {
    private final List<Schema> restSchemas = new LinkedList<Schema>();

    public AllOfRecordTypeGenerator(AsyncApi25SchemaImpl schema, String typeName) {
        super(schema, typeName);
    }

    private static RecordRestDescriptorNode getRestDescriptorNodeForAllOf(List<Schema> restSchemas) throws BallerinaAsyncApiExceptionWs {
        TypeDescriptorNode unionType = AllOfRecordTypeGenerator.getUnionType(restSchemas);
        return NodeFactory.createRecordRestDescriptorNode((Node)unionType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private static TypeDescriptorNode getUnionType(List<Schema> schemas) throws BallerinaAsyncApiExceptionWs {
        ArrayList<TypeDescriptorNode> typeDescriptorNodes = new ArrayList<TypeDescriptorNode>();
        for (Schema schema : schemas) {
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator((AsyncApi25SchemaImpl)schema, null, null);
            TypeDescriptorNode typeDescriptorNode = typeGenerator.generateTypeDescriptorNode();
            typeDescriptorNodes.add(typeDescriptorNode);
            if (!GeneratorUtils.hasConstraints(schema)) continue;
            OUT_STREAM.println("WARNING: constraints in the AsyncAPI contract will be ignored for the additionalProperties field, as constraints are not supported on Ballerina rest record field.");
        }
        if (typeDescriptorNodes.size() > 1) {
            UnionTypeDescriptorNode unionTypeDescriptorNode = null;
            TypeDescriptorNode leftTypeDesc = (TypeDescriptorNode)typeDescriptorNodes.get(0);
            for (int i = 1; i < typeDescriptorNodes.size(); ++i) {
                TypeDescriptorNode rightTypeDesc = (TypeDescriptorNode)typeDescriptorNodes.get(i);
                unionTypeDescriptorNode = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)leftTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)rightTypeDesc);
                leftTypeDesc = unionTypeDescriptorNode;
            }
            return unionTypeDescriptorNode;
        }
        return (TypeDescriptorNode)typeDescriptorNodes.get(0);
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws BallerinaAsyncApiExceptionWs {
        AsyncApi25SchemaImpl composedSchema = this.schema;
        List<Schema> allOfSchemas = null;
        if (composedSchema.getAllOf() != null) {
            allOfSchemas = composedSchema.getAllOf();
        }
        RecordMetadata recordMetadata = this.getRecordMetadata();
        RecordRestDescriptorNode restDescriptorNode = recordMetadata.getRestDescriptorNode();
        if (allOfSchemas != null && allOfSchemas.size() == 1 && ((AsyncApi25SchemaImpl)allOfSchemas.get(0)).get$ref() != null) {
            ReferencedTypeGenerator referencedTypeGenerator = new ReferencedTypeGenerator((AsyncApi25SchemaImpl)allOfSchemas.get(0), this.typeName);
            return referencedTypeGenerator.generateTypeDescriptorNode();
        }
        List<Node> recordFieldList = null;
        if (allOfSchemas != null) {
            recordFieldList = this.generateAllOfRecordFields(allOfSchemas);
        }
        this.addAdditionalSchemas(this.schema);
        restDescriptorNode = this.restSchemas.size() > 1 ? AllOfRecordTypeGenerator.getRestDescriptorNodeForAllOf(this.restSchemas) : restDescriptorNode;
        NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFieldList);
        return NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)(recordMetadata.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN)), (NodeList)fieldNodes, (RecordRestDescriptorNode)restDescriptorNode, (Token)(recordMetadata.isOpenRecord() ? AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN) : AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN)));
    }

    private List<Node> generateAllOfRecordFields(List<Schema> allOfSchemas) throws BallerinaAsyncApiExceptionWs {
        ArrayList<Node> recordFieldList = new ArrayList<Node>();
        for (Schema schema : allOfSchemas) {
            AsyncApi25SchemaImpl allOfSchema = (AsyncApi25SchemaImpl)schema;
            if (allOfSchema.get$ref() != null) {
                String extractedSchemaName = GeneratorUtils.extractReferenceType(allOfSchema.get$ref());
                String modifiedSchemaName = GeneratorUtils.getValidName(extractedSchemaName, true);
                IdentifierToken typeRef = AbstractNodeFactory.createIdentifierToken((String)modifiedSchemaName);
                TypeReferenceNode recordField = NodeFactory.createTypeReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)typeRef, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                AsyncApi25DocumentImpl asyncAPI = GeneratorMetaData.getInstance().getAsyncAPI();
                AsyncApi25SchemaImpl refSchema = (AsyncApi25SchemaImpl)asyncAPI.getComponents().getSchemas().get(extractedSchemaName);
                this.addAdditionalSchemas(refSchema);
                recordFieldList.add((Node)recordField);
                continue;
            }
            if (allOfSchema.getProperties() != null) {
                Map<String, Schema> properties = allOfSchema.getProperties();
                List<String> required = allOfSchema.getRequired();
                List<Node> recordFields = this.addRecordFields(required, properties.entrySet(), this.typeName);
                recordFieldList.addAll(recordFields);
                this.addAdditionalSchemas(allOfSchema);
                continue;
            }
            if (allOfSchema.getOneOf() == null && allOfSchema.getAllOf() == null && allOfSchema.getAnyOf() == null) continue;
            AsyncApi25SchemaImpl nestedComposedSchema = allOfSchema;
            if (nestedComposedSchema.getAllOf() != null) {
                recordFieldList.addAll(this.generateAllOfRecordFields(nestedComposedSchema.getAllOf()));
                continue;
            }
            throw new BallerinaAsyncApiExceptionWs("Unsupported nested OneOf or AnyOf schema is found inside a AllOf schema.");
        }
        return recordFieldList;
    }

    private void addAdditionalSchemas(AsyncApi25SchemaImpl refSchema) {
        if (refSchema.getAdditionalProperties() != null && refSchema.getAdditionalProperties() instanceof Schema) {
            this.restSchemas.add(refSchema.getAdditionalProperties().asSchema());
        }
    }
}

