/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators;

import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorConstants;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.schema.TypeGeneratorUtils;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.PrimitiveTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.TypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.UnionTypeGenerator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;

public class ArrayTypeGenerator
extends TypeGenerator {
    private String parentType = null;

    public ArrayTypeGenerator(AsyncApi25SchemaImpl schema, String typeName, String parentType) {
        super(schema, typeName);
        this.parentType = parentType;
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws BallerinaAsyncApiExceptionWs {
        TypeGenerator typeGenerator;
        boolean isConstraintsAvailable;
        AsyncApi25SchemaImpl arraySchema = this.schema;
        AsyncApi25SchemaImpl items = (AsyncApi25SchemaImpl)arraySchema.getItems();
        boolean bl = isConstraintsAvailable = GeneratorUtils.hasConstraints(items) && this.typeName != null;
        if (isConstraintsAvailable) {
            String normalizedTypeName = this.typeName.replaceAll("([\\[\\]\\\\?!<>@#&~`*\\-=^+'();:\\/\\_{}\\s|.$])", "").trim();
            ArrayList<AnnotationNode> typeAnnotations = new ArrayList<AnnotationNode>();
            AnnotationNode constraintNode = TypeGeneratorUtils.generateConstraintNode(this.typeName, items);
            if (constraintNode != null) {
                typeAnnotations.add(constraintNode);
            }
            this.typeName = GeneratorUtils.getValidName(this.parentType != null ? this.parentType + "-" + normalizedTypeName + "-Items-" + items.getType() : normalizedTypeName + "-Items-" + items.getType(), true);
            typeGenerator = TypeGeneratorUtils.getTypeGenerator(items, this.typeName, null);
            TypeDefinitionNode arrayItemWithConstraint = typeGenerator.generateTypeDefinitionNode(AbstractNodeFactory.createIdentifierToken((String)this.typeName), new ArrayList<Node>(), typeAnnotations);
            this.imports.addAll(typeGenerator.getImports());
            this.typeDefinitionNodeList.add(arrayItemWithConstraint);
        } else {
            typeGenerator = TypeGeneratorUtils.getTypeGenerator(items, this.typeName, null);
        }
        this.typeDefinitionNodeList.addAll(typeGenerator.getTypeDefinitionNodeList());
        TypeDescriptorNode typeDescriptorNode = (typeGenerator instanceof PrimitiveTypeGenerator || typeGenerator instanceof ArrayTypeGenerator) && isConstraintsAvailable ? NodeParser.parseTypeDescriptor((String)this.typeName) : typeGenerator.generateTypeDescriptorNode();
        if (typeGenerator instanceof UnionTypeGenerator || items.getEnum() != null && items.getEnum().size() > 0) {
            typeDescriptorNode = NodeFactory.createParenthesisedTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (TypeDescriptorNode)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        }
        if (typeDescriptorNode instanceof OptionalTypeDescriptorNode) {
            Node node = ((OptionalTypeDescriptorNode)typeDescriptorNode).typeDescriptor();
            typeDescriptorNode = (TypeDescriptorNode)node;
        }
        if (arraySchema.getMaxItems() != null && arraySchema.getMaxItems() > GeneratorConstants.MAX_ARRAY_LENGTH) {
            throw new BallerinaAsyncApiExceptionWs("Maximum item count defined in the definition exceeds the maximum ballerina array length.");
        }
        NodeList arrayDimensions = AbstractNodeFactory.createEmptyNodeList();
        if (typeDescriptorNode.kind() == SyntaxKind.ARRAY_TYPE_DESC) {
            ArrayTypeDescriptorNode innerArrayType = (ArrayTypeDescriptorNode)typeDescriptorNode;
            arrayDimensions = innerArrayType.dimensions();
            typeDescriptorNode = innerArrayType.memberTypeDesc();
        }
        ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        arrayDimensions = arrayDimensions.add((Node)arrayDimension);
        ArrayTypeDescriptorNode arrayTypeDescriptorNode = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)typeDescriptorNode, (NodeList)arrayDimensions);
        this.imports.addAll(typeGenerator.getImports());
        return TypeGeneratorUtils.getNullableType(arraySchema, (TypeDescriptorNode)arrayTypeDescriptorNode);
    }
}

