/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators;

import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class TypeGenerator {
    final List<TypeDefinitionNode> typeDefinitionNodeList = new ArrayList<TypeDefinitionNode>();
    final LinkedHashSet<String> imports = new LinkedHashSet();
    AsyncApi25SchemaImpl schema;
    String typeName;

    public TypeGenerator(AsyncApi25SchemaImpl schema, String typeName) {
        this.schema = schema;
        this.typeName = typeName;
    }

    public List<TypeDefinitionNode> getTypeDefinitionNodeList() {
        return this.typeDefinitionNodeList;
    }

    public LinkedHashSet<String> getImports() {
        return this.imports;
    }

    public TypeDefinitionNode generateTypeDefinitionNode(IdentifierToken typeName, List<Node> schemaDoc, List<AnnotationNode> typeAnnotations) throws BallerinaAsyncApiExceptionWs {
        for (AnnotationNode annotation : typeAnnotations) {
            String annotationRef = annotation.annotReference().toString();
            if (!annotationRef.startsWith("constraint")) continue;
            ImportDeclarationNode constraintImport = GeneratorUtils.getImportDeclarationNode("ballerina", "constraint");
            this.imports.add(constraintImport.toSourceCode());
        }
        MarkdownDocumentationNode documentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(schemaDoc));
        MetadataNode metadataNode = NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)AbstractNodeFactory.createNodeList(typeAnnotations));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)this.generateTypeDescriptorNode(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public abstract TypeDescriptorNode generateTypeDescriptorNode() throws BallerinaAsyncApiExceptionWs;
}

