/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators;

import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.schema.TypeGeneratorUtils;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.ArrayTypeGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.TypeGenerator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class UnionTypeGenerator
extends TypeGenerator {
    public UnionTypeGenerator(AsyncApi25SchemaImpl schema, String typeName) {
        super(schema, typeName);
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws BallerinaAsyncApiExceptionWs {
        AsyncApi25SchemaImpl composedSchema = this.schema;
        List<AsyncApiSchema> schemas = composedSchema.getOneOf() != null ? composedSchema.getOneOf() : composedSchema.getAnyOf();
        TypeDescriptorNode unionTypeDesc = this.getUnionType(schemas, this.typeName);
        return TypeGeneratorUtils.getNullableType(this.schema, unionTypeDesc);
    }

    private TypeDescriptorNode getUnionType(List<AsyncApiSchema> schemas, String typeName) throws BallerinaAsyncApiExceptionWs {
        ArrayList<TypeDescriptorNode> typeDescriptorNodes = new ArrayList<TypeDescriptorNode>();
        for (AsyncApiSchema schema : schemas) {
            TypeGenerator typeGenerator = TypeGeneratorUtils.getTypeGenerator((AsyncApi25SchemaImpl)schema, typeName, null);
            TypeDescriptorNode typeDescNode = typeGenerator.generateTypeDescriptorNode();
            if (typeDescNode instanceof OptionalTypeDescriptorNode) {
                Node internalTypeDesc = ((OptionalTypeDescriptorNode)typeDescNode).typeDescriptor();
                typeDescNode = (TypeDescriptorNode)internalTypeDesc;
            }
            typeDescriptorNodes.add(typeDescNode);
            if (!(typeGenerator instanceof ArrayTypeGenerator) || typeGenerator.getTypeDefinitionNodeList().isEmpty()) continue;
            this.typeDefinitionNodeList.addAll(typeGenerator.getTypeDefinitionNodeList());
        }
        return this.createUnionTypeNode(typeDescriptorNodes);
    }

    private TypeDescriptorNode createUnionTypeNode(List<TypeDescriptorNode> typeDescNodes) {
        if (typeDescNodes.isEmpty()) {
            return null;
        }
        if (typeDescNodes.size() == 1) {
            return typeDescNodes.get(0);
        }
        if (typeDescNodes.stream().anyMatch(node -> node.kind() == SyntaxKind.OPTIONAL_TYPE_DESC)) {
            typeDescNodes = typeDescNodes.stream().map(node -> {
                if (node instanceof OptionalTypeDescriptorNode) {
                    return (TypeDescriptorNode)((OptionalTypeDescriptorNode)node).typeDescriptor();
                }
                return node;
            }).collect(Collectors.toList());
            OptionalTypeDescriptorNode optionalTypeDesc = NodeFactory.createOptionalTypeDescriptorNode((Node)((Node)typeDescNodes.get(typeDescNodes.size() - 1)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
            typeDescNodes.set(typeDescNodes.size() - 1, optionalTypeDesc);
        }
        UnionTypeDescriptorNode unionTypeDescNode = null;
        TypeDescriptorNode leftTypeDesc = typeDescNodes.get(0);
        for (int i = 1; i < typeDescNodes.size(); ++i) {
            TypeDescriptorNode rightTypeDesc = (TypeDescriptorNode)typeDescNodes.get(i);
            unionTypeDescNode = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)leftTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)rightTypeDesc);
            leftTypeDesc = unionTypeDescNode;
        }
        return unionTypeDescNode;
    }
}

