/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.xmltorecordconverter;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.LiteralValueToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.xmltorecordconverter.XMLToRecordResponse;
import io.ballerina.xmltorecordconverter.diagnostic.DiagnosticMessage;
import io.ballerina.xmltorecordconverter.diagnostic.DiagnosticUtils;
import io.ballerina.xmltorecordconverter.util.ConverterUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.options.ForceFormattingOptions;
import org.ballerinalang.formatter.core.options.FormattingOptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XMLToRecordConverter {
    private static final String XMLNS_PREFIX = "xmlns";
    private static final String XMLDATA = "xmldata";
    private static final String COLON = ":";

    private XMLToRecordConverter() {
    }

    public static XMLToRecordResponse convert(String xmlValue, boolean isRecordTypeDesc, boolean isClosed, boolean forceFormatRecordFields, String textFieldName, boolean withNameSpaces, boolean withoutAttributes, boolean withoutAttributeAnnot) {
        LinkedHashMap<String, NonTerminalNode> recordToTypeDescNodes = new LinkedHashMap<String, NonTerminalNode>();
        LinkedHashMap<String, AnnotationNode> recordToAnnotationNodes = new LinkedHashMap<String, AnnotationNode>();
        LinkedHashMap<String, Element> recordToElementNodes = new LinkedHashMap<String, Element>();
        ArrayList<DiagnosticMessage> diagnosticMessages = new ArrayList<DiagnosticMessage>();
        XMLToRecordResponse response = new XMLToRecordResponse();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlValue.getBytes(StandardCharsets.UTF_8));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = dbFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(inputStream);
            Element rootElement = doc.getDocumentElement();
            XMLToRecordConverter.generateRecords(rootElement, isClosed, recordToTypeDescNodes, recordToAnnotationNodes, recordToElementNodes, diagnosticMessages, textFieldName, withNameSpaces, withoutAttributes, withoutAttributeAnnot);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            DiagnosticMessage message = DiagnosticMessage.xmlToRecordConverter100(null);
            diagnosticMessages.add(message);
            return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
        }
        catch (SAXException saxException) {
            DiagnosticMessage message = DiagnosticMessage.xmlToRecordConverter101(null);
            diagnosticMessages.add(message);
            return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
        }
        catch (IOException | IllegalArgumentException e) {
            DiagnosticMessage message = DiagnosticMessage.xmlToRecordConverter102(null);
            diagnosticMessages.add(message);
            return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
        }
        io.ballerina.compiler.syntax.tree.NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        ArrayList recordToTypeDescNodeEntries = new ArrayList(recordToTypeDescNodes.entrySet());
        List<TypeDefinitionNode> typeDefNodes = recordToTypeDescNodeEntries.stream().map(entry -> {
            ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
            String recordName = (String)entry.getKey();
            String recordTypeName = XMLToRecordConverter.getRecordName(recordName);
            if (recordToTypeDescNodeEntries.indexOf(entry) == recordToTypeDescNodeEntries.size() - 1 && !recordName.equals(recordTypeName)) {
                String annotNameValue = ((Element)recordToElementNodes.get(recordName)).getLocalName();
                annotations.add(XMLToRecordConverter.getXMLNameNode(annotNameValue));
            }
            if (recordToAnnotationNodes.containsKey(recordName)) {
                annotations.add((AnnotationNode)recordToAnnotationNodes.get(recordName));
            }
            io.ballerina.compiler.syntax.tree.NodeList annotationNodes = NodeFactory.createNodeList(annotations);
            MetadataNode metadata = NodeFactory.createMetadataNode(null, (io.ballerina.compiler.syntax.tree.NodeList)annotationNodes);
            Token typeKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD);
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)recordTypeName);
            Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
            return NodeFactory.createTypeDefinitionNode((MetadataNode)metadata, null, (Token)typeKeyWord, (Token)typeName, (Node)((Node)entry.getValue()), (Token)semicolon);
        }).toList();
        io.ballerina.compiler.syntax.tree.NodeList moduleMembers = AbstractNodeFactory.createNodeList(new ArrayList<TypeDefinitionNode>(typeDefNodes));
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((io.ballerina.compiler.syntax.tree.NodeList)imports, (io.ballerina.compiler.syntax.tree.NodeList)moduleMembers, (Token)eofToken);
        try {
            ForceFormattingOptions forceFormattingOptions = ForceFormattingOptions.builder().setForceFormatRecordFields(forceFormatRecordFields).build();
            FormattingOptions formattingOptions = FormattingOptions.builder().setForceFormattingOptions(forceFormattingOptions).build();
            response.setCodeBlock(Formatter.format((SyntaxTree)modulePartNode.syntaxTree(), (FormattingOptions)formattingOptions).toSourceCode());
        }
        catch (FormatterException e) {
            DiagnosticMessage message = DiagnosticMessage.xmlToRecordConverter103(null);
            diagnosticMessages.add(message);
        }
        return DiagnosticUtils.getDiagnosticResponse(diagnosticMessages, response);
    }

    public static XMLToRecordResponse convert(String xmlValue, boolean isRecordTypeDesc, boolean isClosed, boolean forceFormatRecordFields) {
        return XMLToRecordConverter.convert(xmlValue, isRecordTypeDesc, isClosed, forceFormatRecordFields, null, true, false, false);
    }

    private static void generateRecords(Element xmlElement, boolean isClosed, Map<String, NonTerminalNode> recordToTypeDescNodes, Map<String, AnnotationNode> recordToAnnotationsNodes, Map<String, Element> recordToElementNodes, List<DiagnosticMessage> diagnosticMessages, String textFieldName, boolean withNameSpace, boolean withoutAttributes, boolean withoutAttributeAnnot) {
        Token recordKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD);
        Token bodyStartDelimiter = AbstractNodeFactory.createToken((SyntaxKind)(isClosed ? SyntaxKind.OPEN_BRACE_PIPE_TOKEN : SyntaxKind.OPEN_BRACE_TOKEN));
        String xmlNodeName = xmlElement.getNodeName();
        List<Node> recordFields = XMLToRecordConverter.getRecordFieldsForXMLElement(xmlElement, isClosed, recordToTypeDescNodes, recordToAnnotationsNodes, recordToElementNodes, diagnosticMessages, textFieldName, withNameSpace, withoutAttributes, withoutAttributeAnnot);
        if (recordToTypeDescNodes.containsKey(xmlNodeName)) {
            RecordTypeDescriptorNode previousRecordTypeDescriptorNode = (RecordTypeDescriptorNode)recordToTypeDescNodes.get(xmlNodeName);
            List<RecordFieldNode> previousRecordFields = previousRecordTypeDescriptorNode.fields().stream().map(node -> (RecordFieldNode)node).toList();
            Map previousRecordFieldToNodes = previousRecordFields.stream().collect(Collectors.toMap(node -> node.fieldName().text(), Function.identity(), (val1, val2) -> val1, LinkedHashMap::new));
            Map newRecordFieldToNodes = recordFields.stream().collect(Collectors.toMap(node -> ((RecordFieldNode)node).fieldName().text(), node -> (RecordFieldNode)node, (e1, e2) -> e1, LinkedHashMap::new));
            recordFields.clear();
            recordFields = XMLToRecordConverter.updateRecordFields(previousRecordFieldToNodes, newRecordFieldToNodes);
        }
        io.ballerina.compiler.syntax.tree.NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFields);
        Token bodyEndDelimiter = AbstractNodeFactory.createToken((SyntaxKind)(isClosed ? SyntaxKind.CLOSE_BRACE_PIPE_TOKEN : SyntaxKind.CLOSE_BRACE_TOKEN));
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)recordKeyWord, (Token)bodyStartDelimiter, (io.ballerina.compiler.syntax.tree.NodeList)fieldNodes, null, (Token)bodyEndDelimiter);
        recordToElementNodes.put(xmlNodeName, xmlElement);
        recordToTypeDescNodes.put(xmlNodeName, (NonTerminalNode)recordTypeDescriptorNode);
    }

    private static List<Node> getRecordFieldsForXMLElement(Element xmlElement, boolean isClosed, Map<String, NonTerminalNode> recordToTypeDescNodes, Map<String, AnnotationNode> recordToAnnotationNodes, Map<String, Element> recordToElementNodes, List<DiagnosticMessage> diagnosticMessages, String textFieldName, boolean withNameSpace, boolean withoutAttributes, boolean withoutAttributeAnnot) {
        ArrayList<Node> recordFields = new ArrayList<Node>();
        String xmlNodeName = xmlElement.getNodeName();
        NodeList xmlNodeList = xmlElement.getChildNodes();
        for (int i = 0; i < xmlNodeList.getLength(); ++i) {
            RecordFieldNode updatedRecordField;
            RecordFieldNode existingRecordField;
            int indexOfRecordFieldNode;
            Map<String, Boolean> prefixMap;
            org.w3c.dom.Node xmlNode = xmlNodeList.item(i);
            if (xmlNode.getNodeType() != 1) continue;
            Element xmlElementNode = (Element)xmlNode;
            boolean isLeafXMLElementNode = XMLToRecordConverter.isLeafXMLElementNode(xmlElementNode);
            NamedNodeMap xmlAttributesMap = xmlElementNode.getAttributes();
            if (!isLeafXMLElementNode || !withoutAttributes && (xmlAttributesMap.getLength() > 1 || xmlAttributesMap.getLength() == 1 && !XMLNS_PREFIX.equals(xmlAttributesMap.item(0).getPrefix()))) {
                XMLToRecordConverter.generateRecords(xmlElementNode, isClosed, recordToTypeDescNodes, recordToAnnotationNodes, recordToElementNodes, diagnosticMessages, textFieldName, withNameSpace, withoutAttributes, withoutAttributeAnnot);
            }
            RecordFieldNode recordField = XMLToRecordConverter.getRecordField(xmlElementNode, false, withNameSpace, (prefixMap = XMLToRecordConverter.hasMultipleFieldsWithSameName(xmlNodeList, xmlElementNode.getLocalName())).size() > 1, withoutAttributes);
            if (withNameSpace && xmlElementNode.getPrefix() != null) {
                indexOfRecordFieldNode = IntStream.range(0, recordFields.size()).filter(j -> ((RecordFieldNode)recordFields.get(j)).fieldName().text().equals(recordField.fieldName().text()) && (Boolean)prefixMap.get(xmlElementNode.getPrefix()) != false).findFirst().orElse(-1);
                if (indexOfRecordFieldNode == -1) {
                    if (prefixMap.size() > 1) {
                        XMLToRecordConverter.generateRecordFieldForSameLocalNameElements(recordFields, xmlElementNode, recordField);
                        continue;
                    }
                    recordFields.add((Node)recordField);
                    continue;
                }
                existingRecordField = (RecordFieldNode)recordFields.remove(indexOfRecordFieldNode);
                updatedRecordField = XMLToRecordConverter.mergeRecordFields(existingRecordField, recordField);
                if (prefixMap.size() > 1) {
                    XMLToRecordConverter.generateRecordFieldForSameLocalNameElements(recordFields, xmlElementNode, updatedRecordField);
                    continue;
                }
                recordFields.add(indexOfRecordFieldNode, (Node)updatedRecordField);
                continue;
            }
            indexOfRecordFieldNode = IntStream.range(0, recordFields.size()).filter(j -> ((RecordFieldNode)recordFields.get(j)).fieldName().text().equals(recordField.fieldName().text())).findFirst().orElse(-1);
            if (indexOfRecordFieldNode == -1) {
                recordFields.add((Node)recordField);
                continue;
            }
            existingRecordField = (RecordFieldNode)recordFields.remove(indexOfRecordFieldNode);
            updatedRecordField = XMLToRecordConverter.mergeRecordFields(existingRecordField, recordField);
            recordFields.add(indexOfRecordFieldNode, (Node)updatedRecordField);
        }
        NamedNodeMap xmlAttributesMap = xmlElement.getAttributes();
        HashSet<String> elementNames = new HashSet<String>();
        for (int j2 = 0; j2 < xmlNodeList.getLength(); ++j2) {
            elementNames.add(xmlNodeList.item(j2).getNodeName());
        }
        for (int i = 0; i < xmlAttributesMap.getLength(); ++i) {
            org.w3c.dom.Node xmlNode = xmlAttributesMap.item(i);
            if (xmlNode.getNodeType() != 2) continue;
            if ((xmlNode.getPrefix() == null && XMLNS_PREFIX.equals(xmlNode.getLocalName()) || XMLNS_PREFIX.equals(xmlNode.getPrefix()) && xmlNode.getLocalName().equals(xmlElement.getPrefix())) && withNameSpace) {
                String prefix = xmlElement.getPrefix();
                if (xmlElement.getPrefix() != null && xmlElement.getPrefix().equals(xmlNode.getLocalName())) {
                    prefix = xmlNode.getLocalName();
                }
                AnnotationNode xmlNSNode = XMLToRecordConverter.getXMLNamespaceNode(prefix, xmlNode.getNodeValue());
                recordToAnnotationNodes.put(xmlNodeName, xmlNSNode);
                continue;
            }
            if (XMLToRecordConverter.isLeafXMLElementNode(xmlElement) || XMLNS_PREFIX.equals(xmlNode.getPrefix()) || XMLNS_PREFIX.equals(xmlNode.getLocalName()) || withoutAttributes || elementNames.contains(xmlNode.getNodeName())) continue;
            Node recordField = XMLToRecordConverter.getRecordField(xmlNode, withNameSpace, withoutAttributeAnnot);
            recordFields.add(recordField);
        }
        int attributeLength = xmlElement.getAttributes().getLength();
        org.w3c.dom.Node attributeItem = xmlElement.getAttributes().item(0);
        if (XMLToRecordConverter.isLeafXMLElementNode(xmlElement) && attributeLength > 0 && !withoutAttributes) {
            if (attributeLength == 1 && attributeItem.getPrefix() != null && XMLNS_PREFIX.equals(attributeItem.getPrefix())) {
                return recordFields;
            }
            Token fieldType = ConverterUtils.getPrimitiveTypeName(xmlElement.getFirstChild().getNodeValue());
            BuiltinSimpleNameReferenceNode fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)fieldType.kind(), (Token)fieldType);
            IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)(textFieldName == null ? ConverterUtils.escapeIdentifier("#content") : textFieldName));
            Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
            RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, null, (Token)semicolon);
            recordFields.add((Node)recordFieldNode);
            for (int j3 = 0; j3 < attributeLength; ++j3) {
                org.w3c.dom.Node xmlAttributeNode = xmlElement.getAttributes().item(j3);
                if (xmlAttributeNode.getNodeType() != 2 || XMLNS_PREFIX.equals(xmlAttributeNode.getPrefix()) || XMLNS_PREFIX.equals(xmlAttributeNode.getLocalName())) continue;
                Node recordField = XMLToRecordConverter.getRecordField(xmlAttributeNode, withNameSpace, withoutAttributeAnnot);
                recordFields.add(recordField);
            }
        }
        return recordFields;
    }

    private static void generateRecordFieldForSameLocalNameElements(List<Node> recordFields, Element xmlElementNode, RecordFieldNode recordField) {
        recordFields.add((Node)recordField.modify().withFieldName((Token)AbstractNodeFactory.createIdentifierToken((String)(xmlElementNode.getPrefix() + xmlElementNode.getLocalName().substring(0, 1).toUpperCase(Locale.ENGLISH) + xmlElementNode.getLocalName().substring(1)))).apply());
    }

    private static Map<String, Boolean> hasMultipleFieldsWithSameName(NodeList xmlNodeList, String fieldName) {
        String defaultNamespace = "";
        HashMap<String, Boolean> prefixMap = new HashMap<String, Boolean>();
        for (int i = 0; i < xmlNodeList.getLength(); ++i) {
            org.w3c.dom.Node xmlNode = xmlNodeList.item(i);
            if (xmlNode.getNodeType() != 1) continue;
            Element xmlElementNode = (Element)xmlNode;
            if (!xmlNode.getLocalName().equals(fieldName)) continue;
            String prefix = xmlElementNode.getPrefix() == null ? defaultNamespace : xmlElementNode.getPrefix();
            prefixMap.put(prefix, prefixMap.containsKey(prefix));
        }
        return prefixMap;
    }

    private static List<Node> updateRecordFields(Map<String, RecordFieldNode> previousRecordFieldToNodes, Map<String, RecordFieldNode> newRecordFieldToNodes) {
        RecordFieldNode updatedRecordFieldNode;
        Object questionMarkToken;
        ArrayList<Node> updatedRecordFields = new ArrayList<Node>();
        for (Map.Entry<String, RecordFieldNode> previousRecordFieldToNode : previousRecordFieldToNodes.entrySet()) {
            RecordFieldNode prevRecordFieldNode = previousRecordFieldToNode.getValue();
            RecordFieldNode newRecordFieldNode = newRecordFieldToNodes.get(previousRecordFieldToNode.getKey());
            if (newRecordFieldToNodes.containsKey(previousRecordFieldToNode.getKey())) {
                TypeDescriptorNode prevTypeDescNode = (TypeDescriptorNode)prevRecordFieldNode.typeName();
                TypeDescriptorNode newTypeDescNode = (TypeDescriptorNode)newRecordFieldNode.typeName();
                MetadataNode metadataNode = prevRecordFieldNode.metadata().orElse(newRecordFieldNode.metadata().orElse(null));
                Token optionalToken = prevRecordFieldNode.questionMarkToken().orElse(newRecordFieldNode.questionMarkToken().orElse(null));
                if (prevTypeDescNode.toSourceCode().equals(newTypeDescNode.toSourceCode())) {
                    RecordFieldNode updatedRecordFieldNode2 = prevRecordFieldNode.modify().withMetadata(metadataNode).withQuestionMarkToken(optionalToken).apply();
                    updatedRecordFields.add((Node)updatedRecordFieldNode2);
                    continue;
                }
                List<TypeDescriptorNode> typeDescNodesSorted = ConverterUtils.sortTypeDescriptorNodes(ConverterUtils.extractTypeDescriptorNodes(List.of(prevTypeDescNode, newTypeDescNode)));
                TypeDescriptorNode unionTypeDescNode = XMLToRecordConverter.createUnionTypeDescriptorNode(typeDescNodesSorted);
                RecordFieldNode updatedRecordFieldNode3 = prevRecordFieldNode.modify().withMetadata(metadataNode).withTypeName((Node)unionTypeDescNode).withQuestionMarkToken(optionalToken).apply();
                updatedRecordFields.add((Node)updatedRecordFieldNode3);
                continue;
            }
            questionMarkToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
            updatedRecordFieldNode = prevRecordFieldNode.modify().withQuestionMarkToken((Token)questionMarkToken).apply();
            updatedRecordFields.add((Node)updatedRecordFieldNode);
        }
        for (int i = 0; i < newRecordFieldToNodes.size(); ++i) {
            String newRecordFieldName;
            List<String> updatedRecordFieldNames = updatedRecordFields.stream().map(node -> ((RecordFieldNode)node).fieldName().toSourceCode()).toList();
            if (updatedRecordFieldNames.contains(newRecordFieldName = (String)newRecordFieldToNodes.keySet().stream().toList().get(i))) continue;
            int insertIndex = -1;
            for (String newRecordFieldToNodeKey : newRecordFieldToNodes.keySet().stream().toList().subList(i + 1, newRecordFieldToNodes.size())) {
                insertIndex = previousRecordFieldToNodes.keySet().stream().toList().indexOf(newRecordFieldToNodeKey);
                if (insertIndex == -1) continue;
                break;
            }
            questionMarkToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
            updatedRecordFieldNode = newRecordFieldToNodes.get(newRecordFieldToNodes.keySet().stream().toList().get(i)).modify().withQuestionMarkToken((Token)questionMarkToken).apply();
            if (insertIndex != -1) {
                updatedRecordFields.add(insertIndex, (Node)updatedRecordFieldNode);
                continue;
            }
            updatedRecordFields.add((Node)updatedRecordFieldNode);
        }
        return updatedRecordFields;
    }

    private static RecordFieldNode getRecordField(Element xmlElementNode, boolean isOptionalField, boolean withNameSpace, boolean sameFieldExists, boolean withoutAttributes) {
        Token typeName;
        Token questionMarkToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier(xmlElementNode.getLocalName().trim()));
        Token optionalFieldToken = isOptionalField ? questionMarkToken : null;
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        NamedNodeMap xmlAttributesMap = xmlElementNode.getAttributes();
        if (XMLToRecordConverter.isLeafXMLElementNode(xmlElementNode) && (xmlAttributesMap.getLength() == 0 || xmlAttributesMap.getLength() == 1 && XMLNS_PREFIX.equals(xmlAttributesMap.item(0).getPrefix()) || withoutAttributes)) {
            typeName = ConverterUtils.getPrimitiveTypeName(xmlElementNode.getFirstChild().getNodeValue());
        } else {
            String elementKey = xmlElementNode.getNodeName().trim();
            String type = XMLToRecordConverter.getRecordName(elementKey);
            typeName = AbstractNodeFactory.createIdentifierToken((String)type);
        }
        ArrayList<AnnotationNode> xmlNameNode = new ArrayList<AnnotationNode>();
        if (sameFieldExists) {
            xmlNameNode.add(XMLToRecordConverter.getXMLNameNode(xmlElementNode.getLocalName()));
            xmlNameNode.add(XMLToRecordConverter.getXMLNamespaceNode(xmlElementNode.getPrefix(), xmlElementNode.getNamespaceURI()));
        } else {
            xmlNameNode.add(XMLToRecordConverter.getXMLNamespaceNode(xmlElementNode.getPrefix(), xmlElementNode.getNamespaceURI()));
        }
        io.ballerina.compiler.syntax.tree.NodeList annotationNodes = NodeFactory.createNodeList(xmlNameNode);
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (io.ballerina.compiler.syntax.tree.NodeList)annotationNodes);
        BuiltinSimpleNameReferenceNode fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
        if (!withNameSpace) {
            return NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        }
        return xmlElementNode.getNamespaceURI() == null ? NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken) : NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
    }

    private static Node getRecordField(org.w3c.dom.Node xmlAttributeNode, boolean withNamespace, boolean withoutAttributeAnnot) {
        MetadataNode metadataNode;
        Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD);
        BuiltinSimpleNameReferenceNode fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)ConverterUtils.escapeIdentifier(xmlAttributeNode.getLocalName()));
        Token equalToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (withNamespace && xmlAttributeNode.getPrefix() != null && xmlAttributeNode.getNamespaceURI() != null) {
            annotations.add(XMLToRecordConverter.getXMLNamespaceNode(xmlAttributeNode.getPrefix(), xmlAttributeNode.getNamespaceURI()));
        }
        annotations.add(XMLToRecordConverter.getXMLAttributeNode());
        io.ballerina.compiler.syntax.tree.NodeList annotationNodes = NodeFactory.createNodeList(annotations);
        MetadataNode metadataNode2 = metadataNode = withoutAttributeAnnot ? null : NodeFactory.createMetadataNode(null, (io.ballerina.compiler.syntax.tree.NodeList)annotationNodes);
        if (xmlAttributeNode.getPrefix() != null && xmlAttributeNode.getPrefix().equals(XMLNS_PREFIX)) {
            MinutiaeList emptyMinutiaeList = AbstractNodeFactory.createEmptyMinutiaeList();
            LiteralValueToken literalToken = NodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)String.format("\"%s\"", xmlAttributeNode.getTextContent()), (MinutiaeList)emptyMinutiaeList, (MinutiaeList)emptyMinutiaeList);
            BasicLiteralNode valueExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)literalToken);
            return NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, (Token)equalToken, (ExpressionNode)valueExpr, (Token)semicolonToken);
        }
        return NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldName, null, (Token)semicolonToken);
    }

    private static RecordFieldNode mergeRecordFields(RecordFieldNode existingRecordFieldNode, RecordFieldNode newRecordFieldNode) {
        TypeDescriptorNode existingTypeName = (TypeDescriptorNode)existingRecordFieldNode.typeName();
        TypeDescriptorNode newTypeName = (TypeDescriptorNode)newRecordFieldNode.typeName();
        if (existingTypeName.kind().equals((Object)SyntaxKind.ARRAY_TYPE_DESC)) {
            TypeDescriptorNode memberTypeDescNode = ((ArrayTypeDescriptorNode)existingTypeName).memberTypeDesc();
            if (memberTypeDescNode.toSourceCode().strip().equals(newTypeName.toSourceCode().strip())) {
                return existingRecordFieldNode;
            }
            Token openParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
            Token closeParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
            List<TypeDescriptorNode> extractedTypeDescNodes = ConverterUtils.extractUnionTypeDescNode(memberTypeDescNode);
            if (extractedTypeDescNodes.stream().filter(node -> node.toSourceCode().equals(newTypeName.toSourceCode())).findFirst().isEmpty()) {
                extractedTypeDescNodes.add(newTypeName);
            }
            List<TypeDescriptorNode> sortedTypeDescNodes = ConverterUtils.sortTypeDescriptorNodes(extractedTypeDescNodes);
            TypeDescriptorNode unionTypeDescNode = XMLToRecordConverter.joinToUnionTypeDescriptorNode(sortedTypeDescNodes);
            ParenthesisedTypeDescriptorNode parenTypeDescNode = NodeFactory.createParenthesisedTypeDescriptorNode((Token)openParenToken, (TypeDescriptorNode)unionTypeDescNode, (Token)closeParenToken);
            ArrayTypeDescriptorNode updatedTypeName = XMLToRecordConverter.getArrayTypeDesc((TypeDescriptorNode)parenTypeDescNode);
            return existingRecordFieldNode.modify().withTypeName((Node)updatedTypeName).apply();
        }
        if (existingTypeName.toSourceCode().strip().equals(newTypeName.toSourceCode().strip())) {
            ArrayTypeDescriptorNode updatedTypeName = XMLToRecordConverter.getArrayTypeDesc(existingTypeName);
            return existingRecordFieldNode.modify().withTypeName((Node)updatedTypeName).apply();
        }
        Token openParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        Token closeParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        List<TypeDescriptorNode> sortedTypeDescNodes = ConverterUtils.sortTypeDescriptorNodes(List.of(existingTypeName, newTypeName));
        TypeDescriptorNode unionTypeDescNode = XMLToRecordConverter.joinToUnionTypeDescriptorNode(sortedTypeDescNodes);
        ParenthesisedTypeDescriptorNode parenTypeDescNode = NodeFactory.createParenthesisedTypeDescriptorNode((Token)openParenToken, (TypeDescriptorNode)unionTypeDescNode, (Token)closeParenToken);
        ArrayTypeDescriptorNode updatedTypeName = XMLToRecordConverter.getArrayTypeDesc((TypeDescriptorNode)parenTypeDescNode);
        return existingRecordFieldNode.modify().withTypeName((Node)updatedTypeName).apply();
    }

    private static ArrayTypeDescriptorNode getArrayTypeDesc(TypeDescriptorNode typeDescNode) {
        Token openSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN);
        Token closeSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN);
        ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)openSBracketToken, null, (Token)closeSBracketToken);
        io.ballerina.compiler.syntax.tree.NodeList arrayDimensions = NodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimension});
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)typeDescNode, (io.ballerina.compiler.syntax.tree.NodeList)arrayDimensions);
    }

    private static TypeDescriptorNode joinToUnionTypeDescriptorNode(List<TypeDescriptorNode> typeNames) {
        Token pipeToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN);
        TypeDescriptorNode unionTypeDescNode = typeNames.get(0);
        for (int i = 1; i < typeNames.size(); ++i) {
            unionTypeDescNode = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)unionTypeDescNode, (Token)pipeToken, (TypeDescriptorNode)typeNames.get(i));
        }
        return unionTypeDescNode;
    }

    private static TypeDescriptorNode createUnionTypeDescriptorNode(List<TypeDescriptorNode> typeNames) {
        if (typeNames.isEmpty()) {
            Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ANYDATA_KEYWORD);
            return NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
        }
        if (typeNames.size() == 1) {
            return typeNames.get(0);
        }
        TypeDescriptorNode unionTypeDescNode = XMLToRecordConverter.joinToUnionTypeDescriptorNode(typeNames);
        Token openParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        Token closeParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        return NodeFactory.createParenthesisedTypeDescriptorNode((Token)openParenToken, (TypeDescriptorNode)unionTypeDescNode, (Token)closeParenToken);
    }

    private static boolean isLeafXMLElementNode(Element xmlElement) {
        return xmlElement.getChildNodes().getLength() == 1 && xmlElement.getChildNodes().item(0).getNodeType() == 3;
    }

    private static String getRecordName(String xmlElementNodeName) {
        if (xmlElementNodeName.contains(COLON)) {
            return Arrays.stream(xmlElementNodeName.split(COLON)).map(val -> ConverterUtils.escapeIdentifier(StringUtils.capitalize((String)val))).collect(Collectors.joining("_"));
        }
        return ConverterUtils.escapeIdentifier(StringUtils.capitalize((String)xmlElementNodeName));
    }

    private static AnnotationNode getXMLNameNode(String value) {
        Token atToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN);
        IdentifierToken modulePrefix = AbstractNodeFactory.createIdentifierToken((String)XMLDATA);
        Token colon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        IdentifierToken identifier = AbstractNodeFactory.createIdentifierToken((String)"Name");
        QualifiedNameReferenceNode annotReference = NodeFactory.createQualifiedNameReferenceNode((Token)modulePrefix, (Node)colon, (IdentifierToken)identifier);
        Token openBrace = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
        Token closeBrace = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)"value");
        MinutiaeList emptyMinutiaeList = AbstractNodeFactory.createEmptyMinutiaeList();
        LiteralValueToken literalToken = NodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)String.format("\"%s\"", value), (MinutiaeList)emptyMinutiaeList, (MinutiaeList)emptyMinutiaeList);
        BasicLiteralNode valueExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)literalToken);
        SpecificFieldNode mappingField = NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colon, (ExpressionNode)valueExpr);
        SeparatedNodeList mappingFields = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{mappingField});
        MappingConstructorExpressionNode annotValue = NodeFactory.createMappingConstructorExpressionNode((Token)openBrace, (SeparatedNodeList)mappingFields, (Token)closeBrace);
        return NodeFactory.createAnnotationNode((Token)atToken, (Node)annotReference, (MappingConstructorExpressionNode)annotValue);
    }

    private static AnnotationNode getXMLNamespaceNode(String prefix, String uri) {
        Token atToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN);
        IdentifierToken modulePrefix = AbstractNodeFactory.createIdentifierToken((String)XMLDATA);
        Token colon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        IdentifierToken identifier = AbstractNodeFactory.createIdentifierToken((String)"Namespace");
        QualifiedNameReferenceNode annotReference = NodeFactory.createQualifiedNameReferenceNode((Token)modulePrefix, (Node)colon, (IdentifierToken)identifier);
        ArrayList<Object> mappingFields = new ArrayList<Object>();
        Token openBrace = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
        Token closeBrace = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
        MinutiaeList emptyMinutiaeList = AbstractNodeFactory.createEmptyMinutiaeList();
        if (prefix != null) {
            IdentifierToken prefixFieldName = AbstractNodeFactory.createIdentifierToken((String)"prefix");
            LiteralValueToken prefixLiteralToken = NodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)String.format("\"%s\"", prefix), (MinutiaeList)emptyMinutiaeList, (MinutiaeList)emptyMinutiaeList);
            BasicLiteralNode prefixValueExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)prefixLiteralToken);
            SpecificFieldNode prefixMappingField = NodeFactory.createSpecificFieldNode(null, (Node)prefixFieldName, (Token)colon, (ExpressionNode)prefixValueExpr);
            mappingFields.add(prefixMappingField);
            mappingFields.add(NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        IdentifierToken uriFieldName = AbstractNodeFactory.createIdentifierToken((String)"uri");
        LiteralValueToken uriLiteralToken = NodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)String.format("\"%s\"", uri), (MinutiaeList)emptyMinutiaeList, (MinutiaeList)emptyMinutiaeList);
        BasicLiteralNode uriValueExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)uriLiteralToken);
        SpecificFieldNode uriMappingField = NodeFactory.createSpecificFieldNode(null, (Node)uriFieldName, (Token)colon, (ExpressionNode)uriValueExpr);
        mappingFields.add(uriMappingField);
        SeparatedNodeList mappingFieldNodes = AbstractNodeFactory.createSeparatedNodeList(mappingFields);
        MappingConstructorExpressionNode annotValue = NodeFactory.createMappingConstructorExpressionNode((Token)openBrace, (SeparatedNodeList)mappingFieldNodes, (Token)closeBrace);
        return NodeFactory.createAnnotationNode((Token)atToken, (Node)annotReference, (MappingConstructorExpressionNode)annotValue);
    }

    private static AnnotationNode getXMLAttributeNode() {
        Token atToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN);
        IdentifierToken modulePrefix = AbstractNodeFactory.createIdentifierToken((String)XMLDATA);
        Token colon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        IdentifierToken identifier = AbstractNodeFactory.createIdentifierToken((String)"Attribute");
        QualifiedNameReferenceNode annotReference = NodeFactory.createQualifiedNameReferenceNode((Token)modulePrefix, (Node)colon, (IdentifierToken)identifier);
        return NodeFactory.createAnnotationNode((Token)atToken, (Node)annotReference, null);
    }
}

