/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint;

import io.ballerina.runtime.api.types.AnnotatableType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.ErrorUtils;
import io.ballerina.stdlib.constraint.InternalValidationException;
import io.ballerina.stdlib.constraint.annotations.AbstractAnnotations;
import io.ballerina.stdlib.constraint.annotations.RecordFieldAnnotations;
import io.ballerina.stdlib.constraint.annotations.TypeAnnotations;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Constraints {
    public static Object validate(Object value, BTypedesc typedesc) {
        Type type = typedesc.getDescribingType();
        try {
            value = Constraints.cloneWithTargetType(value, type);
        }
        catch (BError e) {
            return ErrorUtils.buildTypeConversionError(e);
        }
        try {
            List<ConstraintErrorInfo> failedConstraintsInfo = Constraints.validateAfterTypeConversionInternal(value, type, "$", false);
            if (!failedConstraintsInfo.isEmpty()) {
                return ErrorUtils.buildValidationError(failedConstraintsInfo);
            }
            return value;
        }
        catch (InternalValidationException e) {
            return ErrorUtils.createGenericError(e.getMessage());
        }
        catch (RuntimeException e) {
            return ErrorUtils.buildUnexpectedError(e);
        }
    }

    public static Object validateAfterTypeConversion(Object value, Type type) {
        try {
            List<ConstraintErrorInfo> failedConstraints = Constraints.validateAfterTypeConversionInternal(value, type, "$", false);
            if (!failedConstraints.isEmpty()) {
                return ErrorUtils.buildValidationError(failedConstraints);
            }
            return value;
        }
        catch (InternalValidationException e) {
            return ErrorUtils.createGenericError(e.getMessage());
        }
        catch (RuntimeException e) {
            return ErrorUtils.buildUnexpectedError(e);
        }
    }

    private static List<ConstraintErrorInfo> validateArrayMembers(Object value, ArrayType type, String path) {
        Type memberType = type.getElementType();
        BArray members = (BArray)value;
        ArrayList<ConstraintErrorInfo> failedConstraints = new ArrayList<ConstraintErrorInfo>();
        int i = 0;
        while ((long)i < members.getLength()) {
            failedConstraints.addAll(Constraints.validateAfterTypeConversionInternal(members.get((long)i), memberType, path + "[" + i + "]", true));
            ++i;
        }
        return failedConstraints;
    }

    private static List<ConstraintErrorInfo> validateAfterTypeConversionInternal(Object value, Type type, String path, boolean isMemberValue) {
        Optional<Type> matchingType;
        if (type instanceof ArrayType) {
            return Constraints.validateArrayMembers(value, (ArrayType)type, path);
        }
        ArrayList<ConstraintErrorInfo> failedConstraintsInfo = new ArrayList<ConstraintErrorInfo>();
        if (type.isReadOnly()) {
            type = Constraints.getTypeFromReadOnly(type);
        }
        if (type instanceof AnnotatableType) {
            AbstractAnnotations annotations = Constraints.getAnnotationImpl(type, failedConstraintsInfo);
            annotations.validate(value, (AnnotatableType)type, path, isMemberValue);
        } else if (type instanceof UnionType && (matchingType = Constraints.getMatchingType(value, type)).isPresent()) {
            return Constraints.validateAfterTypeConversionInternal(value, matchingType.get(), path, isMemberValue);
        }
        return failedConstraintsInfo;
    }

    private static Type getTypeFromReadOnly(Type type) {
        List constituentTypes;
        IntersectionType intersectionType = null;
        if (type instanceof RecordType) {
            Optional optionalIntersectionType = ((RecordType)type).getIntersectionType();
            if (optionalIntersectionType.isPresent()) {
                intersectionType = (IntersectionType)optionalIntersectionType.get();
            }
        } else if (type instanceof IntersectionType) {
            intersectionType = (IntersectionType)type;
        }
        if (intersectionType != null && (constituentTypes = intersectionType.getConstituentTypes()).size() == 2) {
            type = ((Type)constituentTypes.get(0)).getTag() == 51 ? TypeUtils.getReferredType((Type)((Type)constituentTypes.get(1))) : TypeUtils.getReferredType((Type)((Type)constituentTypes.get(0)));
        }
        return type;
    }

    private static Optional<Type> getMatchingType(Object value, Type type) {
        Type valueType = value instanceof BMap ? ((BMap)value).getTypedesc().getDescribingType() : TypeUtils.getType((Object)value);
        for (Type typ : ((UnionType)type).getMemberTypes()) {
            if (!TypeUtils.getReferredType((Type)typ).equals((Object)valueType)) continue;
            return Optional.of(typ);
        }
        return Optional.empty();
    }

    private static AbstractAnnotations getAnnotationImpl(Type type, List<ConstraintErrorInfo> failedConstraints) {
        if (type instanceof RecordType) {
            return new RecordFieldAnnotations(failedConstraints);
        }
        return new TypeAnnotations(failedConstraints);
    }

    private static Object cloneWithTargetType(Object value, Type targetType) {
        return TypeUtils.isSameType((Type)TypeUtils.getType((Object)value), (Type)targetType) ? value : ValueUtils.convert((Object)value, (Type)targetType);
    }

    private Constraints() {
    }
}

