/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.ModuleUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ErrorUtils {
    private static final String UNEXPECTED_ERROR_MESSAGE = "Unexpected error found due to typedesc and value mismatch.";
    private static final String TYPE_CONVERSION_ERROR_MESSAGE = "Type conversion failed due to typedesc and value mismatch.";
    private static final String VALIDATION_ERROR_MESSAGE_PREFIX = "Validation failed for ";
    private static final String VALIDATION_ERROR_MESSAGE_SUFFIX = " constraint(s)";

    private ErrorUtils() {
    }

    static BError buildUnexpectedError(RuntimeException e) {
        if (e instanceof BError) {
            return ErrorUtils.createError(UNEXPECTED_ERROR_MESSAGE, (BError)((Object)e), "Error");
        }
        return ErrorUtils.createGenericError(UNEXPECTED_ERROR_MESSAGE);
    }

    static BError buildValidationError(List<ConstraintErrorInfo> failedConstraintsInfo) {
        ArrayList<String> customErrorMsgList = new ArrayList<String>();
        ArrayList<String> restErrorMsgList = new ArrayList<String>();
        ArrayList<String> causeMsgList = new ArrayList<String>();
        for (ConstraintErrorInfo constraintErrorInfo : failedConstraintsInfo) {
            causeMsgList.add(constraintErrorInfo.getFailedConstraintsWithPath());
            if (constraintErrorInfo.hasMessage()) {
                customErrorMsgList.add(constraintErrorInfo.getMessage());
                continue;
            }
            restErrorMsgList.add(constraintErrorInfo.getFailedConstraintsWithPath());
        }
        if (customErrorMsgList.isEmpty()) {
            return ErrorUtils.createError(ErrorUtils.buildDefaultErrorMessage(causeMsgList));
        }
        BError cause = ErrorUtils.createGenericError(ErrorUtils.buildDefaultErrorMessage(causeMsgList));
        if (!restErrorMsgList.isEmpty()) {
            customErrorMsgList.add(ErrorUtils.buildDefaultErrorMessage(restErrorMsgList));
        }
        return ErrorUtils.createError(ErrorUtils.buildErrorMessage(customErrorMsgList), cause);
    }

    static String buildDefaultErrorMessage(List<String> failedConstraints) {
        Collections.sort(failedConstraints);
        StringBuilder errorMsg = new StringBuilder(VALIDATION_ERROR_MESSAGE_PREFIX);
        for (String constraint : failedConstraints) {
            errorMsg.append("'").append(constraint).append("',");
        }
        errorMsg.deleteCharAt(errorMsg.length() - 1);
        errorMsg.append(VALIDATION_ERROR_MESSAGE_SUFFIX).append(".");
        return errorMsg.toString();
    }

    static String buildErrorMessage(List<String> list) {
        int size = list.size();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append(ErrorUtils.trimMessage(list.get(i)));
            if (i < size - 2) {
                builder.append(", ");
                continue;
            }
            if (i != size - 2) continue;
            builder.append(" and ");
        }
        builder.append(".");
        return builder.toString();
    }

    static String trimMessage(String message) {
        if ((message = message.trim()).endsWith(".")) {
            return message.substring(0, message.length() - 1);
        }
        return message;
    }

    static BError buildTypeConversionError(BError err) {
        return ErrorUtils.createError(TYPE_CONVERSION_ERROR_MESSAGE, err, "TypeConversionError");
    }

    static BError createGenericError(String errMessage) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"Error", (BString)StringUtils.fromString((String)errMessage), null, null);
    }

    static BError createError(String errMessage) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"ValidationError", (BString)StringUtils.fromString((String)errMessage), null, null);
    }

    static BError createError(String errMessage, BError err, String errorType) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)errorType, (BString)StringUtils.fromString((String)errMessage), (BError)err, null);
    }

    static BError createError(String errMessage, BError err) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"ValidationError", (BString)StringUtils.fromString((String)errMessage), (BError)err, null);
    }
}

