/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.validators.interfaces.LengthValidator;
import io.ballerina.stdlib.constraint.validators.interfaces.PatternValidator;
import java.util.List;
import java.util.Map;

public class StringConstraintValidator
implements LengthValidator,
PatternValidator {
    private final List<ConstraintErrorInfo> failedConstraintsInfo;

    public StringConstraintValidator(List<ConstraintErrorInfo> failedConstraintsInfo) {
        this.failedConstraintsInfo = failedConstraintsInfo;
    }

    public void validate(BMap<BString, Object> constraints, String fieldValue, String path, boolean isMemberValue) {
        for (Map.Entry constraint : constraints.entrySet()) {
            LengthValidator.super.checkLengthConstraintValue(constraint, path);
            this.validate(constraint, fieldValue, isMemberValue, this.failedConstraintsInfo, path);
        }
    }

    @Override
    public void validate(Map.Entry<BString, Object> constraint, Object fieldValue, boolean isMemberValue, List<ConstraintErrorInfo> failedConstraintsInfo, String path) {
        LengthValidator.super.validate(constraint, fieldValue, isMemberValue, failedConstraintsInfo, path);
        PatternValidator.super.validate(constraint, fieldValue, isMemberValue, failedConstraintsInfo, path);
    }

    @Override
    public boolean validateLength(Object fieldValue, long constraintValue) {
        return (long)((String)fieldValue).length() == constraintValue;
    }

    @Override
    public boolean validateMinLength(Object fieldValue, long constraintValue) {
        return (long)((String)fieldValue).length() >= constraintValue;
    }

    @Override
    public boolean validateMaxLength(Object fieldValue, long constraintValue) {
        return (long)((String)fieldValue).length() <= constraintValue;
    }
}

