/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.client;

import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.email.util.CommonUtil;
import io.ballerina.stdlib.email.util.EmailAccessUtil;
import io.ballerina.stdlib.email.util.EmailConstants;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAccessClient {
    private static final Logger log = LoggerFactory.getLogger(EmailAccessClient.class);
    private static final FlagTerm UNSEEN_FLAG = new FlagTerm(new Flags(Flags.Flag.SEEN), false);

    private EmailAccessClient() {
    }

    public static Object initPopClientEndpoint(BObject clientEndpoint, BString host, BString username, BString password, BMap<BString, Object> config) {
        Properties properties;
        try {
            properties = EmailAccessUtil.getPopProperties(config, host.getValue());
        }
        catch (IOException | GeneralSecurityException e) {
            log.debug("Error while initializing POP3 client properties : ", (Throwable)e);
            return CommonUtil.getBallerinaError("Error", "Error while initializing POP3 client properties: " + e.getMessage());
        }
        Session session = Session.getInstance((Properties)properties, null);
        try {
            Store store = session.getStore("pop3");
            store.connect(host.getValue(), username.getValue(), password.getValue());
            clientEndpoint.addNativeData("store", (Object)store);
            clientEndpoint.addNativeData(EmailConstants.PROPS_HOST.getValue(), (Object)host.getValue());
            clientEndpoint.addNativeData(EmailConstants.PROPS_USERNAME.getValue(), (Object)username.getValue());
            clientEndpoint.addNativeData(EmailConstants.PROPS_PASSWORD.getValue(), (Object)password.getValue());
        }
        catch (MessagingException e) {
            log.debug("Error while connecting to the POP3 store : ", (Throwable)e);
            return CommonUtil.getBallerinaError("Error", "Error while connecting to the POP3 store: " + e.getMessage());
        }
        return null;
    }

    public static Object initImapClientEndpoint(BObject clientEndpoint, BString host, BString username, BString password, BMap<BString, Object> config) {
        Properties properties;
        try {
            properties = EmailAccessUtil.getImapProperties(config, host.getValue());
        }
        catch (IOException | GeneralSecurityException e) {
            log.debug("Error while initializing IMAP client properties : ", (Throwable)e);
            return CommonUtil.getBallerinaError("Error", "Error while initializing IMAP client properties: " + e.getMessage());
        }
        Session session = Session.getInstance((Properties)properties, null);
        try {
            Store store = session.getStore("imap");
            store.connect(host.getValue(), username.getValue(), password.getValue());
            clientEndpoint.addNativeData("store", (Object)store);
            clientEndpoint.addNativeData(EmailConstants.PROPS_HOST.getValue(), (Object)host.getValue());
            clientEndpoint.addNativeData(EmailConstants.PROPS_USERNAME.getValue(), (Object)username.getValue());
            clientEndpoint.addNativeData(EmailConstants.PROPS_PASSWORD.getValue(), (Object)password.getValue());
        }
        catch (MessagingException e) {
            log.debug("Error while connecting to the IMAP store : ", (Throwable)e);
            return CommonUtil.getBallerinaError("Error", "Error while connecting to the IMAP store: " + e.getMessage());
        }
        return null;
    }

    public static Object readMessage(BObject clientConnector, BString folderName, BDecimal timeout) {
        if (timeout.intValue() == 0L) {
            return EmailAccessClient.readMessageFromFolder(clientConnector, folderName);
        }
        BDecimal polling = BDecimal.valueOf((int)100);
        double pollingInterval = polling.floatValue();
        double timeoutInterval = timeout.floatValue();
        int timeoutIntervalInMs = (int)(timeoutInterval * 1000.0);
        int pollingIntervalInMs = (int)(pollingInterval * 1000.0);
        if (pollingIntervalInMs == 0) {
            pollingIntervalInMs = 1;
        }
        int maxPollingCount = timeoutIntervalInMs / pollingIntervalInMs + 1;
        long startTimeInMs = System.currentTimeMillis();
        long endTimeInMs = startTimeInMs + (long)timeoutIntervalInMs;
        Object message = EmailAccessClient.readMessageFromFolder(clientConnector, folderName);
        if (message != null) {
            return message;
        }
        try {
            for (int i = 0; i < maxPollingCount; ++i) {
                long currentTimeInMs = System.currentTimeMillis();
                long elapsedTimeInMs = currentTimeInMs - startTimeInMs;
                long remainingTimeInMs = endTimeInMs - currentTimeInMs;
                if (remainingTimeInMs <= 0L) break;
                if (i < maxPollingCount - 1 && remainingTimeInMs > (long)pollingIntervalInMs) {
                    Thread.sleep(pollingIntervalInMs);
                } else {
                    long estimatedLastReadTimeInMs = (elapsedTimeInMs - (long)(i * pollingIntervalInMs)) / (long)(i + 1);
                    long lastSleepTimeInMs = remainingTimeInMs - estimatedLastReadTimeInMs;
                    if (lastSleepTimeInMs <= 0L) break;
                    Thread.sleep(lastSleepTimeInMs);
                }
                message = EmailAccessClient.readMessageFromFolder(clientConnector, folderName);
                if (message == null) continue;
                return message;
            }
        }
        catch (InterruptedException e) {
            log.error("Interrupted during the thread sleep : ", (Throwable)e);
            return CommonUtil.getBallerinaError("Error", e.getMessage());
        }
        return null;
    }

    private static Object readMessageFromFolder(BObject clientConnector, BString folderName) {
        BMap<BString, Object> mapValue = null;
        try {
            Folder folder;
            Store store = (Store)clientConnector.getNativeData("store");
            Object folderObj = clientConnector.getNativeData("folder");
            if (folderObj instanceof Folder && ((Folder)folderObj).isOpen()) {
                ((Folder)folderObj).close();
            }
            if ((folder = store.getFolder(folderName.getValue())) == null) {
                log.error("Email store folder, " + String.valueOf(folderName) + " is not found.");
            } else {
                if (!folder.isOpen()) {
                    folder.open(2);
                }
                clientConnector.addNativeData("folder", (Object)folder);
                Message[] messages = folder.search((SearchTerm)UNSEEN_FLAG);
                if (messages.length > 0) {
                    mapValue = EmailAccessUtil.getMapValue(messages[0]);
                    Flags flags = new Flags();
                    if ("PopClient".equals(TypeUtils.getType((Object)clientConnector).getName())) {
                        flags.add(Flags.Flag.DELETED);
                    } else {
                        flags.add(Flags.Flag.SEEN);
                    }
                    folder.setFlags(new int[]{messages[0].getMessageNumber()}, flags, true);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Got the messages. Email count = " + messages.length);
                }
            }
            return mapValue;
        }
        catch (IOException | MessagingException e) {
            log.debug("Error while email folder operation : ", e);
            return CommonUtil.getBallerinaError("Error", e.getMessage());
        }
    }

    public static Object close(BObject clientConnector) {
        try {
            Store store = (Store)clientConnector.getNativeData("store");
            Folder folder = (Folder)clientConnector.getNativeData("folder");
            if (folder.isOpen()) {
                folder.close(false);
            }
            store.close();
        }
        catch (MessagingException e) {
            log.debug("Error while closing the client : ", (Throwable)e);
            return CommonUtil.getBallerinaError("Error", e.getMessage());
        }
        return null;
    }
}

