/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.util;

import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.pop3.POP3Message;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.stdlib.email.util.CommonUtil;
import io.ballerina.stdlib.email.util.EmailConstants;
import io.ballerina.stdlib.email.util.EmailUtils;
import io.ballerina.stdlib.email.util.ExcludeCoverageFromGeneratedReport;
import io.ballerina.stdlib.mime.util.EntityBodyChannel;
import io.ballerina.stdlib.mime.util.EntityWrapper;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import io.ballerina.stdlib.mime.util.MimeUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmailAccessUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailAccessUtil.class);
    private static final ArrayType stringArrayType = TypeCreator.createArrayType((Type)PredefinedTypes.TYPE_STRING);

    private EmailAccessUtil() {
    }

    public static Properties getPopProperties(BMap<BString, Object> emailAccessConfig, String host) throws GeneralSecurityException, IOException {
        String securityType;
        Properties properties = new Properties();
        properties.put("mail.pop3.host", host);
        properties.put("mail.pop3.port", Long.toString(emailAccessConfig.getIntValue(EmailConstants.PROPS_PORT)));
        BString security = emailAccessConfig.getStringValue(EmailConstants.PROPS_SECURITY);
        switch (securityType = security.getValue()) {
            case "START_TLS_AUTO": {
                properties.put("mail.pop3.starttls.enable", "true");
                properties.put("mail.pop3.ssl.enable", "false");
                break;
            }
            case "START_TLS_ALWAYS": {
                properties.put("mail.pop3.starttls.enable", "true");
                properties.put("mail.pop3.starttls.required", "true");
                properties.put("mail.pop3.ssl.enable", "false");
                EmailAccessUtil.addBasicPopTransportSecurityProperties(CommonUtil.createDefaultSSLSocketFactory(), properties);
                break;
            }
            case "START_TLS_NEVER": {
                properties.put("mail.pop3.starttls.enable", "false");
                properties.put("mail.pop3.ssl.enable", "false");
                break;
            }
            default: {
                EmailAccessUtil.addBasicPopTransportSecurityProperties(CommonUtil.createDefaultSSLSocketFactory(), properties);
            }
        }
        EmailAccessUtil.addPopCertificate((BMap<BString, Object>)emailAccessConfig.getMapValue(EmailConstants.PROPS_SECURE_SOCKET), properties);
        properties.put("mail.pop.auth", "true");
        properties.put("mail.store.protocol", "pop3");
        EmailAccessUtil.printPopDebugLogs(properties);
        return properties;
    }

    public static Properties getImapProperties(BMap<BString, Object> emailAccessConfig, String host) throws GeneralSecurityException, IOException {
        String securityType;
        Properties properties = new Properties();
        properties.put("mail.imap.host", host);
        properties.put("mail.imap.port", Long.toString(emailAccessConfig.getIntValue(EmailConstants.PROPS_PORT)));
        BString security = emailAccessConfig.getStringValue(EmailConstants.PROPS_SECURITY);
        switch (securityType = security.getValue()) {
            case "START_TLS_AUTO": {
                properties.put("mail.imap.starttls.enable", "true");
                properties.put("mail.imap.ssl.enable", "false");
                break;
            }
            case "START_TLS_ALWAYS": {
                properties.put("mail.imap.starttls.enable", "true");
                properties.put("mail.imap.starttls.required", "true");
                properties.put("mail.imap.ssl.enable", "false");
                EmailAccessUtil.addBasicImapTransportSecurityProperties(CommonUtil.createDefaultSSLSocketFactory(), properties);
                break;
            }
            case "START_TLS_NEVER": {
                properties.put("mail.imap.starttls.enable", "false");
                properties.put("mail.imap.ssl.enable", "false");
                break;
            }
            default: {
                EmailAccessUtil.addBasicImapTransportSecurityProperties(CommonUtil.createDefaultSSLSocketFactory(), properties);
            }
        }
        properties.put("mail.imap.auth", "true");
        properties.put("mail.store.protocol", "imap");
        EmailAccessUtil.addImapCertificate((BMap<BString, Object>)emailAccessConfig.getMapValue(EmailConstants.PROPS_SECURE_SOCKET), properties);
        EmailAccessUtil.printImapDebugLogs(properties);
        return properties;
    }

    public static BMap<BString, Object> getMapValue(Message message) throws MessagingException, IOException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        Object toAddressArrayValue = EmailAccessUtil.getAddressBArrayList(message.getRecipients(Message.RecipientType.TO));
        Object ccAddressArrayValue = EmailAccessUtil.getAddressBArrayList(message.getRecipients(Message.RecipientType.CC));
        Object bccAddressArrayValue = EmailAccessUtil.getAddressBArrayList(message.getRecipients(Message.RecipientType.BCC));
        Object replyToAddressArrayValue = EmailAccessUtil.getAddressBArrayList(message.getReplyTo());
        String subject = EmailAccessUtil.getStringNullChecked(message.getSubject());
        String messageBody = EmailAccessUtil.extractBodyFromMessage(message);
        BMap<BString, Object> headers = EmailAccessUtil.extractHeadersFromMessage(message);
        String messageContentType = message.getContentType();
        String fromAddress = EmailAccessUtil.extractFromAddressFromMessage(message);
        String senderAddress = EmailAccessUtil.getSenderAddress(message);
        BArray attachments = EmailAccessUtil.extractAttachmentsFromMessage(message);
        valueMap.put(EmailConstants.MESSAGE_TO.getValue(), toAddressArrayValue);
        valueMap.put(EmailConstants.MESSAGE_CC.getValue(), ccAddressArrayValue);
        valueMap.put(EmailConstants.MESSAGE_BCC.getValue(), bccAddressArrayValue);
        valueMap.put(EmailConstants.MESSAGE_REPLY_TO.getValue(), replyToAddressArrayValue);
        valueMap.put(EmailConstants.MESSAGE_SUBJECT.getValue(), subject);
        if (CommonUtil.isJsonBased(message.getContentType())) {
            valueMap.put(EmailConstants.MESSAGE_MESSAGE_BODY.getValue(), EmailAccessUtil.getJsonContent(messageBody));
        } else if (CommonUtil.isXmlBased(message.getContentType())) {
            valueMap.put(EmailConstants.MESSAGE_MESSAGE_BODY.getValue(), EmailAccessUtil.parseToXml(messageBody));
        } else {
            valueMap.put(EmailConstants.MESSAGE_MESSAGE_BODY.getValue(), messageBody);
        }
        if (messageContentType != null && !messageContentType.equals("")) {
            valueMap.put(EmailConstants.MESSAGE_BODY_CONTENT_TYPE.getValue(), messageContentType);
        }
        if (headers != null) {
            valueMap.put(EmailConstants.MESSAGE_HEADERS.getValue(), headers);
        }
        valueMap.put(EmailConstants.MESSAGE_FROM.getValue(), fromAddress);
        valueMap.put(EmailConstants.MESSAGE_SENDER.getValue(), senderAddress);
        if (attachments != null && attachments.size() > 0) {
            valueMap.put(EmailConstants.MESSAGE_ATTACHMENTS.getValue(), attachments);
        }
        return ValueCreator.createRecordValue((Module)EmailUtils.getEmailPackage(), (String)"Message", valueMap);
    }

    protected static void addPopCertificate(BMap<BString, Object> secureSocket, Properties properties) throws IOException, GeneralSecurityException {
        if (secureSocket != null) {
            BArray ciphers;
            String protocolName = null;
            CharSequence[] protocolVersions = null;
            CharSequence[] supportedCiphers = null;
            BMap protocol = secureSocket.getMapValue(EmailConstants.PROPS_CERT_PROTOCOL);
            if (protocol != null) {
                protocolName = protocol.getStringValue(EmailConstants.PROPS_CERT_PROTOCOL_NAME).getValue();
                BArray versions = protocol.getArrayValue(EmailConstants.PROPS_CERT_PROTOCOL_VERSIONS);
                if (versions != null) {
                    protocolVersions = versions.getStringArray();
                }
            }
            if ((ciphers = secureSocket.getArrayValue(EmailConstants.PROPS_CERT_CIPHERS)) != null) {
                supportedCiphers = ciphers.getStringArray();
            }
            String certificatePath = secureSocket.getStringValue(EmailConstants.PROPS_CERTIFICATE).getValue();
            SSLSocketFactory sslSocketFactory = CommonUtil.createSSLSocketFactory(new File(certificatePath), protocolName);
            properties.put("mail.pop3.ssl.socketFactory", sslSocketFactory);
            properties.put("mail.pop3.ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.pop3.socketFactory.fallback", "false");
            properties.put("mail.pop3.ssl.checkserveridentity", "true");
            properties.put("mail.smtp.ssl.enable", "true");
            properties.put("mail.pop3.starttls.enable", "true");
            if (protocolVersions != null) {
                properties.put("mail.pop3.ssl.protocols", String.join((CharSequence)" ", protocolVersions));
            }
            if (supportedCiphers != null) {
                properties.put("mail.pop3.ssl.ciphersuites", String.join((CharSequence)" ", supportedCiphers));
            }
            if (secureSocket.containsKey((Object)EmailConstants.PROPS_VERIFY_HOSTNAME)) {
                Boolean verifyHostname = secureSocket.getBooleanValue(EmailConstants.PROPS_VERIFY_HOSTNAME);
                if (verifyHostname.booleanValue()) {
                    properties.put("mail.pop3.ssl.checkserveridentity", "true");
                } else {
                    properties.put("mail.pop3.ssl.checkserveridentity", "false");
                }
            }
        }
    }

    protected static void addImapCertificate(BMap<BString, Object> secureSocket, Properties properties) throws IOException, GeneralSecurityException {
        if (secureSocket != null) {
            BArray ciphers;
            String protocolName = null;
            CharSequence[] protocolVersions = null;
            CharSequence[] supportedCiphers = null;
            BMap protocol = secureSocket.getMapValue(EmailConstants.PROPS_CERT_PROTOCOL);
            if (protocol != null) {
                protocolName = protocol.getStringValue(EmailConstants.PROPS_CERT_PROTOCOL_NAME).getValue();
                BArray versions = protocol.getArrayValue(EmailConstants.PROPS_CERT_PROTOCOL_VERSIONS);
                if (versions != null) {
                    protocolVersions = versions.getStringArray();
                }
            }
            if ((ciphers = secureSocket.getArrayValue(EmailConstants.PROPS_CERT_CIPHERS)) != null) {
                supportedCiphers = ciphers.getStringArray();
            }
            String certificatePath = secureSocket.getStringValue(EmailConstants.PROPS_CERTIFICATE).getValue();
            SSLSocketFactory sslSocketFactory = CommonUtil.createSSLSocketFactory(new File(certificatePath), protocolName);
            properties.put("mail.imap.ssl.socketFactory", sslSocketFactory);
            properties.put("mail.imap.ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.imap.socketFactory.fallback", "false");
            properties.put("mail.imap.ssl.checkserveridentity", "true");
            properties.put("mail.smtp.ssl.enable", "true");
            properties.put("mail.imap.starttls.enable", "true");
            if (protocolVersions != null) {
                properties.put("mail.imap.ssl.protocols", String.join((CharSequence)" ", protocolVersions));
            }
            if (supportedCiphers != null) {
                properties.put("mail.imap.ssl.ciphersuites", String.join((CharSequence)" ", supportedCiphers));
            }
            if (secureSocket.containsKey((Object)EmailConstants.PROPS_VERIFY_HOSTNAME)) {
                Boolean verifyHostname = secureSocket.getBooleanValue(EmailConstants.PROPS_VERIFY_HOSTNAME);
                if (verifyHostname.booleanValue()) {
                    properties.put("mail.imap.ssl.checkserveridentity", "true");
                } else {
                    properties.put("mail.imap.ssl.checkserveridentity", "false");
                }
            }
        }
    }

    private static void addBasicPopTransportSecurityProperties(SSLSocketFactory sslSocketFactory, Properties properties) {
        properties.put("mail.pop3.ssl.socketFactory", sslSocketFactory);
        properties.put("mail.pop3.ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        properties.put("mail.pop3.socketFactory.fallback", "false");
        properties.put("mail.pop3.ssl.checkserveridentity", "true");
        properties.put("mail.pop3.ssl.enable", "true");
        properties.put("mail.pop3.starttls.enable", "true");
    }

    private static void addBasicImapTransportSecurityProperties(SSLSocketFactory sslSocketFactory, Properties properties) {
        properties.put("mail.imap.ssl.socketFactory", sslSocketFactory);
        properties.put("mail.imap.ssl.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        properties.put("mail.imap.socketFactory.fallback", "false");
        properties.put("mail.imap.ssl.checkserveridentity", "true");
        properties.put("mail.imap.ssl.enable", "true");
        properties.put("mail.imap.starttls.enable", "true");
    }

    private static BMap<BString, Object> extractHeadersFromMessage(Message message) throws MessagingException {
        BMap headerMap = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING));
        Enumeration headers = message.getAllHeaders();
        if (headers.hasMoreElements()) {
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                headerMap.put((Object)StringUtils.fromString((String)header.getName()), (Object)StringUtils.fromString((String)header.getValue()));
            }
            return headerMap;
        }
        return null;
    }

    private static BXmlSequence parseToXml(String xmlStr) {
        return (BXmlSequence)XmlUtils.parse((String)xmlStr);
    }

    private static Object getJsonContent(String messageContent) {
        Object json = JsonUtils.parse((String)messageContent);
        if (json instanceof String) {
            return StringUtils.fromString((String)((String)json));
        }
        return json;
    }

    private static String extractBodyFromMessage(Message message) throws MessagingException, IOException {
        Object messageObject;
        MimeMultipart mimeMultipart;
        String contentType = message.getContentType();
        if (contentType != null && CommonUtil.isTextBased(contentType.toLowerCase(Locale.getDefault()))) {
            Object content = message.getContent();
            if (content == null) {
                return "";
            }
            if (content instanceof InputStream) {
                int nRead;
                InputStream contentStream = (InputStream)content;
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[1024];
                while ((nRead = contentStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                contentStream.close();
                return buffer.toString(StandardCharsets.UTF_8);
            }
            return content.toString();
        }
        if (message.isMimeType("multipart/*") && (mimeMultipart = (MimeMultipart)message.getContent()) != null && mimeMultipart.getCount() > 0 && mimeMultipart.getBodyPart(0) != null && mimeMultipart.getBodyPart(0).getContent() != null && (messageObject = mimeMultipart.getBodyPart(0).getContent()) instanceof String) {
            return (String)messageObject;
        }
        return "";
    }

    private static BArray extractAttachmentsFromMessage(Message message) throws MessagingException, IOException {
        ArrayList<BObject> attachmentArray = new ArrayList<BObject>();
        if (!message.isMimeType("multipart/*")) {
            return null;
        }
        MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
        int numberOfAttachments = mimeMultipart.getCount();
        if (numberOfAttachments > 1) {
            for (int i = 1; i < numberOfAttachments; ++i) {
                EmailAccessUtil.attachMultipart(mimeMultipart.getBodyPart(i), attachmentArray);
            }
            return EmailAccessUtil.getArrayOfEntities(attachmentArray);
        }
        log.debug("Received a Multipart email message without any attachments.");
        return null;
    }

    private static void attachMultipart(BodyPart bodyPart, ArrayList<BObject> entityArray) throws MessagingException, IOException {
        if (bodyPart.isMimeType("multipart/*")) {
            entityArray.add(EmailAccessUtil.getMultipartEntity(bodyPart));
        } else {
            String contentType = bodyPart.getContentType();
            if (contentType != null) {
                if (CommonUtil.isJsonBased(contentType)) {
                    entityArray.add(EmailAccessUtil.getTypedEntity(bodyPart, "application/json"));
                } else if (CommonUtil.isXmlBased(contentType)) {
                    entityArray.add(EmailAccessUtil.getTypedEntity(bodyPart, "application/xml"));
                } else if (CommonUtil.isTextBased(contentType)) {
                    entityArray.add(EmailAccessUtil.getTypedEntity(bodyPart, "text/plain"));
                } else {
                    entityArray.add(EmailAccessUtil.getTypedEntity(bodyPart, "application/octet-stream"));
                }
            } else {
                entityArray.add(EmailAccessUtil.getTypedEntity(bodyPart, "application/octet-stream"));
            }
        }
    }

    private static BObject getMultipartEntity(BodyPart bodyPart) throws MessagingException, IOException {
        BObject multipartEntity = EmailAccessUtil.createEntityObject();
        ArrayList<BObject> entities = EmailAccessUtil.getMultipleEntities(bodyPart);
        if (entities != null && bodyPart.getContentType() != null) {
            multipartEntity.addNativeData("body_parts", (Object)EmailAccessUtil.getArrayOfEntities(entities));
            MimeUtil.setContentType((BObject)EmailAccessUtil.createMediaTypeObject(), (BObject)multipartEntity, (String)bodyPart.getContentType());
            EmailAccessUtil.setEntityHeaders(multipartEntity, bodyPart);
        }
        return multipartEntity;
    }

    private static ArrayList<BObject> getMultipleEntities(BodyPart bodyPart) throws IOException, MessagingException {
        ArrayList<BObject> entityArray = new ArrayList<BObject>();
        MimeMultipart mimeMultipart = (MimeMultipart)bodyPart.getContent();
        int numberOfBodyParts = mimeMultipart.getCount();
        if (numberOfBodyParts > 0) {
            for (int i = 0; i < numberOfBodyParts; ++i) {
                BodyPart subPart = mimeMultipart.getBodyPart(i);
                EmailAccessUtil.attachMultipart(subPart, entityArray);
            }
            return entityArray;
        }
        return null;
    }

    private static BObject getTypedEntity(BodyPart bodyPart, String mimeType) throws IOException, MessagingException {
        byte[] binaryContent = CommonUtil.convertInputStreamToByteArray(bodyPart.getInputStream());
        EntityWrapper byteChannel = new EntityWrapper(new EntityBodyChannel((InputStream)new ByteArrayInputStream(binaryContent)));
        BObject entity = EmailAccessUtil.createEntityObject();
        entity.addNativeData("entity_byte_channel", (Object)byteChannel);
        MimeUtil.setContentType((BObject)EmailAccessUtil.createMediaTypeObject(), (BObject)entity, (String)mimeType);
        EmailAccessUtil.setEntityHeaders(entity, bodyPart);
        return entity;
    }

    private static void setEntityHeaders(BObject entity, BodyPart bodyPart) throws MessagingException {
        Enumeration headers = bodyPart.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            HeaderUtil.setHeaderToEntity((BObject)entity, (String)header.getName(), (String)header.getValue());
        }
    }

    private static BArray getArrayOfEntities(ArrayList<BObject> entities) {
        Type typeOfEntity = TypeUtils.getType((Object)entities.get(0));
        Object[] result = entities.toArray(new BObject[entities.size()]);
        return ValueCreator.createArrayValue((Object[])result, (ArrayType)TypeCreator.createArrayType((Type)typeOfEntity));
    }

    private static BObject createMediaTypeObject() {
        return ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"MediaType", (Object[])new Object[0]);
    }

    private static BObject createEntityObject() {
        return ValueCreator.createObjectValue((Module)MimeUtil.getMimePackage(), (String)"Entity", (Object[])new Object[0]);
    }

    private static String extractFromAddressFromMessage(Message message) throws MessagingException {
        String fromAddress = "";
        if (message.getFrom() != null) {
            fromAddress = message.getFrom()[0].toString();
        }
        return fromAddress;
    }

    private static String getSenderAddress(Message message) throws MessagingException {
        String senderAddress = "";
        if (message instanceof POP3Message) {
            if (((POP3Message)message).getSender() != null) {
                senderAddress = ((POP3Message)message).getSender().toString();
            }
        } else if (message instanceof IMAPMessage && ((IMAPMessage)message).getSender() != null) {
            senderAddress = ((IMAPMessage)message).getSender().toString();
        }
        return senderAddress;
    }

    private static Object getAddressBArrayList(Address[] addresses) {
        BArray addressArrayValue = ValueCreator.createArrayValue((ArrayType)stringArrayType);
        if (addresses != null) {
            if (addresses.length > 1) {
                for (Address address : addresses) {
                    addressArrayValue.append((Object)StringUtils.fromString((String)address.toString()));
                }
            } else {
                return addresses[0].toString();
            }
        }
        return addressArrayValue;
    }

    private static String getStringNullChecked(String string) {
        return string == null ? "" : string;
    }

    @ExcludeCoverageFromGeneratedReport
    private static void printPopDebugLogs(Properties properties) {
        if (log.isDebugEnabled()) {
            Set<String> propertySet = properties.stringPropertyNames();
            log.debug("POP3 Properties set are as follows.");
            for (String propertyObj : propertySet) {
                log.debug("Property Name: " + String.valueOf(propertyObj) + ", Value: " + properties.get(propertyObj).toString() + " ValueType: " + properties.get(propertyObj).getClass().getName());
            }
        }
    }

    @ExcludeCoverageFromGeneratedReport
    private static void printImapDebugLogs(Properties properties) {
        if (log.isDebugEnabled()) {
            Set<String> propertySet = properties.stringPropertyNames();
            log.debug("IMAP4 Properties set are as follows.");
            for (String propertyObj : propertySet) {
                log.debug("Property Name: " + String.valueOf(propertyObj) + ", Value: " + properties.get(propertyObj).toString() + " ValueType: " + properties.get(propertyObj).getClass().getName());
            }
        }
    }
}

