/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.components;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.persist.nodegenerator.syntax.constants.SyntaxTokenConstants;

public class TypeDescriptor {
    private TypeDescriptor() {
    }

    public static ReturnTypeDescriptorNode getReturnTypeDescriptorNode(Node type) {
        NodeList annotations = NodeFactory.createEmptyNodeList();
        return NodeFactory.createReturnTypeDescriptorNode((Token)SyntaxTokenConstants.SYNTAX_TREE_KEYWORD_RETURNS, (NodeList)annotations, (Node)type);
    }

    public static QualifiedNameReferenceNode getQualifiedNameReferenceNode(String modulePrefix, String identifier) {
        return NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)modulePrefix), (Node)SyntaxTokenConstants.SYNTAX_TREE_COLON, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)(identifier + " ")));
    }

    public static BuiltinSimpleNameReferenceNode getBuiltinSimpleNameReferenceNode(String name) {
        return NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)(switch (name) {
            case "int" -> SyntaxKind.INT_TYPE_DESC;
            case "float" -> SyntaxKind.DECIMAL_TYPE_DESC;
            case "boolean" -> SyntaxKind.BOOLEAN_TYPE_DESC;
            case "byte" -> SyntaxKind.BYTE_TYPE_DESC;
            case "var" -> SyntaxKind.VAR_TYPE_DESC;
            case "anydata" -> SyntaxKind.ANYDATA_TYPE_DESC;
            default -> SyntaxKind.STRING_TYPE_DESC;
        }), (Token)AbstractNodeFactory.createIdentifierToken((String)(name + " ")));
    }

    public static ArrayTypeDescriptorNode getArrayTypeDescriptorNode(String type) {
        ArrayDimensionNode arrayDimensionNode = NodeFactory.createArrayDimensionNode((Token)SyntaxTokenConstants.SYNTAX_TREE_OPEN_BRACKET, null, (Token)SyntaxTokenConstants.SYNTAX_TREE_CLOSE_BRACKET);
        NodeList dimensionList = NodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode});
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)TypeDescriptor.getBuiltinSimpleNameReferenceNode(type), (NodeList)dimensionList);
    }

    public static SimpleNameReferenceNode getSimpleNameReferenceNode(String name) {
        return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)(name + " ")));
    }

    public static UnionTypeDescriptorNode getUnionTypeDescriptorNode(TypeDescriptorNode lhs, TypeDescriptorNode rhs) {
        return NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)lhs, (Token)SyntaxTokenConstants.SYNTAX_TREE_PIPE, (TypeDescriptorNode)rhs);
    }

    public static OptionalTypeDescriptorNode getOptionalTypeDescriptorNode(String modulePrefix, String identifier) {
        if (modulePrefix.isEmpty()) {
            return NodeFactory.createOptionalTypeDescriptorNode((Node)TypeDescriptor.getSimpleNameReferenceNode(identifier), (Token)SyntaxTokenConstants.SYNTAX_TREE_QUESTION_MARK);
        }
        return NodeFactory.createOptionalTypeDescriptorNode((Node)NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)modulePrefix), (Node)SyntaxTokenConstants.SYNTAX_TREE_COLON, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)identifier)), (Token)SyntaxTokenConstants.SYNTAX_TREE_QUESTION_MARK);
    }
}

