/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.configuration;

import io.ballerina.persist.BalException;
import io.ballerina.persist.utils.DataBaseValidationUtils;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.NodeList;

public class DatabaseConfiguration {
    private String host;
    private String username;
    private String password;
    private int port;
    private String database;

    public DatabaseConfiguration(String host, String username, String password, String port, String database) throws BalException {
        this.host = host;
        this.username = username;
        this.password = password;
        this.port = Integer.parseInt(port);
        this.database = DataBaseValidationUtils.validateDatabaseInput(database);
    }

    public DatabaseConfiguration(String modelName, NodeList<KeyValueNode> nodeList) throws BalException {
        block14: for (KeyValueNode member : nodeList) {
            String key;
            String value = member.value().toSourceCode().replaceAll("\"", "").trim();
            switch (key = member.identifier().toSourceCode().trim()) {
                case "host": {
                    this.host = value;
                    continue block14;
                }
                case "user": {
                    this.username = value;
                    continue block14;
                }
                case "password": {
                    this.password = value;
                    continue block14;
                }
                case "port": {
                    this.port = Integer.parseInt(value);
                    continue block14;
                }
                case "database": {
                    this.database = DataBaseValidationUtils.validateDatabaseInput(value);
                    continue block14;
                }
            }
            throw new BalException("invalid database configuration identifier, " + key);
        }
        if (this.database == null) {
            this.database = DataBaseValidationUtils.validateDatabaseInput(modelName);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }
}

