/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.introspect;

import io.ballerina.persist.introspect.Introspector;
import io.ballerina.persist.introspectiondto.SqlColumn;
import io.ballerina.persist.models.SqlType;
import io.ballerina.persist.utils.DatabaseConnector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostgreSqlIntrospector
extends Introspector {
    public PostgreSqlIntrospector() {
        this.databaseConnector = new DatabaseConnector("jdbc:%s://%s:%s/%s", "org.postgresql.Driver");
    }

    @Override
    public String getTablesQuery() {
        String formatQuery = "SELECT\n    tbl.relname AS table_name\nFROM pg_class AS tbl\n    INNER JOIN pg_namespace AS namespace ON namespace.oid = tbl.relnamespace\nWHERE\n    tbl.relkind = 'r' AND namespace.nspname = 'public'\n    ORDER BY table_name;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return formatQuery;
    }

    @Override
    public String getColumnsQuery(String tableName) {
        String formatQuery = "SELECT\n    info.table_name AS table_name,\n    info.column_name AS column_name,\n    UPPER(format_type(att.atttypid, att.atttypmod)) AS full_data_type,\n    info.numeric_precision AS numeric_precision,\n    info.numeric_scale AS numeric_scale,\n    info.numeric_precision_radix,\n    info.datetime_precision AS datetime_precision,\n    info.udt_schema AS type_schema_name,\n    UPPER(info.udt_name) AS data_type,\n    pg_get_expr(attdef.adbin, attdef.adrelid) AS column_default,\n    info.is_nullable AS is_nullable,\n    CASE\n        WHEN info.column_name IN (\n            SELECT columns.column_name\n            FROM\n                information_schema.table_constraints AS constraints\n            JOIN\n                information_schema.constraint_column_usage AS columns\n            ON\n                columns.constraint_name = constraints.constraint_name\n            WHERE\n                constraints.constraint_type = 'PRIMARY KEY' AND\n                columns.table_schema = constraints.table_schema AND\n                columns.table_schema = 'public' AND\n                columns.table_name = constraints.table_name AND\n                columns.table_name = '%s'\n            )\n        THEN 'PRI'\n        ELSE 'NO'\n    END AS column_key,\n    info.character_maximum_length AS character_maximum_length,\n    col_description(att.attrelid, ordinal_position) AS column_comment,\n    CASE\n        WHEN pg_get_expr(attdef.adbin, attdef.adrelid) IS NOT NULL\n        AND pg_get_expr(attdef.adbin, attdef.adrelid) LIKE 'nextval(%%'\n        THEN 1\n        ELSE 0\n    END AS dbGenerated,\n    pg_get_constraintdef(con.oid) AS check_constraint\n    FROM information_schema.columns info\n    JOIN pg_attribute att ON att.attname = info.column_name\n    JOIN (\n        SELECT pg_class.oid, relname, pg_namespace.nspname as namespace\n        FROM pg_class\n        JOIN pg_namespace on pg_namespace.oid = pg_class.relnamespace\n        AND pg_namespace.nspname = 'public' WHERE reltype > 0\n    ) as oid on oid.oid = att.attrelid\n    AND relname = info.table_name\n    AND namespace = info.table_schema\n    LEFT OUTER JOIN pg_attrdef attdef\n    ON attdef.adrelid = att.attrelid AND attdef.adnum = att.attnum AND table_schema = namespace\n    LEFT OUTER JOIN pg_catalog.pg_constraint con\n    ON con.conrelid = att.attrelid AND att.attnum = ANY(con.conkey) AND con.contype = 'c'\n    WHERE table_schema = 'public' AND table_name = '%s'\n    ORDER BY ordinal_position;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, tableName, tableName);
    }

    @Override
    public String getIndexesQuery(String tableName) {
        String formatQuery = "WITH rawindex AS (\n    SELECT\n        indrelid,\n        indexrelid,\n        indisunique,\n        indisprimary,\n        unnest(indkey) AS indkeyid,\n        generate_subscripts(indkey, 1) AS indkeyidx,\n        unnest(indclass) AS indclass,\n        unnest(indoption) AS indoption\n    FROM pg_index\n    WHERE\n        indpred IS NULL\n        AND NOT indisexclusion\n)\nSELECT\n    indexinfo.relname AS index_name,\n    tableinfo.relname AS table_name,\n    columninfo.attname AS column_name,\n    rawindex.indisunique AS is_unique,\n    rawindex.indkeyidx AS seq_in_index,\n    CASE rawindex.indoption & 1\n        WHEN 1 THEN 'DESC'\n        ELSE 'ASC' END\n        AS column_order\nFROM\n    rawindex\n    INNER JOIN pg_class AS tableinfo ON tableinfo.oid = rawindex.indrelid\n    INNER JOIN pg_class AS indexinfo ON indexinfo.oid = rawindex.indexrelid\n    INNER JOIN pg_namespace AS schemainfo ON schemainfo.oid = tableinfo.relnamespace\n    LEFT JOIN pg_attribute AS columninfo\n        ON columninfo.attrelid = tableinfo.oid AND columninfo.attnum = rawindex.indkeyid\n    INNER JOIN pg_am AS indexaccess ON indexaccess.oid = indexinfo.relam\n    LEFT JOIN pg_opclass AS opclass\n        ON opclass.oid = rawindex.indclass\n    LEFT JOIN pg_constraint pc ON rawindex.indexrelid = pc.conindid AND pc.contype <> 'f'\nWHERE\n    schemainfo.nspname = 'public' AND\n    rawindex.indisprimary = false AND\n    tableinfo.relname = '%s'\nORDER BY index_name;\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, tableName);
    }

    @Override
    public String getForeignKeysQuery(String tableName) {
        String formatQuery = "SELECT\n    table_name,\n    att2.attname    AS column_name,\n    cl.relname      AS referenced_table_name,\n    att.attname     AS referenced_column_name,\n    conname         AS constraint_name,\n    NULL            AS update_rule,\n    NULL            AS delete_rule\nFROM (SELECT\n            ns.nspname AS \"namespace\",\n            unnest(con1.conkey)                AS parent,\n            unnest(con1.confkey)                AS child,\n            cl.relname                          AS table_name,\n            generate_subscripts(con1.conkey, 1) AS colidx,\n            con1.confrelid,\n            con1.conrelid,\n            con1.conname\n    FROM pg_class cl\n            join pg_constraint con1 on con1.conrelid = cl.oid\n            join pg_namespace ns on cl.relnamespace = ns.oid\n    WHERE\n        ns.nspname = 'public'\n        and con1.contype = 'f'\n    ORDER BY colidx\n    ) con\n        JOIN pg_attribute att on att.attrelid = con.confrelid and att.attnum = con.child\n        JOIN pg_class cl on cl.oid = con.confrelid\n        JOIN pg_attribute att2 on att2.attrelid = con.conrelid and att2.attnum = con.parent\nWHERE table_name = '%s';\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return String.format(formatQuery, tableName);
    }

    @Override
    protected String getEnumsQuery() {
        String formatQuery = "SELECT\n    rel.relname AS table_name,\n    a.attname AS column_name,\n    pg_get_constraintdef(con.oid) AS full_enum_type\nFROM\n    pg_catalog.pg_constraint con\nINNER JOIN\n    pg_catalog.pg_class rel ON rel.oid = con.conrelid\nINNER JOIN\n    pg_catalog.pg_namespace nsp ON nsp.oid = connamespace\nINNER JOIN\n    pg_catalog.pg_attribute a ON a.attrelid = rel.oid AND a.attnum = ANY(con.conkey)\nWHERE\n    nsp.nspname = 'public'\n    AND con.contype = 'c'\n";
        formatQuery = formatQuery.replace("\r\n", "%n");
        return formatQuery;
    }

    @Override
    protected boolean isEnumType(SqlColumn column) {
        if (Objects.isNull(column.getCheckConstraint())) {
            return false;
        }
        Pattern pattern = Pattern.compile("^CHECK \\(\\(\\(\"?(\\w+(\\s+\\w+){0,3})\"?\\)::text = ANY \\(\\(ARRAY\\['(\\w+(\\s+\\w+){0,3})'::character varying(, '(\\w+(\\s+\\w+){0,3})'::character varying)*\\]\\)::text\\[\\]\\)\\)\\)$");
        return pattern.matcher(column.getCheckConstraint()).find();
    }

    @Override
    protected List<String> extractEnumValues(String enumString) {
        ArrayList<String> enumValues = new ArrayList<String>();
        enumString = enumString.substring(5);
        Pattern pattern = Pattern.compile("ARRAY\\[(.*?)]");
        Matcher matcher = pattern.matcher(enumString);
        if (matcher.find()) {
            String valuesInArray = matcher.group(1);
            String[] valuesArray = valuesInArray.split(",");
            Arrays.stream(valuesArray).map(value -> {
                value = value.split("::")[0];
                value = value.trim();
                value = value.replace("'", "");
                return value.trim();
            }).forEach(enumValues::add);
        }
        return enumValues;
    }

    @Override
    protected String getBalType(SqlType sqlType) {
        return this.getBalTypeForCommonDataTypes(sqlType);
    }
}

