/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.models;

import io.ballerina.persist.models.EnumMember;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Enum {
    private final String enumName;
    private final List<EnumMember> members;

    private Enum(String enumName, List<EnumMember> members) {
        this.enumName = enumName;
        this.members = Collections.unmodifiableList(members);
    }

    public String getEnumName() {
        return this.enumName;
    }

    public List<EnumMember> getMembers() {
        return this.members;
    }

    public static Builder newBuilder(String enumName) {
        return new Builder(enumName);
    }

    public static class Builder {
        private final String enumName;
        private List<EnumMember> members;

        private Builder(String enumName) {
            this.enumName = enumName;
        }

        public void addMember(EnumMember member) {
            if (this.members == null) {
                this.members = new ArrayList<EnumMember>();
            }
            this.members.add(member);
        }

        public Enum build() {
            return new Enum(this.enumName, this.members);
        }
    }
}

