/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.models;

import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.ForeignKey;
import io.ballerina.persist.models.Index;
import io.ballerina.persist.models.Relation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MigrationDataHolder {
    private final List<String> addedEntities = new ArrayList<String>();
    private final List<NameMapping> renamedEntities = new ArrayList<NameMapping>();
    private final List<String> removedEntities = new ArrayList<String>();
    private final Map<String, List<EntityField>> addedFields = new HashMap<String, List<EntityField>>();
    private final Map<String, List<NameMapping>> renamedFields = new HashMap<String, List<NameMapping>>();
    private final Map<String, List<String>> removedFields = new HashMap<String, List<String>>();
    private final Map<String, List<EntityField>> changedFieldTypes = new HashMap<String, List<EntityField>>();
    private final Set<String> primaryKeyChangedEntities = new HashSet<String>();
    private final Map<String, List<ForeignKey>> addedForeignKeys = new HashMap<String, List<ForeignKey>>();
    private final Map<String, List<ForeignKey>> removedForeignKeys = new HashMap<String, List<ForeignKey>>();
    private final List<String> differences = new ArrayList<String>();
    private final Map<String, List<Index>> addedIndexes = new HashMap<String, List<Index>>();
    private final Map<String, List<Index>> removedIndexes = new HashMap<String, List<Index>>();

    public void addTable(String tableName) {
        this.differences.add("Table " + tableName + " has been added");
        this.addedEntities.add(tableName);
    }

    public void removeTable(String tableName) {
        this.differences.add("Table " + tableName + " has been removed");
        this.removedEntities.add(tableName);
    }

    public void renameTable(String oldName, String newName) {
        this.differences.add("Table " + oldName + " has been renamed to " + newName);
        this.renamedEntities.add(new NameMapping(oldName, newName));
    }

    public void changePrimaryKey(String tableName) {
        this.differences.add("Primary key of table " + tableName + " has changed");
        this.primaryKeyChangedEntities.add(tableName);
    }

    public void addColumn(String tableName, EntityField field, boolean isPrimary) {
        this.differences.add("Column " + field.getFieldColumnName() + " of type " + field.getFieldType() + " has been added to table " + tableName + (isPrimary ? " as a primary key" : ""));
        if (isPrimary) {
            this.primaryKeyChangedEntities.add(tableName);
        }
        this.addOrModifyColumn(tableName, field, this.addedFields);
    }

    public void modifyColumn(String tableName, EntityField previousModelField, EntityField currentModelField) {
        this.differences.add("Data type of column " + previousModelField.getFieldColumnName() + " in table " + tableName + " has changed to " + (currentModelField.isOptionalType() ? "optional " : "required ") + currentModelField.getFieldType() + (String)(currentModelField.getSqlType() != null ? " with SQL type " + currentModelField.getSqlType().getTypeName() : "") + (currentModelField.isDbGenerated() ? " and will be generated by the database" : ""));
        this.addOrModifyColumn(tableName, currentModelField, this.changedFieldTypes);
    }

    private void addOrModifyColumn(String tableName, EntityField field, Map<String, List<EntityField>> fieldMap) {
        if (!fieldMap.containsKey(tableName)) {
            ArrayList<EntityField> initialData = new ArrayList<EntityField>();
            initialData.add(field);
            fieldMap.put(tableName, initialData);
        } else {
            List<EntityField> existingData = fieldMap.get(tableName);
            existingData.add(field);
            fieldMap.put(tableName, existingData);
        }
    }

    public void removeColumn(String tableName, String columnName) {
        this.differences.add("Column " + columnName + " has been removed from table " + tableName);
        if (!this.removedFields.containsKey(tableName)) {
            ArrayList<String> initialData = new ArrayList<String>();
            initialData.add(columnName);
            this.removedFields.put(tableName, initialData);
        } else {
            List<String> existingData = this.removedFields.get(tableName);
            existingData.add(columnName);
            this.removedFields.put(tableName, existingData);
        }
    }

    public void recreateForeignKey(String tableName, EntityField previousModelField, EntityField currentModelField) {
        this.differences.add("Relation " + previousModelField.getFieldColumnName() + " in table " + tableName + " has changed");
        this.removeForeignKey(tableName, previousModelField);
        this.createForeignKeys(tableName, currentModelField);
    }

    public void removeForeignKey(String tableName, EntityField field) {
        this.differences.add("Relation " + field.getFieldColumnName() + " has been removed from table " + tableName);
        this.addOrRemoveForeignKey(tableName, field, this.removedForeignKeys);
    }

    public void renameColumn(String tableName, String oldName, String newName) {
        this.differences.add("Column " + oldName + " in table " + tableName + " has been renamed to " + newName);
        if (!this.renamedFields.containsKey(tableName)) {
            ArrayList<NameMapping> initialData = new ArrayList<NameMapping>();
            initialData.add(new NameMapping(oldName, newName));
            this.renamedFields.put(tableName, initialData);
        } else {
            List<NameMapping> existingData = this.renamedFields.get(tableName);
            existingData.add(new NameMapping(oldName, newName));
            this.renamedFields.put(tableName, existingData);
        }
    }

    private void addOrRemoveForeignKey(String tableName, EntityField field, Map<String, List<ForeignKey>> map) {
        if (field.getRelation() == null) {
            return;
        }
        String removeKeyName = String.format("FK_%s_%s", tableName, field.getRelation().getAssocEntity().getTableName());
        ForeignKey foreignKey = new ForeignKey(removeKeyName, field.getRelation().getKeyColumns().stream().map(Relation.Key::getColumnName).toList(), field.getRelation().getAssocEntity().getTableName(), field.getRelation().getKeyColumns().stream().map(Relation.Key::getReferenceColumnName).toList());
        if (!map.containsKey(tableName)) {
            ArrayList<ForeignKey> initialData = new ArrayList<ForeignKey>();
            initialData.add(foreignKey);
            map.put(tableName, initialData);
        } else {
            List<ForeignKey> existingData = map.get(tableName);
            existingData.add(foreignKey);
            map.put(tableName, existingData);
        }
    }

    public void removeIndex(String tableName, Index index) {
        this.differences.add("Index " + index.getIndexName() + " has been removed from table " + tableName);
        this.addOrRemoveIndex(tableName, index, this.removedIndexes);
    }

    public void addIndex(String tableName, Index index) {
        this.differences.add("Index " + index.getIndexName() + " on column(s) " + index.getFields().stream().map(EntityField::getFieldColumnName).reduce((a, b) -> a + ", " + b).orElse("") + " has been added to table " + tableName);
        this.addOrRemoveIndex(tableName, index, this.addedIndexes);
    }

    private void addOrRemoveIndex(String tableName, Index index, Map<String, List<Index>> map) {
        if (!map.containsKey(tableName)) {
            ArrayList<Index> initialData = new ArrayList<Index>();
            initialData.add(index);
            map.put(tableName, initialData);
        } else {
            List<Index> existingData = map.get(tableName);
            existingData.add(index);
            map.put(tableName, existingData);
        }
    }

    public void createForeignKeys(String tableName, EntityField currentModelField) {
        for (Relation.Key key : currentModelField.getRelation().getKeyColumns()) {
            this.differences.add("Column " + key.getColumnName() + " of type " + key.getType() + " has been added to table " + tableName + " as a foreign key");
        }
        this.createForeignKeyColumn(tableName, currentModelField);
        this.differences.add("Relation " + currentModelField.getFieldName() + " of type " + currentModelField.getFieldType() + " has been added to table " + tableName);
        this.addOrRemoveForeignKey(tableName, currentModelField, this.addedForeignKeys);
    }

    private void createForeignKeyColumn(String tableName, EntityField field) {
        for (Relation.Key key : field.getRelation().getKeyColumns()) {
            EntityField primaryKey = field.getRelation().getAssocEntity().getFieldByColumnName(key.getReferenceColumnName());
            EntityField.Builder customFkBuilder = EntityField.newBuilder(key.getField());
            customFkBuilder.setFieldColumnName(key.getColumnName());
            customFkBuilder.setType(primaryKey.getFieldType());
            customFkBuilder.setArrayType(false);
            customFkBuilder.setSqlType(primaryKey.getSqlType());
            this.addOrModifyColumn(tableName, customFkBuilder.build(), this.addedFields);
        }
    }

    public boolean isEntityRenamed(String tableName) {
        return this.renamedEntities.stream().anyMatch(entry -> entry.newName().equals(tableName));
    }

    public List<String> getAddedEntities() {
        return this.addedEntities;
    }

    public List<NameMapping> getRenamedEntities() {
        return this.renamedEntities;
    }

    public List<String> getRemovedEntities() {
        return this.removedEntities;
    }

    public Map<String, List<EntityField>> getAddedFields() {
        return this.addedFields;
    }

    public Map<String, List<NameMapping>> getRenamedFields() {
        return this.renamedFields;
    }

    public Map<String, List<String>> getRemovedFields() {
        return this.removedFields;
    }

    public Map<String, List<EntityField>> getChangedFieldTypes() {
        return this.changedFieldTypes;
    }

    public Set<String> getPrimaryKeyChangedEntities() {
        return this.primaryKeyChangedEntities;
    }

    public Map<String, List<ForeignKey>> getAddedForeignKeys() {
        return this.addedForeignKeys;
    }

    public Map<String, List<ForeignKey>> getRemovedForeignKeys() {
        return this.removedForeignKeys;
    }

    public List<String> getDifferences() {
        return this.differences;
    }

    public Map<String, List<Index>> getAddedIndexes() {
        return this.addedIndexes;
    }

    public Map<String, List<Index>> getRemovedIndexes() {
        return this.removedIndexes;
    }

    public record NameMapping(String oldName, String newName) {
    }
}

