/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.models;

import io.ballerina.persist.models.Entity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Relation {
    private List<Key> keyColumns;
    private List<String> references;
    private final boolean owner;
    private RelationType relationType;
    private Entity assocEntity;

    private Relation(List<Key> keyColumns, List<String> references, RelationType relationType, Entity assocEntity, boolean owner) {
        this.keyColumns = Collections.unmodifiableList(keyColumns);
        this.references = Collections.unmodifiableList(references);
        this.relationType = relationType;
        this.assocEntity = assocEntity;
        this.owner = owner;
    }

    public List<Key> getKeyColumns() {
        return this.keyColumns;
    }

    public List<String> getReferences() {
        return this.references;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public void setKeyColumns(List<Key> keyColumns) {
        this.keyColumns = keyColumns;
    }

    public void setReferences(List<String> references) {
        this.references = references;
    }

    public void setRelationType(RelationType relationType) {
        this.relationType = relationType;
    }

    public Entity getAssocEntity() {
        return this.assocEntity;
    }

    public void setAssocEntity(Entity assocEntity) {
        this.assocEntity = assocEntity;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum RelationType {
        MANY,
        ONE,
        NONE;

    }

    public static class Builder {
        List<Key> keys = null;
        List<String> references = new ArrayList<String>();
        Entity assocEntity = null;
        RelationType relationType = RelationType.ONE;
        boolean owner;

        public void setKeys(List<Key> keys) {
            this.keys = keys;
        }

        public void setReferences(List<String> references) {
            this.references = references;
        }

        public void setOwner(boolean owner) {
            this.owner = owner;
        }

        public void setAssocEntity(Entity assocEntity) {
            this.assocEntity = assocEntity;
        }

        public void setRelationType(RelationType relationType) {
            this.relationType = relationType;
        }

        public Relation build() {
            return new Relation(this.keys, this.references, this.relationType, this.assocEntity, this.owner);
        }
    }

    public static class Key {
        private final String field;
        private final String columnName;
        private final String reference;
        private final String referenceColumnName;
        private final String type;

        public Key(String field, String columnName, String reference, String referenceColumnName, String type) {
            this.field = field;
            this.columnName = columnName;
            this.reference = reference;
            this.referenceColumnName = referenceColumnName;
            this.type = type;
        }

        public String getField() {
            return this.field;
        }

        public String getReference() {
            return this.reference;
        }

        public String getType() {
            return this.type;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getReferenceColumnName() {
            return this.referenceColumnName;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Key key = (Key)obj;
            return Objects.equals(this.field, key.field) && Objects.equals(this.columnName, key.columnName) && Objects.equals(this.reference, key.reference) && Objects.equals(this.referenceColumnName, key.referenceColumnName) && Objects.equals(this.type, key.type);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.columnName, this.reference, this.referenceColumnName, this.type);
        }

        public boolean isOnlyColumnRenamed(Key key) {
            return Objects.equals(this.field, key.field) && !Objects.equals(this.columnName, key.columnName) && Objects.equals(this.reference, key.reference) && Objects.equals(this.referenceColumnName, key.referenceColumnName) && Objects.equals(this.type, key.type);
        }
    }
}

