/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.clients;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.BalException;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.IfElse;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.nodegenerator.syntax.clients.ClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.clients.DbClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.constants.SyntaxTokenConstants;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;

public class DbMockClientSyntax
implements ClientSyntax {
    private final String dbNamePrefix;
    private final String dbSpecifics;
    private final String initDbClientMethodTemplate;
    private final DbClientSyntax dbClientSyntax;

    public DbMockClientSyntax(Module entityModule) throws BalException {
        this.dbClientSyntax = new DbClientSyntax(entityModule, "h2");
        this.dbNamePrefix = "jdbc";
        this.dbSpecifics = "psql:H2_SPECIFICS";
        this.initDbClientMethodTemplate = BalSyntaxConstants.JDBC_URL_INIT_DB_CLIENT_WITH_PARAMS;
    }

    @Override
    public NodeList<ImportDeclarationNode> getImports() throws BalException {
        return this.dbClientSyntax.getImports();
    }

    @Override
    public NodeList<ModuleMemberDeclarationNode> getConstantVariables() {
        return this.dbClientSyntax.getConstantVariables();
    }

    @Override
    public Client getClientObject(Module entityModule, String clientName) {
        return this.dbClientSyntax.getClientObject(entityModule, clientName);
    }

    @Override
    public FunctionDefinitionNode getInitFunction(Module entityModule) {
        Function init = new Function("init", SyntaxKind.OBJECT_METHOD_DEFINITION);
        init.addQualifiers(new String[]{"public", "isolated"});
        init.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "persist:Error"));
        init.addRequiredParameter((Node)TypeDescriptor.getBuiltinSimpleNameReferenceNode("string"), "url");
        init.addDefaultableParameter((Node)TypeDescriptor.getOptionalTypeDescriptorNode("", "string"), "user", (Node)NodeFactory.createNilLiteralNode((Token)SyntaxTokenConstants.SYNTAX_TREE_OPEN_PAREN, (Token)SyntaxTokenConstants.SYNTAX_TREE_CLOSE_PAREN));
        init.addDefaultableParameter((Node)TypeDescriptor.getOptionalTypeDescriptorNode("", "string"), "password", (Node)NodeFactory.createNilLiteralNode((Token)SyntaxTokenConstants.SYNTAX_TREE_OPEN_PAREN, (Token)SyntaxTokenConstants.SYNTAX_TREE_CLOSE_PAREN));
        init.addDefaultableParameter((Node)TypeDescriptor.getOptionalTypeDescriptorNode("jdbc", "Options"), "connectionOptions", (Node)NodeFactory.createNilLiteralNode((Token)SyntaxTokenConstants.SYNTAX_TREE_OPEN_PAREN, (Token)SyntaxTokenConstants.SYNTAX_TREE_CLOSE_PAREN));
        init.addStatement(NodeParser.parseStatement((String)String.format(this.initDbClientMethodTemplate, this.dbNamePrefix)));
        IfElse errorCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s is error", "dbClient")));
        errorCheck.addIfStatement(NodeParser.parseStatement((String)String.format("return <persist:Error>error(%s.message());", "dbClient")));
        init.addIfElseStatement(errorCheck.getIfElseStatementNode());
        init.addStatement(NodeParser.parseStatement((String)"self.dbClient = dbClient;"));
        StringBuilder persistClientMap = new StringBuilder();
        for (Entity entity : entityModule.getEntityMap().values()) {
            if (entity.containsUnsupportedTypes()) continue;
            if (!persistClientMap.isEmpty()) {
                persistClientMap.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            String constantName = BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()));
            String clientMapElement = String.format("[%s]: check new (dbClient, self.metadata.get(%s), %s)", constantName, constantName, this.dbSpecifics);
            persistClientMap.append(clientMapElement);
        }
        init.addStatement(NodeParser.parseStatement((String)String.format("self.persistClients = {%s};", persistClientMap)));
        return init.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getGetFunction(Entity entity) {
        return this.dbClientSyntax.getGetFunction(entity);
    }

    @Override
    public FunctionDefinitionNode getGetByKeyFunction(Entity entity) {
        return this.dbClientSyntax.getGetByKeyFunction(entity);
    }

    @Override
    public FunctionDefinitionNode getCloseFunction() {
        return this.dbClientSyntax.getCloseFunction();
    }

    @Override
    public FunctionDefinitionNode getPostFunction(Entity entity) {
        return this.dbClientSyntax.getPostFunction(entity);
    }

    @Override
    public FunctionDefinitionNode getPutFunction(Entity entity) {
        return this.dbClientSyntax.getPutFunction(entity);
    }

    @Override
    public FunctionDefinitionNode getDeleteFunction(Entity entity) {
        return this.dbClientSyntax.getDeleteFunction(entity);
    }

    @Override
    public FunctionDefinitionNode getQueryNativeSQLFunction() {
        return this.dbClientSyntax.getQueryNativeSQLFunction();
    }

    @Override
    public FunctionDefinitionNode getExecuteNativeSQLFunction() {
        return this.dbClientSyntax.getExecuteNativeSQLFunction();
    }
}

