/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.clients;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.BalException;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.IfElse;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.nodegenerator.syntax.clients.ClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.constants.SyntaxTokenConstants;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import java.util.List;
import java.util.Locale;

public class RedisClientSyntax
implements ClientSyntax {
    private final Module entityModule;
    private final String datasource;
    private final String importPackage;
    private final String nativeClass;
    private final String initDbClientMethodTemplate;

    public RedisClientSyntax(Module entityModule) {
        this.entityModule = entityModule;
        this.importPackage = this.datasource = "redis";
        this.nativeClass = "RedisProcessor";
        this.initDbClientMethodTemplate = BalSyntaxConstants.INIT_REDIS_DB_CLIENT_WITH_PARAMS;
    }

    @Override
    public NodeList<ImportDeclarationNode> getImports() throws BalException {
        NodeList imports = BalSyntaxUtils.generateImport(this.entityModule);
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerinax", this.importPackage, null));
        IdentifierToken prefixToken = AbstractNodeFactory.createIdentifierToken((String)"predis");
        ImportPrefixNode prefix = NodeFactory.createImportPrefixNode((Token)SyntaxTokenConstants.SYNTAX_TREE_AS, (Token)prefixToken);
        imports = imports.add((Node)BalSyntaxUtils.getImportDeclarationNode("ballerinax", "persist.redis", prefix));
        return imports;
    }

    @Override
    public NodeList<ModuleMemberDeclarationNode> getConstantVariables() {
        return BalSyntaxUtils.generateConstantVariables(this.entityModule);
    }

    @Override
    public Client getClientObject(Module entityModule, String clientName) {
        Client clientObject = BalSyntaxUtils.generateClientSignature(clientName, true);
        clientObject.addMember(NodeParser.parseObjectMember((String)String.format("private final %s:Client dbClient;", this.datasource)), true);
        clientObject.addMember(NodeParser.parseObjectMember((String)"private final map<predis:RedisClient> persistClients;"), true);
        clientObject.addMember(RedisClientSyntax.generateMetadataRecord(entityModule), true);
        return clientObject;
    }

    @Override
    public FunctionDefinitionNode getInitFunction(Module entityModule) {
        Function init = new Function("init", SyntaxKind.OBJECT_METHOD_DEFINITION);
        init.addQualifiers(new String[]{"public", "isolated"});
        init.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "persist:Error"));
        init.addStatement(NodeParser.parseStatement((String)String.format(this.initDbClientMethodTemplate, this.datasource)));
        IfElse errorCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s is error", "dbClient")));
        errorCheck.addIfStatement(NodeParser.parseStatement((String)String.format("return <persist:Error>error(%s.message());", "dbClient")));
        init.addIfElseStatement(errorCheck.getIfElseStatementNode());
        init.addStatement(NodeParser.parseStatement((String)"self.dbClient = dbClient;"));
        StringBuilder persistClientMap = new StringBuilder();
        for (Entity entity : entityModule.getEntityMap().values()) {
            if (persistClientMap.length() != 0) {
                persistClientMap.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            String constantName = BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()));
            String clientMapElement = String.format("[%s]: check new (dbClient, self.metadata.get(%s), cacheConfig.maxAge)", constantName, constantName);
            persistClientMap.append(clientMapElement);
        }
        init.addStatement(NodeParser.parseStatement((String)String.format("self.persistClients = {%s};", persistClientMap)));
        return init.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getGetFunction(Entity entity) {
        return (FunctionDefinitionNode)NodeParser.parseObjectMember((String)String.format(BalSyntaxConstants.EXTERNAL_REDIS_GET_METHOD_TEMPLATE, entity.getClientResourceName(), entity.getEntityName(), "redis", this.nativeClass));
    }

    @Override
    public FunctionDefinitionNode getGetByKeyFunction(Entity entity) {
        return BalSyntaxUtils.generateGetByKeyFunction(entity, this.nativeClass, "redis");
    }

    @Override
    public FunctionDefinitionNode getCloseFunction() {
        Function close = BalSyntaxUtils.generateCloseFunction();
        close.addStatement(NodeParser.parseStatement((String)"error? result = self.dbClient.close();"));
        IfElse errorCheck = new IfElse(NodeParser.parseExpression((String)String.format("%s is error", "result")));
        errorCheck.addIfStatement(NodeParser.parseStatement((String)String.format("return <persist:Error>error(%s.message());", "result")));
        close.addIfElseStatement(errorCheck.getIfElseStatementNode());
        close.addStatement(NodeParser.parseStatement((String)"return result;"));
        return close.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getPostFunction(Entity entity) {
        String parameterType = String.format("%sInsert", entity.getEntityName());
        List<EntityField> primaryKeys = entity.getKeys();
        Function create = BalSyntaxUtils.generatePostFunction(entity, primaryKeys, parameterType);
        RedisClientSyntax.addFunctionBodyToPostResource(create, primaryKeys, BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName()), parameterType);
        return create.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getPutFunction(Entity entity) {
        StringBuilder filterKeys = new StringBuilder("{");
        StringBuilder path = new StringBuilder("/" + entity.getClientResourceName());
        Function update = BalSyntaxUtils.generatePutFunction(entity, filterKeys, path);
        update.addStatement(NodeParser.parseStatement((String)"predis:RedisClient redisClient;"));
        String getPersistClientStatement = String.format("redisClient = self.persistClients.get(%s);", BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName())));
        update.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
        String updateStatement = entity.getKeys().size() > 1 ? String.format("_ = check redisClient.runUpdateQuery(%s, value);", filterKeys.substring(0, filterKeys.length() - 2).concat("}")) : String.format("_ = check redisClient.runUpdateQuery(%s, value);", ((EntityField)entity.getKeys().stream().findFirst().get()).getFieldName());
        update.addStatement(NodeParser.parseStatement((String)updateStatement));
        update.addStatement(NodeParser.parseStatement((String)String.format("return self->%s.get();", path)));
        return update.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getDeleteFunction(Entity entity) {
        StringBuilder filterKeys = new StringBuilder("{");
        StringBuilder path = new StringBuilder("/" + entity.getClientResourceName());
        Function delete = BalSyntaxUtils.generateDeleteFunction(entity, filterKeys, path);
        delete.addStatement(NodeParser.parseStatement((String)String.format("%s result = check self->%s.get();", entity.getEntityName(), path)));
        delete.addStatement(NodeParser.parseStatement((String)"predis:RedisClient redisClient;"));
        String getPersistClientStatement = String.format("redisClient = self.persistClients.get(%s);", BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName())));
        delete.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
        String deleteStatement = entity.getKeys().size() > 1 ? String.format("_ = check redisClient.runDeleteQuery(%s);", filterKeys.substring(0, filterKeys.length() - 2).concat("}")) : String.format("_ = check redisClient.runDeleteQuery(%s);", ((EntityField)entity.getKeys().stream().findFirst().get()).getFieldName());
        delete.addStatement(NodeParser.parseStatement((String)deleteStatement));
        delete.addStatement(NodeParser.parseStatement((String)"return result;"));
        return delete.getFunctionDefinitionNode();
    }

    @Override
    public FunctionDefinitionNode getQueryNativeSQLFunction() {
        throw new UnsupportedOperationException("Query native SQL is not supported for Redis DB");
    }

    @Override
    public FunctionDefinitionNode getExecuteNativeSQLFunction() {
        throw new UnsupportedOperationException("Execute native SQL is not supported for Redis DB");
    }

    private static String getDataTypeInAllCaps(String fieldType) {
        switch (fieldType) {
            case "int": 
            case "float": 
            case "decimal": 
            case "boolean": 
            case "ENUM": {
                return fieldType.toUpperCase(Locale.ENGLISH);
            }
            case "time:Date": {
                return "DATE";
            }
            case "time:TimeOfDay": {
                return "TIME_OF_DAY";
            }
            case "time:Utc": {
                return "UTC";
            }
            case "time:Civil": {
                return "CIVIL";
            }
        }
        return "STRING";
    }

    private static Node generateMetadataRecord(Module entityModule) {
        StringBuilder mapBuilder = new StringBuilder();
        for (Entity entity : entityModule.getEntityMap().values()) {
            if (mapBuilder.length() != 0) {
                mapBuilder.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            StringBuilder entityMetaData = new StringBuilder();
            entityMetaData.append(String.format(BalSyntaxConstants.METADATA_RECORD_ENTITY_NAME_TEMPLATE, BalSyntaxUtils.stripEscapeCharacter(entity.getEntityName())));
            entityMetaData.append(String.format(BalSyntaxConstants.REDIS_METADATA_RECORD_COLLECTION_NAME_TEMPLATE, BalSyntaxUtils.stripEscapeCharacter(entity.getEntityName())));
            StringBuilder fieldMetaData = new StringBuilder();
            StringBuilder associateFieldMetaData = new StringBuilder();
            boolean relationsExists = false;
            for (EntityField entityField : entity.getFields()) {
                if (entityField.getRelation() != null) {
                    relationsExists = true;
                    StringBuilder foreignKeyFields = new StringBuilder();
                    if (entityField.getRelation().isOwner()) {
                        if (fieldMetaData.length() != 0) {
                            fieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                        }
                        for (Relation.Key key : entityField.getRelation().getKeyColumns()) {
                            if (foreignKeyFields.length() != 0) {
                                foreignKeyFields.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                            }
                            foreignKeyFields.append(String.format("%s: {fieldName: \"%s\", fieldDataType: predis:%s}", key.getField(), BalSyntaxUtils.stripEscapeCharacter(key.getField()), RedisClientSyntax.getDataTypeInAllCaps(key.getType())));
                        }
                    }
                    fieldMetaData.append((CharSequence)foreignKeyFields);
                    Entity associatedEntity = entityField.getRelation().getAssocEntity();
                    for (EntityField associatedEntityField : associatedEntity.getFields()) {
                        if (associatedEntityField.getRelation() == null) {
                            if (associateFieldMetaData.length() != 0) {
                                associateFieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                            }
                            associateFieldMetaData.append(String.format((entityField.isArrayType() ? "\"%s[]" : "\"%s") + ".%s\": {relation: {entityName: \"%s\", refField: \"%s\", refFieldDataType: predis:%s}}", BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(associatedEntityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(associatedEntityField.getFieldName()), RedisClientSyntax.getDataTypeInAllCaps(associatedEntityField.getFieldType())));
                            continue;
                        }
                        if (!associatedEntityField.getRelation().isOwner()) continue;
                        for (Relation.Key key : associatedEntityField.getRelation().getKeyColumns()) {
                            if (associateFieldMetaData.length() != 0) {
                                associateFieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                            }
                            associateFieldMetaData.append(String.format((entityField.isArrayType() ? "\"%s[]" : "\"%s") + ".%s\": {relation: {entityName: \"%s\", refField: \"%s\", refFieldDataType: predis:%s}}", entityField.getFieldName(), key.getField(), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), BalSyntaxUtils.stripEscapeCharacter(key.getField()), RedisClientSyntax.getDataTypeInAllCaps(key.getType())));
                        }
                    }
                    continue;
                }
                if (fieldMetaData.length() != 0) {
                    fieldMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
                }
                fieldMetaData.append(String.format("%s: {fieldName: \"%s\", fieldDataType: predis:%s}", entityField.getFieldName(), BalSyntaxUtils.stripEscapeCharacter(entityField.getFieldName()), RedisClientSyntax.getDataTypeInAllCaps(entityField.getFieldType())));
            }
            if (associateFieldMetaData.length() > 1) {
                fieldMetaData.append(",");
                fieldMetaData.append((CharSequence)associateFieldMetaData);
            }
            entityMetaData.append(String.format("fieldMetadata: {%s}", fieldMetaData));
            entityMetaData.append(", ");
            StringBuilder keyFields = new StringBuilder();
            for (EntityField key : entity.getKeys()) {
                if (keyFields.length() != 0) {
                    keyFields.append(", ");
                }
                keyFields.append("\"").append(BalSyntaxUtils.stripEscapeCharacter(key.getFieldName())).append("\"");
            }
            entityMetaData.append(String.format("keyFields: [%s]", keyFields));
            if (relationsExists) {
                entityMetaData.append(", ");
                String string = RedisClientSyntax.getJoinMetaData(entity);
                entityMetaData.append(String.format("refMetadata: {%s}", string));
            }
            mapBuilder.append(String.format("[%s]: {%s}", BalSyntaxUtils.stripEscapeCharacter(BalSyntaxUtils.getStringWithUnderScore(entity.getEntityName())), entityMetaData));
        }
        return NodeParser.parseObjectMember((String)String.format("private final record {|predis:RedisMetadata...;|} & readonly metadata = {%s};", mapBuilder));
    }

    private static String getJoinMetaData(Entity entity) {
        StringBuilder joinMetaData = new StringBuilder();
        for (EntityField entityField : entity.getFields()) {
            StringBuilder refColumns = new StringBuilder();
            StringBuilder joinColumns = new StringBuilder();
            if (entityField.getRelation() == null) continue;
            String relationType = "predis:ONE_TO_ONE";
            Entity associatedEntity = entityField.getRelation().getAssocEntity();
            String associatedFieldName = "";
            for (EntityField associatedEntityField : associatedEntity.getFields()) {
                if (!associatedEntityField.getFieldType().equals(entity.getEntityName())) continue;
                boolean isCorrectMapping = true;
                for (EntityField key : associatedEntity.getKeys()) {
                    String fieldName = key.getFieldName();
                    String capitalizedFieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                    String associatedReference = entityField.getFieldName().toLowerCase(Locale.ENGLISH).concat(capitalizedFieldName);
                    if (associatedEntityField.getRelation().getReferences().contains(associatedReference)) continue;
                    isCorrectMapping = false;
                    break;
                }
                if (associatedEntityField.isArrayType() && !entityField.isArrayType()) {
                    relationType = "predis:ONE_TO_MANY";
                } else if (!associatedEntityField.isArrayType() && entityField.isArrayType()) {
                    relationType = "predis:MANY_TO_ONE";
                } else if (associatedEntityField.isArrayType() && entityField.isArrayType()) {
                    relationType = "predis:MANY_TO_MANY";
                }
                if (!isCorrectMapping) continue;
                associatedFieldName = associatedEntityField.getFieldName();
            }
            if (joinMetaData.length() > 0) {
                joinMetaData.append(BalSyntaxConstants.COMMA_WITH_NEWLINE);
            }
            for (Relation.Key key : entityField.getRelation().getKeyColumns()) {
                if (joinColumns.length() > 0) {
                    joinColumns.append(",");
                }
                if (refColumns.length() > 0) {
                    refColumns.append(",");
                }
                refColumns.append(String.format("\"%s\"", BalSyntaxUtils.stripEscapeCharacter(key.getReference())));
                joinColumns.append(String.format("\"%s\"", BalSyntaxUtils.stripEscapeCharacter(key.getField())));
            }
            if (associatedFieldName.isEmpty()) {
                joinMetaData.append(String.format("%s: {entity: %s, fieldName: \"%s\", refCollection: \"%s\", refFields: [%s], joinFields: [%s], 'type: %s}", entityField.getFieldName(), entityField.getFieldType(), entityField.getFieldName(), entityField.getFieldType(), refColumns, joinColumns, relationType));
                continue;
            }
            joinMetaData.append(String.format("%s: {entity: %s, fieldName: \"%s\", refCollection: \"%s\", refMetaDataKey: \"%s\", refFields: [%s], joinFields: [%s], 'type: %s}", entityField.getFieldName(), entityField.getFieldType(), entityField.getFieldName(), entityField.getFieldType(), associatedFieldName, refColumns, joinColumns, relationType));
        }
        return joinMetaData.toString();
    }

    private static void addFunctionBodyToPostResource(Function create, List<EntityField> primaryKeys, String tableName, String parameterType) {
        create.addStatement(NodeParser.parseStatement((String)"predis:RedisClient redisClient;"));
        String getPersistClientStatement = String.format("redisClient = self.persistClients.get(%s);", BalSyntaxUtils.stripEscapeCharacter(tableName));
        create.addStatement(NodeParser.parseStatement((String)String.format("lock {%s}", getPersistClientStatement)));
        create.addStatement(NodeParser.parseStatement((String)"_ = check redisClient.runBatchInsertQuery(data);"));
        create.addStatement(NodeParser.parseStatement((String)String.format(BalSyntaxConstants.RETURN_CREATED_KEY, parameterType)));
        StringBuilder filterKeys = new StringBuilder();
        for (int i = 0; i < primaryKeys.size(); ++i) {
            filterKeys.append("inserted.").append(primaryKeys.get(i).getFieldName());
            if (i >= primaryKeys.size() - 1) continue;
            filterKeys.append(",");
        }
        filterKeys = primaryKeys.size() == 1 ? new StringBuilder("\t\t\tselect " + String.valueOf(filterKeys) + ";") : new StringBuilder("\t\t\tselect [" + String.valueOf(filterKeys) + "];");
        create.addStatement(NodeParser.parseStatement((String)filterKeys.toString()));
    }
}

