/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.sources;

import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.BalException;
import io.ballerina.persist.PersistToolsConstants;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.ClientResource;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.nodegenerator.syntax.clients.ClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.clients.DbClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.clients.DbMockClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.constants.SyntaxTokenConstants;
import io.ballerina.persist.nodegenerator.syntax.sources.RDBMSSyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import io.ballerina.persist.utils.BalProjectUtils;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.Collection;

public class DbSyntaxTree
implements RDBMSSyntaxTree {
    @Override
    public SyntaxTree getClientSyntax(Module entityModule, String datasource) throws BalException {
        DbClientSyntax dbClientSyntax = new DbClientSyntax(entityModule, datasource);
        NodeList<ImportDeclarationNode> imports = dbClientSyntax.getImports();
        NodeList moduleMembers = dbClientSyntax.getConstantVariables();
        Client clientObject = DbSyntaxTree.getClientObject(entityModule, dbClientSyntax, "Client");
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)clientObject.getClassDefinitionNode());
        return BalSyntaxUtils.generateSyntaxTree(imports, (NodeList<ModuleMemberDeclarationNode>)moduleMembers);
    }

    @Override
    public SyntaxTree getTestClientSyntax(Module entityModule) throws BalException {
        DbMockClientSyntax dbClientSyntax = new DbMockClientSyntax(entityModule);
        NodeList<ImportDeclarationNode> imports = dbClientSyntax.getImports();
        NodeList moduleMembers = dbClientSyntax.getConstantVariables();
        Client clientObject = DbSyntaxTree.getClientObject(entityModule, dbClientSyntax, "H2Client");
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)clientObject.getClassDefinitionNode());
        return BalSyntaxUtils.generateSyntaxTree(imports, (NodeList<ModuleMemberDeclarationNode>)moduleMembers);
    }

    private static Client getClientObject(Module entityModule, ClientSyntax dbClientSyntax, String clientName) throws BalException {
        Client clientObject = dbClientSyntax.getClientObject(entityModule, clientName);
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        if (entityArray.isEmpty()) {
            throw new BalException("data definition file() does not contain any entities.");
        }
        clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getInitFunction(entityModule), true);
        ArrayList<ClientResource> resourceList = new ArrayList<ClientResource>();
        for (Entity entity : entityArray) {
            if (entity.containsUnsupportedTypes()) continue;
            ClientResource resource2 = new ClientResource();
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getGetFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getGetByKeyFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getPostFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getPutFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getDeleteFunction(entity), true);
            resourceList.add(resource2);
        }
        resourceList.forEach(resource -> resource.getFunctions().forEach(function -> clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)function, false)));
        clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getQueryNativeSQLFunction(), true);
        clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getExecuteNativeSQLFunction(), true);
        clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)dbClientSyntax.getCloseFunction(), true);
        return clientObject;
    }

    @Override
    public SyntaxTree getDataTypesSyntax(Module entityModule) {
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        if (!entityArray.isEmpty()) {
            return BalSyntaxUtils.generateTypeSyntaxTree(entityModule, "");
        }
        return null;
    }

    @Override
    public SyntaxTree getDataStoreConfigSyntax(String datasource) {
        NodeList imports = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEmptyNodeList();
        NodeList moduleMembers = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEmptyNodeList();
        MinutiaeList commentMinutiaeList = DbSyntaxTree.createCommentMinutiaeList(String.format("// This file is an auto-generated file by Ballerina persistence layer.", new Object[0]));
        imports = imports.add((io.ballerina.compiler.syntax.tree.Node)DbSyntaxTree.getImportDeclarationNodeWithAutogeneratedComment(datasource, commentMinutiaeList));
        if (PersistToolsConstants.SUPPORTED_VIA_JDBC_CONNECTOR.contains(datasource)) {
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable string url = ?;"));
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable string user = ?;"));
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable string password = ?;"));
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)String.format("configurable %s:Options & readonly connectionOptions = {};", "jdbc")));
        } else {
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable int port = ?;"));
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable string host = ?;"));
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable string user = ?;"));
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable string database = ?;"));
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable string password = ?;"));
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)String.format("configurable %s:Options & readonly connectionOptions = {};", datasource)));
        }
        if (PersistToolsConstants.CUSTOM_SCHEMA_SUPPORTED_DB_PROVIDERS.contains(datasource)) {
            moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModuleMemberDeclaration((String)"configurable string? defaultSchema = ();"));
        }
        io.ballerina.compiler.syntax.tree.IdentifierToken eofToken = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree balTree = SyntaxTree.from((TextDocument)textDocument);
        return balTree.modifyWith((io.ballerina.compiler.syntax.tree.Node)modulePartNode);
    }

    @Override
    public SyntaxTree getConfigTomlSyntax(String moduleName, String datasource) throws BalException {
        io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createTable((String)moduleName, null));
        moduleMembers = DbSyntaxTree.populateConfigNodeList(moduleMembers, datasource);
        moduleMembers = BalProjectUtils.addNewLine(moduleMembers, 1);
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        DocumentNode documentNode = io.ballerina.toml.syntax.tree.NodeFactory.createDocumentNode(moduleMembers, (io.ballerina.toml.syntax.tree.Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)documentNode.toSourceCode());
        return SyntaxTree.from((TextDocument)textDocument);
    }

    private static ImportDeclarationNode getImportDeclarationNodeWithAutogeneratedComment(String datasource, MinutiaeList commentMinutiaeList) {
        io.ballerina.compiler.syntax.tree.IdentifierToken orgNameToken = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createIdentifierToken((String)"ballerinax");
        ImportOrgNameNode importOrgNameNode = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)SyntaxTokenConstants.SYNTAX_TREE_SLASH);
        String moduleName = datasource;
        if (PersistToolsConstants.SUPPORTED_VIA_JDBC_CONNECTOR.contains(datasource)) {
            moduleName = "java.jdbc";
        }
        io.ballerina.compiler.syntax.tree.IdentifierToken moduleNameToken = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createIdentifierToken((String)moduleName);
        SeparatedNodeList moduleNodeList = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createSeparatedNodeList((io.ballerina.compiler.syntax.tree.Node[])new io.ballerina.compiler.syntax.tree.Node[]{moduleNameToken});
        Token importToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.IMPORT_KEYWORD, (MinutiaeList)commentMinutiaeList, (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createWhitespaceMinutiae((String)" ")}));
        return NodeFactory.createImportDeclarationNode((Token)importToken, (ImportOrgNameNode)importOrgNameNode, (SeparatedNodeList)moduleNodeList, null, (Token)SyntaxTokenConstants.SYNTAX_TREE_SEMICOLON);
    }

    private static io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> populateConfigNodeList(io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> moduleMembers, String datasource) throws BalException {
        if (PersistToolsConstants.SUPPORTED_VIA_JDBC_CONNECTOR.contains(datasource)) {
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"url", (String)"", null));
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"user", (String)"", null));
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"password", (String)"", null));
        } else {
            String port;
            String host;
            String password = "";
            String database = "";
            String user = switch (datasource) {
                case "mysql" -> {
                    host = "localhost";
                    port = "3306";
                    yield "root";
                }
                case "mssql" -> {
                    host = "localhost";
                    port = "1433";
                    yield "sa";
                }
                case "postgresql" -> {
                    host = "localhost";
                    port = "5432";
                    yield "postgres";
                }
                default -> throw new BalException("Unsupported datasource: " + datasource);
            };
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"host", (String)host, null));
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createNumericKV((String)"port", (String)port, null));
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"user", (String)user, null));
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"password", (String)password, null));
            moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"database", (String)database, null));
        }
        return moduleMembers;
    }

    protected static MinutiaeList createCommentMinutiaeList(String comment) {
        return NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createCommentMinutiae((String)"// AUTO-GENERATED FILE. DO NOT MODIFY."), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createCommentMinutiae((String)comment), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createCommentMinutiae((String)"// It should not be modified by hand."), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator()), io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEndOfLineMinutiae((String)System.lineSeparator())});
    }

    public SyntaxTree getTestInitSyntax(String[] dbScripts) {
        NodeList imports = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEmptyNodeList();
        NodeList moduleMembers = io.ballerina.compiler.syntax.tree.AbstractNodeFactory.createEmptyNodeList();
        MinutiaeList commentMinutiaeList = DbSyntaxTree.createCommentMinutiaeList(String.format("// This file is an auto-generated file by Ballerina persistence layer.", new Object[0]));
        imports = imports.add((io.ballerina.compiler.syntax.tree.Node)BalSyntaxUtils.getImportDeclarationNodeWithAutogeneratedComment("persist", commentMinutiaeList));
        ModuleMemberDeclarationNode moduleMemberDeclarationNode = NodeParser.parseModuleMemberDeclaration((String)BalSyntaxConstants.MOCK_H2_CLIENT_INIT);
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)moduleMemberDeclarationNode);
        Function beforeFunction = new Function("setupTestDB", SyntaxKind.METHOD_DECLARATION);
        beforeFunction.addQualifiers(new String[]{"public", "isolated"});
        beforeFunction.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "persist:Error"));
        for (String dbScript : dbScripts) {
            if (dbScript.equals(BalSyntaxConstants.NEWLINE)) continue;
            beforeFunction.addStatement(NodeParser.parseStatement((String)String.format("_ = check h2Client->executeNativeSQL(`%s`);", dbScript)));
        }
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)beforeFunction.getFunctionDefinitionNode());
        Function afterFunction = new Function("cleanupTestDB", SyntaxKind.METHOD_DECLARATION);
        afterFunction.addQualifiers(new String[]{"public", "isolated"});
        afterFunction.addReturns((TypeDescriptorNode)TypeDescriptor.getOptionalTypeDescriptorNode("", "persist:Error"));
        for (String dbScript : dbScripts) {
            if (!dbScript.startsWith("DROP")) continue;
            afterFunction.addStatement(NodeParser.parseStatement((String)String.format("_ = check h2Client->executeNativeSQL(`%s`);", dbScript)));
        }
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)afterFunction.getFunctionDefinitionNode());
        return BalSyntaxUtils.generateSyntaxTree((NodeList<ImportDeclarationNode>)imports, (NodeList<ModuleMemberDeclarationNode>)moduleMembers);
    }
}

