/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.nodegenerator.syntax.sources;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.persist.BalException;
import io.ballerina.persist.components.Client;
import io.ballerina.persist.components.ClientResource;
import io.ballerina.persist.components.Function;
import io.ballerina.persist.components.TypeDescriptor;
import io.ballerina.persist.models.Entity;
import io.ballerina.persist.models.EntityField;
import io.ballerina.persist.models.Module;
import io.ballerina.persist.models.Relation;
import io.ballerina.persist.nodegenerator.syntax.clients.GSheetClientSyntax;
import io.ballerina.persist.nodegenerator.syntax.constants.BalSyntaxConstants;
import io.ballerina.persist.nodegenerator.syntax.sources.SyntaxTree;
import io.ballerina.persist.nodegenerator.syntax.utils.BalSyntaxUtils;
import io.ballerina.persist.utils.BalProjectUtils;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;

public class GSheetSyntaxTree
implements SyntaxTree {
    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getClientSyntax(Module entityModule) throws BalException {
        GSheetClientSyntax gSheetClientSyntax = new GSheetClientSyntax(entityModule);
        NodeList<ImportDeclarationNode> imports = gSheetClientSyntax.getImports();
        NodeList moduleMembers = gSheetClientSyntax.getConstantVariables();
        Client clientObject = gSheetClientSyntax.getClientObject(entityModule, "Client");
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        if (entityArray.size() == 0) {
            throw new BalException("data definition file() does not contain any entities.");
        }
        clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)gSheetClientSyntax.getInitFunction(entityModule), true);
        ArrayList<ClientResource> resourceList = new ArrayList<ClientResource>();
        for (Entity entity : entityArray) {
            ClientResource resource2 = new ClientResource();
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)gSheetClientSyntax.getGetFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)gSheetClientSyntax.getGetByKeyFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)gSheetClientSyntax.getPostFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)gSheetClientSyntax.getPutFunction(entity), true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)gSheetClientSyntax.getDeleteFunction(entity), true);
            FunctionDefinitionNode[] functions = this.createQueryFunction(entity);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)functions[0], true);
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)functions[1], true);
            String entityResourceName = entity.getClientResourceName();
            resource2.addFunction((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseStatement((String)String.format(BalSyntaxConstants.EXTERNAL_QUERY_STREAM_METHOD_TEMPLATE, entityResourceName.substring(0, 1).toUpperCase(Locale.ENGLISH) + entityResourceName.substring(1), entity.getEntityName(), "googlesheets")), true);
            resourceList.add(resource2);
        }
        resourceList.forEach(resource -> resource.getFunctions().forEach(function -> clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)function, false)));
        for (Map.Entry entry : gSheetClientSyntax.getQueryMethodStatementEntries()) {
            Function query = new Function((String)entry.getKey(), SyntaxKind.OBJECT_METHOD_DEFINITION);
            query.addQualifiers(new String[]{"private", "isolated"});
            query.addReturns((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode("record{}[]|persist:Error"));
            query.addRequiredParameter((io.ballerina.compiler.syntax.tree.Node)TypeDescriptor.getSimpleNameReferenceNode("record{}"), "value");
            query.addRequiredParameter((io.ballerina.compiler.syntax.tree.Node)TypeDescriptor.getArrayTypeDescriptorNode("string"), "fields");
            query.addStatement(NodeParser.parseStatement((String)((String)entry.getValue())));
            clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)query.getFunctionDefinitionNode(), true);
        }
        clientObject.addMember((io.ballerina.compiler.syntax.tree.Node)gSheetClientSyntax.getCloseFunction(), true);
        moduleMembers = moduleMembers.add((io.ballerina.compiler.syntax.tree.Node)clientObject.getClassDefinitionNode());
        return BalSyntaxUtils.generateSyntaxTree(imports, (NodeList<ModuleMemberDeclarationNode>)moduleMembers);
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getTestClientSyntax(Module entityModule) throws BalException {
        throw new BalException("Not supported yet.");
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getDataTypesSyntax(Module entityModule) throws BalException {
        Collection<Entity> entityArray = entityModule.getEntityMap().values();
        if (entityArray.size() != 0) {
            return BalSyntaxUtils.generateTypeSyntaxTree(entityModule, "googlesheets");
        }
        return null;
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getDataStoreConfigSyntax() {
        String content = "// AUTO-GENERATED FILE. DO NOT MODIFY." + System.lineSeparator() + System.lineSeparator() + "// This file is an auto-generated file by Ballerina persistence layer." + System.lineSeparator() + "// It should not be modified by hand." + System.lineSeparator() + System.lineSeparator() + BalSyntaxConstants.CONFIGURABLE_CLIENT_ID + BalSyntaxConstants.CONFIGURABLE_CLIENT_SECRET + BalSyntaxConstants.CONFIGURABLE_REFRESH_TOKEN + BalSyntaxConstants.CONFIGURABLE_WORK_SHEET_ID;
        TextDocument textDocument = TextDocuments.from((String)"");
        io.ballerina.compiler.syntax.tree.SyntaxTree balTree = io.ballerina.compiler.syntax.tree.SyntaxTree.from((TextDocument)textDocument);
        return balTree.modifyWith((io.ballerina.compiler.syntax.tree.Node)NodeParser.parseModulePart((String)content));
    }

    @Override
    public io.ballerina.compiler.syntax.tree.SyntaxTree getConfigTomlSyntax(String moduleName) {
        io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> moduleMembers = AbstractNodeFactory.createEmptyNodeList();
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createTable((String)moduleName, null));
        moduleMembers = GSheetSyntaxTree.populateConfigNodeList(moduleMembers);
        moduleMembers = BalProjectUtils.addNewLine(moduleMembers, 1);
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        DocumentNode documentNode = NodeFactory.createDocumentNode(moduleMembers, (Token)eofToken);
        TextDocument textDocument = TextDocuments.from((String)documentNode.toSourceCode());
        return io.ballerina.compiler.syntax.tree.SyntaxTree.from((TextDocument)textDocument);
    }

    private static io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> populateConfigNodeList(io.ballerina.toml.syntax.tree.NodeList<DocumentMemberDeclarationNode> moduleMembers) {
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"spreadsheetId", (String)"", null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"clientId", (String)"", null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"clientSecret", (String)"", null));
        moduleMembers = moduleMembers.add((Node)SampleNodeGenerator.createStringKV((String)"refreshToken", (String)"", null));
        return moduleMembers;
    }

    private FunctionDefinitionNode[] createQueryFunction(Entity entity) {
        String resourceName = entity.getClientResourceName();
        String nameInCamelCase = resourceName.substring(0, 1).toUpperCase(Locale.ENGLISH) + resourceName.substring(1);
        StringBuilder queryBuilder = new StringBuilder();
        StringBuilder queryOneBuilder = new StringBuilder();
        Function query = new Function(String.format("query%s", nameInCamelCase), SyntaxKind.OBJECT_METHOD_DEFINITION);
        query.addQualifiers(new String[]{"private", "isolated"});
        query.addReturns((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode("stream<record{}, persist:Error?>|persist:Error"));
        query.addRequiredParameter((io.ballerina.compiler.syntax.tree.Node)TypeDescriptor.getArrayTypeDescriptorNode("string"), "fields");
        Function queryOne = new Function(String.format("queryOne%s", nameInCamelCase), SyntaxKind.OBJECT_METHOD_DEFINITION);
        queryOne.addQualifiers(new String[]{"private", "isolated"});
        queryOne.addReturns((TypeDescriptorNode)TypeDescriptor.getSimpleNameReferenceNode("record {}|persist:Error"));
        queryOne.addRequiredParameter((io.ballerina.compiler.syntax.tree.Node)TypeDescriptor.getSimpleNameReferenceNode("anydata"), "key");
        this.createQuery(entity, queryBuilder, queryOneBuilder);
        query.addStatement(NodeParser.parseStatement((String)queryBuilder.toString()));
        queryOne.addStatement(NodeParser.parseStatement((String)queryOneBuilder.toString()));
        queryOne.addStatement(NodeParser.parseStatement((String)String.format("return persist:getNotFoundError(\"%s\", key);", entity.getEntityName())));
        return new FunctionDefinitionNode[]{query.getFunctionDefinitionNode(), queryOne.getFunctionDefinitionNode()};
    }

    private void createQuery(Entity entity, StringBuilder queryBuilder, StringBuilder queryOneBuilder) {
        StringBuilder relationalRecordFields = new StringBuilder();
        String entityName = entity.getEntityName();
        String entityResourceName = entity.getClientResourceName();
        String resourceNameInCamelCase = entityResourceName.substring(0, 1).toUpperCase(Locale.ENGLISH) + entityResourceName.substring(1);
        StringBuilder streamInitBuilder = new StringBuilder();
        StringBuilder streamSelectBuilder = new StringBuilder();
        String stream = "Stream";
        streamInitBuilder.append(String.format("stream<%s, persist:Error?> %sStream = self.query%sStream();", entityName, entityResourceName, resourceNameInCamelCase));
        ArrayList<String> addedEntities = new ArrayList<String>();
        for (EntityField fields : entity.getFields()) {
            Relation relation;
            if (fields.getRelation() == null || !(relation = fields.getRelation()).isOwner()) continue;
            Entity assocEntity = relation.getAssocEntity();
            String assocEntityName = assocEntity.getEntityName();
            String assocEntityResourceName = assocEntity.getClientResourceName();
            String assocResourceNameInCamelCase = assocEntityResourceName.substring(0, 1).toUpperCase(Locale.ENGLISH) + assocEntityResourceName.substring(1);
            if (!addedEntities.contains(assocEntityResourceName)) {
                streamInitBuilder.append(String.format("stream<%s, persist:Error?> %sStream = self.query%sStream();", assocEntityName, assocEntityResourceName, assocResourceNameInCamelCase));
                addedEntities.add(assocEntityResourceName);
            }
            String assocFieldName = fields.getFieldName();
            streamSelectBuilder.append(String.format("    outer join var %s in %s%s", assocFieldName.toLowerCase(Locale.ENGLISH), "", assocEntityResourceName + stream));
            streamSelectBuilder.append(" on ");
            relationalRecordFields.append(String.format("\"%s\": %s,", assocFieldName.toLowerCase(Locale.ENGLISH), assocFieldName.toLowerCase(Locale.ENGLISH)));
            int i = 0;
            StringBuilder arrayFields = new StringBuilder();
            StringBuilder arrayValues = new StringBuilder();
            arrayFields.append("[");
            arrayValues.append("[");
            for (String references : relation.getReferences()) {
                if (i > 0) {
                    arrayFields.append(", ");
                    arrayValues.append(", ");
                }
                arrayFields.append(String.format("'object.%s", relation.getKeyColumns().get(i).getField()));
                arrayValues.append(String.format("%s?.%s", assocFieldName.toLowerCase(Locale.ENGLISH), references));
                ++i;
            }
            streamSelectBuilder.append((CharSequence)arrayFields.append("]"));
            streamSelectBuilder.append(" equals ");
            streamSelectBuilder.append((CharSequence)arrayValues.append("]"));
        }
        queryBuilder.append((CharSequence)streamInitBuilder);
        String streamParamName = entityResourceName + stream;
        queryBuilder.append("record{}[] outputArray =").append(String.format("%s from record{} 'object in %s%s", "check", "", streamParamName));
        queryBuilder.append((CharSequence)streamSelectBuilder);
        queryOneBuilder.append((CharSequence)streamInitBuilder);
        queryOneBuilder.append("error? unionResult = ").append(String.format("%s from record{} 'object in %s%s", "", "", streamParamName));
        StringBuilder keysArray = new StringBuilder();
        if (entity.getKeys().size() > 1) {
            for (EntityField keyField : entity.getKeys()) {
                if (keysArray.length() > 0) {
                    keysArray.append(", ");
                }
                keysArray.append(String.format("\"%s\"", keyField.getFieldName().replaceAll(" ", "")));
            }
        } else {
            keysArray.append(String.format("\"%s\"", entity.getKeys().get(0).getFieldName().replaceAll(" ", "")));
        }
        queryOneBuilder.append(String.format(BalSyntaxConstants.G_SHEET_WHERE_CLAUSE, keysArray));
        queryOneBuilder.append((CharSequence)streamSelectBuilder);
        if (relationalRecordFields.length() > 0) {
            queryBuilder.append(String.format(BalSyntaxConstants.SELECT_QUERY, "," + System.lineSeparator() + relationalRecordFields.substring(0, relationalRecordFields.length() - 1)));
            queryOneBuilder.append(String.format(BalSyntaxConstants.DO_QUERY, "," + System.lineSeparator() + relationalRecordFields.substring(0, relationalRecordFields.length() - 1)));
        } else {
            queryBuilder.append(String.format(System.lineSeparator() + BalSyntaxConstants.SELECT_QUERY, ""));
            queryBuilder.append(System.lineSeparator());
            queryOneBuilder.append(String.format(System.lineSeparator() + BalSyntaxConstants.DO_QUERY, ""));
        }
        queryBuilder.append("return outputArray.toStream();").append(System.lineSeparator());
        queryOneBuilder.append(BalSyntaxConstants.IF_STATEMENT);
    }
}

