/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.persist.utils;

import io.ballerina.persist.BalException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataBaseValidationUtils {
    private static final String REGEX_DB_NAME_PATTERN = "[^A-Za-z\\d$_]";

    private DataBaseValidationUtils() {
    }

    public static String validateDatabaseInput(String databaseName) throws BalException {
        if (databaseName == null || databaseName.isEmpty() || databaseName.isBlank()) {
            throw new BalException("database name cannot be empty");
        }
        String database = databaseName.trim();
        if (database.length() > 64) {
            throw new BalException("database name should be less than or equal to 64 characters");
        }
        Pattern regex = Pattern.compile(REGEX_DB_NAME_PATTERN);
        Matcher matcher = regex.matcher(database);
        boolean illegalCharExists = matcher.find();
        if (illegalCharExists) {
            throw new BalException("database name contains illegal characters. ");
        }
        return database;
    }
}

