/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.SingleFileGenerator;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.openapi.core.generators.service.ServiceGenerationHandler;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.projects.DiagnosticResult;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentConfig;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageName;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.LinePosition;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.RecordUtil;
import org.ballerinalang.langserver.commons.eventsync.exceptions.EventSyncException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceDocumentException;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.TextEdit;

public class OpenApiServiceGenerator {
    public static final String MAIN_BAL = "main.bal";
    private final WorkspaceManager workspaceManager;
    private final Path oAContractPath;
    private final Path projectPath;
    private final Gson gson;
    public static final List<String> SUPPORTED_OPENAPI_VERSIONS = List.of("2.0", "3.0.0", "3.0.1", "3.0.2", "3.0.3", "3.1.0");
    public static final String LS = System.lineSeparator();
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACE = "}";
    public static final String SPACE = " ";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String BALLERINA_HTTP = "ballerina/http";
    public static final String BALLERINA_LANG = "ballerina/lang";
    public static final String DEFAULT_HTTP_RESPONSE = "DefaultStatusCodeResponse";
    public static final String DEFAULT_HTTP_RESPONSE_VALUE = "status: new (0)";
    public static final String SERVICE_DECLARATION = "service %s on %s {";

    public OpenApiServiceGenerator(Path oAContractPath, Path projectPath, WorkspaceManager workspaceManager) {
        this.oAContractPath = oAContractPath;
        this.projectPath = projectPath;
        this.workspaceManager = workspaceManager;
        this.gson = new Gson();
    }

    public JsonElement generateService(String typeName, List<String> listeners) throws IOException, BallerinaOpenApiException, FormatterException, WorkspaceDocumentException, EventSyncException {
        Filter filter = new Filter(new ArrayList(), new ArrayList());
        OpenAPI openAPIDef = GeneratorUtils.normalizeOpenAPI((Path)this.oAContractPath, (boolean)false, (boolean)false);
        if (openAPIDef.getInfo() == null) {
            throw new BallerinaOpenApiException("Info section of the definition file cannot be empty/null: " + String.valueOf(this.oAContractPath));
        }
        String name = typeName;
        if (name == null || name.isEmpty()) {
            String[] types = openAPIDef.getInfo().getTitle().trim().split(SPACE);
            StringBuilder serviceTypeName = new StringBuilder();
            for (String type : types) {
                serviceTypeName.append(type.substring(0, 1).toUpperCase(Locale.ROOT)).append(type.substring(1));
            }
            name = serviceTypeName.toString();
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        GenSrcFile serviceTypeFile = this.generateServiceType(openAPIDef, name, filter, diagnostics);
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (Diagnostic diagnostic : diagnostics) {
            DiagnosticSeverity severity = diagnostic.diagnosticInfo().severity();
            if (severity != DiagnosticSeverity.ERROR) continue;
            errorMessages.add(diagnostic.message());
        }
        BuildProject sampleProject = PackageUtil.getSampleProject();
        for (Object documentId : sampleProject.currentPackage().getDefaultModule().documentIds()) {
            Document document = sampleProject.currentPackage().getDefaultModule().document((DocumentId)documentId);
            try {
                Document apply = document.modify().withContent(serviceTypeFile.getContent()).apply();
                Package currentPackage = apply.module().packageInstance();
                DiagnosticResult diagnosticResult = PackageUtil.getCompilation((Package)currentPackage).diagnosticResult();
                if (!diagnosticResult.hasErrors()) continue;
                throw new BallerinaOpenApiException("Error occurred while generating the service type: " + String.valueOf(diagnosticResult.diagnostics()));
            }
            catch (Throwable e) {
                throw new BallerinaOpenApiException(e.getMessage());
            }
        }
        if (!errorMessages.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String errorMessage : errorMessages) {
                sb.append(DiagnosticSeverity.ERROR).append(": ").append(errorMessage).append(System.lineSeparator());
            }
            throw new BallerinaOpenApiException(sb.toString());
        }
        Path mainFile = this.projectPath.resolve(MAIN_BAL);
        HashMap<Path, List<TextEdit>> textEditsMap = new HashMap<Path, List<TextEdit>>();
        Project project = this.workspaceManager.loadProject(mainFile);
        Optional document = this.workspaceManager.document(mainFile);
        if (document.isPresent()) {
            String serviceImplContent = this.genServiceImplementation(serviceTypeFile, name, listeners, project, mainFile);
            ModulePartNode modulePartNode = (ModulePartNode)((Document)document.get()).syntaxTree().rootNode();
            LinePosition startPos = LinePosition.from((int)(modulePartNode.lineRange().endLine().line() + 1), (int)0);
            textEditsMap.put(mainFile, List.of(new TextEdit(CommonUtils.toRange((LinePosition)startPos), serviceImplContent)));
        }
        textEditsMap.put(this.projectPath.resolve(serviceTypeFile.getFileName()), List.of(new TextEdit(CommonUtils.toRange((LinePosition)LinePosition.from((int)0, (int)0)), serviceTypeFile.getContent())));
        return this.gson.toJsonTree(textEditsMap);
    }

    public GenSrcFile generateServiceType(OpenAPI openAPIDef, String typeName, Filter filter, List<Diagnostic> diagnostics) throws FormatterException, BallerinaOpenApiException {
        this.checkOpenAPIVersion(openAPIDef);
        List complexPaths = GeneratorUtils.getComplexPaths((OpenAPI)openAPIDef);
        if (!complexPaths.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("service generation can not be done as the openapi definition contain following complex path(s) :").append(System.lineSeparator());
            for (String path : complexPaths) {
                sb.append(path).append(System.lineSeparator());
            }
            throw new BallerinaOpenApiException(sb.toString());
        }
        OASServiceMetadata oasServiceMetadata = new OASServiceMetadata.Builder().withOpenAPI(openAPIDef).withFilters(filter).withNullable(false).withGenerateServiceType(false).withGenerateServiceContract(true).withGenerateWithoutDataBinding(false).withServiceObjectTypeName(typeName).withSrcFile("service_contract_" + typeName + ".bal").build();
        TypeHandler.createInstance((OpenAPI)openAPIDef, (boolean)true);
        ServiceGenerationHandler serviceGenerationHandler = new ServiceGenerationHandler();
        SyntaxTree syntaxTree = serviceGenerationHandler.generateSingleSyntaxTree(oasServiceMetadata);
        if (!oasServiceMetadata.generateWithoutDataBinding()) {
            syntaxTree = SingleFileGenerator.combineSyntaxTrees((SyntaxTree[])new SyntaxTree[]{syntaxTree, TypeHandler.getInstance().generateTypeSyntaxTree()});
        }
        GenSrcFile genSrcFile = new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, oasServiceMetadata.getSrcPackage(), oasServiceMetadata.getSrcFile(), (oasServiceMetadata.getLicenseHeader().isBlank() ? "// AUTO-GENERATED FILE.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n" : oasServiceMetadata.getLicenseHeader()) + Formatter.format((SyntaxTree)syntaxTree).toSourceCode());
        diagnostics.addAll(serviceGenerationHandler.getDiagnostics());
        diagnostics.addAll(TypeHandler.getInstance().getDiagnostics());
        return genSrcFile;
    }

    private String genServiceImplementation(GenSrcFile serviceType, String typeName, List<String> listeners, Project project, Path mainFile) throws BallerinaOpenApiException {
        Package currentPackage = project.currentPackage();
        Module module = currentPackage.module(ModuleName.from((PackageName)currentPackage.packageName()));
        ModuleId moduleId = module.moduleId();
        DocumentId serviceObjDocId = DocumentId.create((String)mainFile.toString(), (ModuleId)moduleId);
        DocumentConfig documentConfig = DocumentConfig.from((DocumentId)serviceObjDocId, (String)serviceType.getContent(), (String)serviceType.getFileName());
        Module apply = module.modify().addDocument(documentConfig).apply();
        SemanticModel semanticModel = PackageUtil.getCompilation((Package)apply.packageInstance()).getSemanticModel(apply.moduleId());
        TypeDefinitionSymbol symbol = this.getServiceTypeSymbol(semanticModel.moduleSymbols(), typeName);
        if (symbol == null) {
            throw new BallerinaOpenApiException("Cannot find service type definition");
        }
        TypeSymbol typeSymbol = symbol.typeDescriptor();
        if (typeSymbol.typeKind() != TypeDescKind.OBJECT) {
            throw new BallerinaOpenApiException("Cannot find service object type definition");
        }
        Map methodSymbolMap = ((ObjectTypeSymbol)typeSymbol).methods();
        StringBuilder serviceImpl = new StringBuilder();
        serviceImpl.append(String.format(SERVICE_DECLARATION, typeName, String.join((CharSequence)", ", listeners)));
        serviceImpl.append(LS);
        for (Map.Entry entry : methodSymbolMap.entrySet()) {
            MethodSymbol methodSymbol = (MethodSymbol)entry.getValue();
            if (!(methodSymbol instanceof ResourceMethodSymbol)) continue;
            ResourceMethodSymbol resourceMethodSymbol = (ResourceMethodSymbol)methodSymbol;
            serviceImpl.append(this.getResourceFunction(resourceMethodSymbol, this.getParentModuleName((Symbol)symbol)));
        }
        serviceImpl.append(CLOSE_BRACE).append(LS);
        return serviceImpl.toString();
    }

    private TypeDefinitionSymbol getServiceTypeSymbol(List<Symbol> symbols, String name) {
        for (Symbol symbol : symbols) {
            Optional typeName;
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION || !(typeName = symbol.getName()).isPresent() || !((String)typeName.get()).equals(name)) continue;
            return (TypeDefinitionSymbol)symbol;
        }
        return null;
    }

    private String getParentModuleName(Symbol symbol) {
        Optional module = symbol.getModule();
        return module.map(moduleSymbol -> moduleSymbol.id().toString()).orElse(null);
    }

    private String getResourceFunction(ResourceMethodSymbol resourceMethodSymbol, String parentModuleName) throws BallerinaOpenApiException {
        String resourceSignature = resourceMethodSymbol.signature();
        if (Objects.nonNull(parentModuleName)) {
            resourceSignature = resourceSignature.replace(parentModuleName + COLON, "");
        }
        if (resourceSignature.contains(BALLERINA_LANG)) {
            resourceSignature = resourceSignature.replace("ballerina/lang.", "");
            resourceSignature = resourceSignature.replaceAll("\\d+\\.\\d+\\.\\d+:", "");
        }
        return this.genResourceFunctionBody(resourceMethodSymbol, resourceSignature);
    }

    private String genResourceFunctionBody(ResourceMethodSymbol resourceMethodSymbol, String resourceSignature) throws BallerinaOpenApiException {
        FunctionTypeSymbol functionTypeSymbol = resourceMethodSymbol.typeDescriptor();
        Optional optReturnTypeSymbol = functionTypeSymbol.returnTypeDescriptor();
        String possibleErrorReturningType = "()";
        if (optReturnTypeSymbol.isPresent()) {
            TypeSymbol typeSymbol = (TypeSymbol)optReturnTypeSymbol.get();
            possibleErrorReturningType = this.getPossibleErrorHttpResponse(typeSymbol);
            if (possibleErrorReturningType.isEmpty()) {
                possibleErrorReturningType = this.getPossibleErrorReturningValue(typeSymbol);
            }
            if (possibleErrorReturningType.isEmpty()) {
                possibleErrorReturningType = this.getDefaultValue(typeSymbol);
            }
            if (possibleErrorReturningType.isEmpty()) {
                throw new BallerinaOpenApiException("Cannot find default return value for: " + resourceMethodSymbol.signature() + "and " + typeSymbol.signature());
            }
        }
        return LS + "\t" + this.sanitizePackageNames(resourceSignature) + " {" + LS + "\t\tdo {" + LS + "\t\t} on fail error e {" + LS + "\t\t\treturn " + possibleErrorReturningType + ";" + LS + "\t\t}" + LS + "\t}" + LS;
    }

    private String getPossibleErrorHttpResponse(TypeSymbol typeSymbol) {
        TypeDescKind kind = typeSymbol.typeKind();
        if (kind == TypeDescKind.UNION) {
            List typeSymbols = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors();
            for (TypeSymbol symbol : typeSymbols) {
                String possibleErrorReturningType = this.getPossibleErrorHttpResponse(symbol);
                if (possibleErrorReturningType.isEmpty()) continue;
                return possibleErrorReturningType;
            }
        } else {
            if (kind == TypeDescKind.TYPE_REFERENCE) {
                return this.getPossibleErrorHttpResponse(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
            }
            if (kind == TypeDescKind.RECORD) {
                String typeStr = typeSymbol.signature();
                if (!typeStr.contains(BALLERINA_HTTP)) {
                    return "";
                }
                if (typeStr.contains("InternalServerError")) {
                    return "http:INTERNAL_SERVER_ERROR";
                }
                if (typeStr.contains("NotFound")) {
                    return "http:NOT_FOUND";
                }
                if (typeStr.contains("MethodNotAllowed")) {
                    return "http:METHOD_NOT_ALLOWED";
                }
                if (typeStr.contains("BadRequest")) {
                    return "http:BAD_REQUEST";
                }
            }
        }
        return "";
    }

    private String getPossibleErrorReturningValue(TypeSymbol typeSymbol) {
        TypeDescKind kind = typeSymbol.typeKind();
        if (kind == TypeDescKind.UNION) {
            List typeSymbols = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors();
            for (TypeSymbol symbol : typeSymbols) {
                String possibleErrorReturningType = this.getPossibleErrorReturningValue(symbol);
                if (possibleErrorReturningType.isEmpty()) continue;
                return possibleErrorReturningType;
            }
            return "";
        }
        if (kind == TypeDescKind.TYPE_REFERENCE) {
            return this.getPossibleErrorReturningValue(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
        }
        if (kind == TypeDescKind.RECORD) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
            List includedTypeSymbols = recordTypeSymbol.typeInclusions();
            for (TypeSymbol includedTypeSymbol : includedTypeSymbols) {
                String signature = includedTypeSymbol.signature();
                if (!signature.contains(BALLERINA_HTTP) || !signature.contains(DEFAULT_HTTP_RESPONSE)) continue;
                return this.getDefaultRecordValue(recordTypeSymbol);
            }
        }
        return "";
    }

    private String getDefaultRecordValue(RecordTypeSymbol recordTypeSymbol) {
        StringBuilder sb = new StringBuilder();
        sb.append(OPEN_BRACE);
        Map fieldDescriptors = recordTypeSymbol.fieldDescriptors();
        for (Map.Entry fieldDescriptor : fieldDescriptors.entrySet()) {
            String key = (String)fieldDescriptor.getKey();
            if (key.contains("status") || key.contains("mediaType") || key.contains("headers")) continue;
            sb.append(key).append(COLON).append(SPACE).append(this.getDefaultValue(((RecordFieldSymbol)fieldDescriptor.getValue()).typeDescriptor())).append(COMMA).append(SPACE);
        }
        sb.append(DEFAULT_HTTP_RESPONSE_VALUE).append(CLOSE_BRACE);
        return sb.toString();
    }

    private String getDefaultValue(TypeSymbol typeSymbol) {
        TypeDescKind kind = typeSymbol.typeKind();
        if (kind == TypeDescKind.UNION) {
            List typeSymbols = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors();
            for (TypeSymbol symbol : typeSymbols) {
                String possibleErrorReturningType = this.getDefaultValue(symbol);
                if (possibleErrorReturningType.isEmpty()) continue;
                return possibleErrorReturningType;
            }
            return "";
        }
        if (kind == TypeDescKind.TYPE_REFERENCE) {
            return this.getDefaultValue(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
        }
        if (kind == TypeDescKind.RECORD) {
            StringBuilder sb = new StringBuilder();
            sb.append(OPEN_BRACE);
            Map fieldDescriptors = ((RecordTypeSymbol)typeSymbol).fieldDescriptors();
            sb.append(RecordUtil.getFillAllRecordFieldInsertText((Map)fieldDescriptors));
            sb.append(CLOSE_BRACE);
            return sb.toString();
        }
        if (kind == TypeDescKind.ANYDATA) {
            return "\"\"";
        }
        return DefaultValueGenerationUtil.getDefaultValueForType((TypeSymbol)typeSymbol).orElse("");
    }

    private String sanitizePackageNames(String input) {
        Pattern pattern = Pattern.compile("(\\w+)/(\\w+:)(\\d+\\.\\d+\\.\\d+):");
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll("$2");
    }

    private void checkOpenAPIVersion(OpenAPI openAPIDef) throws BallerinaOpenApiException {
        if (!SUPPORTED_OPENAPI_VERSIONS.contains(openAPIDef.getOpenapi())) {
            String sb = String.format("WARNING: The tool has not been tested with OpenAPI version %s. The generated code may potentially contain errors.", openAPIDef.getOpenapi()) + System.lineSeparator();
            throw new BallerinaOpenApiException(sb);
        }
    }
}

