/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.converters;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.flowmodelgenerator.core.TypesManager;
import io.ballerina.flowmodelgenerator.core.converters.exception.JsonToRecordConverterException;
import io.ballerina.flowmodelgenerator.core.converters.utils.JsonToRecordMapperConverterUtils;
import io.ballerina.flowmodelgenerator.core.converters.utils.ListOperationUtils;
import io.ballerina.projects.Document;
import io.ballerina.projects.Project;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.formatter.core.options.ForceFormattingOptions;
import org.ballerinalang.formatter.core.options.FormattingOptions;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;

public final class JsonToRecordMapper {
    private static final Gson gson = new Gson();
    private final String recordName;
    private final String prefix;
    private final Project project;
    private final Document document;
    private final Path filePath;
    private final TypesManager typesManager;
    private static final String NEW_RECORD_NAME = "NewRecord";
    private static final String ARRAY_RECORD_SUFFIX = "Item";

    public JsonToRecordMapper(String recordName, String prefix, Project project, Document document, Path filePath, TypesManager typesManager) {
        this.recordName = recordName;
        this.prefix = prefix;
        this.project = project;
        this.document = document;
        this.filePath = filePath;
        this.typesManager = typesManager;
    }

    public JsonElement convert(String jsonString, boolean isRecordTypeDesc, boolean isClosed, boolean forceFormatRecordFields, WorkspaceManager workspaceManager, boolean isNullAsOptional) throws JsonToRecordConverterException, FormatterException {
        NodeList moduleMembers;
        List<String> existingFieldNames = JsonToRecordMapperConverterUtils.getExistingTypeNames(workspaceManager, this.filePath);
        HashMap<String, String> updatedFieldNames = new HashMap<String, String>();
        LinkedHashMap<String, NonTerminalNode> recordToTypeDescNodes = new LinkedHashMap<String, NonTerminalNode>();
        LinkedHashMap<String, JsonElement> jsonFieldToElements = new LinkedHashMap<String, JsonElement>();
        JsonElement parsedJson = JsonParser.parseString((String)jsonString);
        if (parsedJson.isJsonObject()) {
            this.generateRecords(parsedJson.getAsJsonObject(), null, isClosed, recordToTypeDescNodes, null, jsonFieldToElements, existingFieldNames, updatedFieldNames, isNullAsOptional);
        } else if (parsedJson.isJsonArray()) {
            JsonObject object = new JsonObject();
            object.add(this.recordName == null || this.recordName.isEmpty() ? StringUtils.uncapitalize((String)NEW_RECORD_NAME) : StringUtils.uncapitalize((String)this.recordName), parsedJson);
            this.generateRecords(object, null, isClosed, recordToTypeDescNodes, null, jsonFieldToElements, existingFieldNames, updatedFieldNames, isNullAsOptional);
        } else {
            throw new JsonToRecordConverterException("Error occurred while parsing the JSON string");
        }
        NodeList imports = AbstractNodeFactory.createEmptyNodeList();
        HashSet typeNames = new HashSet();
        List<TypeDefinitionNode> typeDefNodes = recordToTypeDescNodes.entrySet().stream().map(entry -> {
            Token typeKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD);
            String recordTypeName = entry.getKey() == null ? (this.recordName == null || this.recordName.isEmpty() ? JsonToRecordMapperConverterUtils.getAndUpdateFieldNames(NEW_RECORD_NAME, false, existingFieldNames, updatedFieldNames) : JsonToRecordMapperConverterUtils.escapeIdentifier(StringUtils.capitalize((String)this.recordName))) : (String)entry.getKey();
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)recordTypeName);
            Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
            typeNames.add(recordTypeName);
            return NodeFactory.createTypeDefinitionNode(null, null, (Token)typeKeyWord, (Token)typeName, (Node)((Node)entry.getValue()), (Token)semicolon);
        }).toList();
        if (isRecordTypeDesc) {
            Optional<TypeDefinitionNode> lastTypeDefNode = JsonToRecordMapper.convertToInlineRecord(typeDefNodes);
            moduleMembers = lastTypeDefNode.map(xva$0 -> AbstractNodeFactory.createNodeList((Node[])new ModuleMemberDeclarationNode[]{xva$0})).orElseGet(AbstractNodeFactory::createEmptyNodeList);
        } else {
            moduleMembers = AbstractNodeFactory.createNodeList(new ArrayList<TypeDefinitionNode>(typeDefNodes));
        }
        IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)moduleMembers, (Token)eofToken);
        ForceFormattingOptions forceFormattingOptions = ForceFormattingOptions.builder().setForceFormatRecordFields(forceFormatRecordFields).build();
        FormattingOptions formattingOptions = FormattingOptions.builder().setForceFormattingOptions(forceFormattingOptions).build();
        String str = Formatter.format((SyntaxTree)modulePartNode.syntaxTree(), (FormattingOptions)formattingOptions).toSourceCode();
        Document newDoc = this.project.duplicate().currentPackage().module(this.document.module().moduleId()).document(this.document.documentId()).modify().withContent(str).apply();
        List moduleSymbols = newDoc.module().getCompilation().getSemanticModel().moduleSymbols();
        ArrayList<TypesManager.TypeDataWithRefs> typeDataList = new ArrayList<TypesManager.TypeDataWithRefs>();
        for (Symbol symbol : moduleSymbols) {
            TypeDefinitionSymbol typeDefSymbol;
            if (symbol.kind() != SymbolKind.TYPE_DEFINITION || !typeNames.contains((typeDefSymbol = (TypeDefinitionSymbol)symbol).getName().orElse(""))) continue;
            typeDataList.add(this.typesManager.getTypeDataWithRefs(typeDefSymbol));
        }
        return gson.toJsonTree(typeDataList);
    }

    private void generateRecords(JsonObject jsonObject, String recordName, boolean isClosed, Map<String, NonTerminalNode> recordToTypeDescNodes, String moveBefore, Map<String, JsonElement> jsonNodes, List<String> existingFieldNames, Map<String, String> updatedFieldNames, boolean isNullAsOptional) throws JsonToRecordConverterException {
        Token recordKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD);
        Token bodyStartDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN);
        ArrayList<Node> recordFields = new ArrayList<Node>();
        if (recordToTypeDescNodes.containsKey(recordName)) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (((JsonElement)entry.getValue()).isJsonObject() || ((JsonElement)entry.getValue()).isJsonArray()) {
                    name = this.getRecordName(this.prefix, (String)entry.getKey());
                    this.generateRecordForObjAndArray((JsonElement)entry.getValue(), name, isClosed, recordToTypeDescNodes, recordName, jsonNodes, existingFieldNames, updatedFieldNames, false, isNullAsOptional);
                }
                jsonNodes.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            this.prepareAndUpdateRecordFields(jsonObject, recordName, jsonNodes, recordToTypeDescNodes, recordFields, existingFieldNames, updatedFieldNames, false, isNullAsOptional);
        } else {
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (((JsonElement)entry.getValue()).isJsonObject() || ((JsonElement)entry.getValue()).isJsonArray()) {
                    name = this.getRecordName(this.prefix, (String)entry.getKey());
                    this.generateRecordForObjAndArray((JsonElement)entry.getValue(), name, isClosed, recordToTypeDescNodes, null, jsonNodes, existingFieldNames, updatedFieldNames, false, isNullAsOptional);
                }
                jsonNodes.put((String)entry.getKey(), (JsonElement)entry.getValue());
                Node recordField = this.getRecordField(entry, existingFieldNames, updatedFieldNames, false);
                recordFields.add(recordField);
            }
            if (recordToTypeDescNodes.containsKey(recordName)) {
                recordFields.clear();
                this.prepareAndUpdateRecordFields(jsonObject, recordName, jsonNodes, recordToTypeDescNodes, recordFields, existingFieldNames, updatedFieldNames, true, isNullAsOptional);
            }
        }
        NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFields);
        Token bodyEndDelimiter = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN);
        RecordRestDescriptorNode restDescriptorNode = isClosed ? null : NodeFactory.createRecordRestDescriptorNode((Node)NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)SyntaxKind.JSON_KEYWORD, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ELLIPSIS_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)recordKeyWord, (Token)bodyStartDelimiter, (NodeList)fieldNodes, restDescriptorNode, (Token)bodyEndDelimiter);
        if (moveBefore == null || moveBefore.equals(recordName)) {
            recordToTypeDescNodes.put(recordName, (NonTerminalNode)recordTypeDescriptorNode);
        } else {
            ArrayList<Map.Entry<String, NonTerminalNode>> typeDescNodes = new ArrayList<Map.Entry<String, NonTerminalNode>>(recordToTypeDescNodes.entrySet());
            List<String> recordNames = typeDescNodes.stream().map(Map.Entry::getKey).toList();
            typeDescNodes.add(recordNames.indexOf(moveBefore), Map.entry(recordName, recordTypeDescriptorNode));
            recordToTypeDescNodes.clear();
            typeDescNodes.forEach(node -> recordToTypeDescNodes.put((String)node.getKey(), (NonTerminalNode)node.getValue()));
        }
    }

    private void generateRecordForObjAndArray(JsonElement jsonElement, String elementKey, boolean isClosed, Map<String, NonTerminalNode> recordToTypeDescNodes, String moveBefore, Map<String, JsonElement> jsonNodes, List<String> existingFieldNames, Map<String, String> updatedFieldNames, boolean arraySuffixAdded, boolean isNullAsOptional) throws JsonToRecordConverterException {
        if (jsonElement.isJsonObject()) {
            String type = JsonToRecordMapperConverterUtils.escapeIdentifier(StringUtils.capitalize((String)elementKey));
            String updatedType = JsonToRecordMapperConverterUtils.getAndUpdateFieldNames(type, arraySuffixAdded, existingFieldNames, updatedFieldNames);
            this.generateRecords(jsonElement.getAsJsonObject(), updatedType, isClosed, recordToTypeDescNodes, moveBefore, jsonNodes, existingFieldNames, updatedFieldNames, isNullAsOptional);
        } else if (jsonElement.isJsonArray()) {
            for (JsonElement element : jsonElement.getAsJsonArray()) {
                String arrayElementKey = elementKey + (arraySuffixAdded ? "" : ARRAY_RECORD_SUFFIX);
                this.generateRecordForObjAndArray(element, arrayElementKey, isClosed, recordToTypeDescNodes, moveBefore, jsonNodes, existingFieldNames, updatedFieldNames, true, isNullAsOptional);
            }
        }
    }

    private void prepareAndUpdateRecordFields(JsonObject jsonObject, String recordName, Map<String, JsonElement> jsonNodes, Map<String, NonTerminalNode> recordToTypeDescNodes, List<Node> recordFields, List<String> existingFieldNames, Map<String, String> updatedFieldNames, boolean prepareForNestedSameField, boolean isNullAsOptional) throws JsonToRecordConverterException {
        RecordTypeDescriptorNode previousRecordTypeDescriptorNode = (RecordTypeDescriptorNode)recordToTypeDescNodes.get(recordName);
        List<RecordFieldNode> previousRecordFields = previousRecordTypeDescriptorNode.fields().stream().map(node -> (RecordFieldNode)node).toList();
        Map previousRecordFieldToNodes = previousRecordFields.stream().collect(Collectors.toMap(node -> node.fieldName().text(), Function.identity(), (val1, val2) -> val1, LinkedHashMap::new));
        Map newRecordFieldToNodes = jsonObject.entrySet().stream().map(entry -> (RecordFieldNode)this.getRecordField((Map.Entry<String, JsonElement>)entry, existingFieldNames, updatedFieldNames, false)).toList().stream().collect(Collectors.toMap(node -> node.fieldName().text(), Function.identity(), (val1, val2) -> val1, LinkedHashMap::new));
        if (prepareForNestedSameField) {
            this.updateRecordFields(jsonObject, jsonNodes, recordFields, existingFieldNames, updatedFieldNames, newRecordFieldToNodes, previousRecordFieldToNodes, isNullAsOptional);
        } else {
            this.updateRecordFields(jsonObject, jsonNodes, recordFields, existingFieldNames, updatedFieldNames, previousRecordFieldToNodes, newRecordFieldToNodes, isNullAsOptional);
        }
    }

    private void updateRecordFields(JsonObject jsonObject, Map<String, JsonElement> jsonNodes, List<Node> recordFields, List<String> existingFieldNames, Map<String, String> updatedFieldNames, Map<String, RecordFieldNode> previousRecordFieldToNodes, Map<String, RecordFieldNode> newRecordFieldToNodes, boolean isNullAsOptional) throws JsonToRecordConverterException {
        Map<String, String> jsonEscapedFieldToFields;
        Map<String, Map.Entry<RecordFieldNode, RecordFieldNode>> intersectingRecordFields = ListOperationUtils.intersection(previousRecordFieldToNodes, newRecordFieldToNodes);
        Map<String, RecordFieldNode> differencingRecordFields = ListOperationUtils.difference(previousRecordFieldToNodes, newRecordFieldToNodes);
        for (Map.Entry<String, Map.Entry<RecordFieldNode, RecordFieldNode>> entry : intersectingRecordFields.entrySet()) {
            boolean isOptional = entry.getValue().getKey().questionMarkToken().isPresent();
            jsonEscapedFieldToFields = jsonNodes.entrySet().stream().collect(Collectors.toMap(jsonEntry -> JsonToRecordMapperConverterUtils.escapeIdentifier((String)jsonEntry.getKey()), Map.Entry::getKey));
            AbstractMap.SimpleEntry<String, JsonElement> jsonEntry2 = new AbstractMap.SimpleEntry<String, JsonElement>(jsonEscapedFieldToFields.get(entry.getKey()), jsonNodes.get(jsonEscapedFieldToFields.get(entry.getKey())));
            if (!entry.getValue().getKey().typeName().toSourceCode().equals(entry.getValue().getValue().typeName().toSourceCode())) {
                TypeDescriptorNode node1 = (TypeDescriptorNode)entry.getValue().getKey().typeName();
                TypeDescriptorNode node2 = (TypeDescriptorNode)entry.getValue().getValue().typeName();
                TypeDescriptorNode nonJsonDataNode = null;
                IdentifierToken optionalFieldName = null;
                boolean alreadyOptionalTypeDesc = false;
                if (node1.kind().equals((Object)SyntaxKind.OPTIONAL_TYPE_DESC)) {
                    optionalTypeDescNode = (OptionalTypeDescriptorNode)node1;
                    node1 = (TypeDescriptorNode)optionalTypeDescNode.typeDescriptor();
                    alreadyOptionalTypeDesc = true;
                } else if (node2.kind().equals((Object)SyntaxKind.OPTIONAL_TYPE_DESC)) {
                    optionalTypeDescNode = (OptionalTypeDescriptorNode)node2;
                    node2 = (TypeDescriptorNode)optionalTypeDescNode.typeDescriptor();
                    alreadyOptionalTypeDesc = true;
                } else if (node1.kind().equals((Object)SyntaxKind.JSON_KEYWORD) || node2.kind().equals((Object)SyntaxKind.JSON_KEYWORD)) {
                    if (isNullAsOptional) {
                        nonJsonDataNode = NodeParser.parseTypeDescriptor((String)(node1.kind().equals((Object)SyntaxKind.JSON_KEYWORD) ? node2.toSourceCode() : node1.toSourceCode()));
                        optionalFieldName = AbstractNodeFactory.createIdentifierToken((String)(entry.getKey() + SyntaxKind.QUESTION_MARK_TOKEN.stringValue()));
                    } else {
                        nonJsonDataNode = NodeParser.parseTypeDescriptor((String)(node1.kind().equals((Object)SyntaxKind.JSON_KEYWORD) ? node2.toSourceCode() + SyntaxKind.QUESTION_MARK_TOKEN.stringValue() : node1.toSourceCode() + SyntaxKind.QUESTION_MARK_TOKEN.stringValue()));
                    }
                }
                List<TypeDescriptorNode> typeDescNodesSorted = JsonToRecordMapperConverterUtils.sortTypeDescriptorNodes(JsonToRecordMapperConverterUtils.extractTypeDescriptorNodes(List.of(node1, node2)));
                TypeDescriptorNode unionTypeDescNode = JsonToRecordMapper.createUnionTypeDescriptorNode(typeDescNodesSorted, alreadyOptionalTypeDesc);
                RecordFieldNode recordField = (RecordFieldNode)this.getRecordField(jsonEntry2, existingFieldNames, updatedFieldNames, isOptional);
                recordField = recordField.modify().withTypeName((Node)(nonJsonDataNode == null ? unionTypeDescNode : nonJsonDataNode)).withFieldName((Token)(optionalFieldName == null ? recordField.fieldName() : optionalFieldName)).apply();
                recordFields.add((Node)recordField);
                continue;
            }
            Node recordField = this.getRecordField(jsonEntry2, existingFieldNames, updatedFieldNames, isOptional);
            recordFields.add(recordField);
        }
        for (Map.Entry<String, Map.Entry<RecordFieldNode, RecordFieldNode>> entry : differencingRecordFields.entrySet()) {
            AbstractMap.SimpleEntry<String, JsonElement> jsonEntry3;
            String jsonField = entry.getKey();
            jsonEscapedFieldToFields = jsonNodes.entrySet().stream().collect(Collectors.toMap(jsonEntry -> JsonToRecordMapperConverterUtils.escapeIdentifier((String)jsonEntry.getKey()), Map.Entry::getKey));
            JsonElement jsonElement = jsonNodes.get(jsonEscapedFieldToFields.get(jsonField));
            Map.Entry<String, Object> entry2 = jsonEntry3 = jsonElement != null ? new AbstractMap.SimpleEntry<String, JsonElement>(jsonEscapedFieldToFields.get(jsonField), jsonElement) : (Map.Entry)jsonObject.entrySet().stream().filter(elementEntry -> JsonToRecordMapperConverterUtils.escapeIdentifier((String)elementEntry.getKey()).equals(jsonField)).findFirst().orElse(null);
            if (jsonEntry3 != null) {
                Node recordField = this.getRecordField(jsonEntry3, existingFieldNames, updatedFieldNames, true);
                recordFields.add(recordField);
                continue;
            }
            throw new JsonToRecordConverterException("Error occurred while updating the record fields");
        }
    }

    private Node getRecordField(Map.Entry<String, JsonElement> entry, List<String> existingFieldNames, Map<String, String> updatedFieldNames, boolean isOptionalField) {
        Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
        Token questionMarkToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        BuiltinSimpleNameReferenceNode fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)JsonToRecordMapperConverterUtils.escapeIdentifier(entry.getKey().trim()));
        Token optionalFieldToken = isOptionalField ? questionMarkToken : null;
        Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        if (entry.getValue().isJsonPrimitive()) {
            typeName = JsonToRecordMapperConverterUtils.getPrimitiveTypeName(entry.getValue().getAsJsonPrimitive());
            fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
            recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        } else if (entry.getValue().isJsonObject()) {
            String type = JsonToRecordMapperConverterUtils.escapeIdentifier(this.getRecordName(this.prefix, entry.getKey().trim()));
            String updatedType = JsonToRecordMapperConverterUtils.getAndUpdateFieldNames(type, false, existingFieldNames, updatedFieldNames);
            typeName = AbstractNodeFactory.createIdentifierToken((String)updatedType);
            fieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
            recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)fieldTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        } else if (entry.getValue().isJsonArray()) {
            Map.Entry<String, JsonArray> jsonArrayEntry = Map.entry(this.getRecordName(this.prefix, entry.getKey()), entry.getValue().getAsJsonArray());
            ArrayTypeDescriptorNode arrayTypeName = JsonToRecordMapper.getArrayTypeDescriptorNode(jsonArrayEntry, existingFieldNames, updatedFieldNames);
            recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)arrayTypeName, (Token)fieldName, (Token)optionalFieldToken, (Token)semicolonToken);
        }
        return recordFieldNode;
    }

    private static Optional<TypeDefinitionNode> convertToInlineRecord(List<TypeDefinitionNode> typeDefNodes) {
        LinkedHashMap<String, RecordTypeDescriptorNode> visitedRecordTypeDescNodeTypeToNodes = new LinkedHashMap<String, RecordTypeDescriptorNode>();
        for (TypeDefinitionNode typeDefNode : typeDefNodes) {
            RecordTypeDescriptorNode recordTypeDescNode = (RecordTypeDescriptorNode)typeDefNode.typeDescriptor();
            List<RecordFieldNode> recordFieldNodes = recordTypeDescNode.fields().stream().map(node -> (RecordFieldNode)node).toList();
            ArrayList<RecordFieldNode> intermediateRecordFieldNodes = new ArrayList<RecordFieldNode>();
            for (RecordFieldNode recordFieldNode : recordFieldNodes) {
                TypeDescriptorNode fieldTypeName = (TypeDescriptorNode)recordFieldNode.typeName();
                TypeDescriptorNode converted = JsonToRecordMapper.convertUnionTypeToInline(fieldTypeName, visitedRecordTypeDescNodeTypeToNodes);
                if (converted == null) {
                    return Optional.empty();
                }
                Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
                RecordFieldNode updatedRecordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)converted, (Token)recordFieldNode.fieldName(), (Token)recordFieldNode.questionMarkToken().orElse(null), (Token)semicolonToken);
                intermediateRecordFieldNodes.add(updatedRecordFieldNode);
            }
            NodeList updatedRecordFieldNodes = AbstractNodeFactory.createNodeList(intermediateRecordFieldNodes);
            RecordTypeDescriptorNode updatedRecordTypeDescNode = recordTypeDescNode.modify().withFields(updatedRecordFieldNodes).apply();
            visitedRecordTypeDescNodeTypeToNodes.put(typeDefNode.typeName().toSourceCode(), updatedRecordTypeDescNode);
        }
        ArrayList visitedRecordTypeDescNodes = new ArrayList(visitedRecordTypeDescNodeTypeToNodes.entrySet());
        Map.Entry lastRecordTypeDescNode = (Map.Entry)visitedRecordTypeDescNodes.get(visitedRecordTypeDescNodes.size() - 1);
        Token typeKeyWord = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD);
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)JsonToRecordMapperConverterUtils.escapeIdentifier((String)lastRecordTypeDescNode.getKey()));
        Token semicolon = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return Optional.of(NodeFactory.createTypeDefinitionNode(null, null, (Token)typeKeyWord, (Token)typeName, (Node)((Node)lastRecordTypeDescNode.getValue()), (Token)semicolon));
    }

    private static ArrayTypeDescriptorNode getArrayTypeDescriptorNode(Map.Entry<String, JsonArray> entry, List<String> existingFieldNames, Map<String, String> updatedFieldNames) {
        Token openSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN);
        Token closeSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN);
        Iterator iterator = entry.getValue().iterator();
        ArrayList<TypeDescriptorNode> typeDescriptorNodes = new ArrayList<TypeDescriptorNode>();
        while (iterator.hasNext()) {
            BuiltinSimpleNameReferenceNode tempTypeNode;
            Token tempTypeName;
            JsonElement element = (JsonElement)iterator.next();
            if (element.isJsonPrimitive()) {
                tempTypeName = JsonToRecordMapperConverterUtils.getPrimitiveTypeName(element.getAsJsonPrimitive());
                tempTypeNode = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)tempTypeName.kind(), (Token)tempTypeName);
                if (typeDescriptorNodes.stream().map(Node::toSourceCode).toList().contains(tempTypeNode.toSourceCode())) continue;
                typeDescriptorNodes.add((TypeDescriptorNode)tempTypeNode);
                continue;
            }
            if (element.isJsonNull()) {
                tempTypeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
                tempTypeNode = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)tempTypeName.kind(), (Token)tempTypeName);
                if (typeDescriptorNodes.stream().map(Node::toSourceCode).toList().contains(tempTypeNode.toSourceCode())) continue;
                typeDescriptorNodes.add((TypeDescriptorNode)tempTypeNode);
                continue;
            }
            if (element.isJsonObject()) {
                String elementKey = entry.getKey();
                String type = JsonToRecordMapperConverterUtils.escapeIdentifier(StringUtils.capitalize((String)elementKey) + ARRAY_RECORD_SUFFIX);
                String updatedType = JsonToRecordMapperConverterUtils.getAndUpdateFieldNames(type, true, existingFieldNames, updatedFieldNames);
                IdentifierToken tempTypeName2 = AbstractNodeFactory.createIdentifierToken((String)updatedType);
                BuiltinSimpleNameReferenceNode tempTypeNode2 = NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)tempTypeName2.kind(), (Token)tempTypeName2);
                if (typeDescriptorNodes.stream().map(Node::toSourceCode).toList().contains(tempTypeNode2.toSourceCode())) continue;
                typeDescriptorNodes.add((TypeDescriptorNode)tempTypeNode2);
                continue;
            }
            if (!element.isJsonArray()) continue;
            AbstractMap.SimpleEntry<String, JsonArray> arrayEntry = new AbstractMap.SimpleEntry<String, JsonArray>(entry.getKey(), element.getAsJsonArray());
            tempTypeNode = JsonToRecordMapper.getArrayTypeDescriptorNode(arrayEntry, existingFieldNames, updatedFieldNames);
            if (typeDescriptorNodes.stream().map(Node::toSourceCode).toList().contains(tempTypeNode.toSourceCode())) continue;
            typeDescriptorNodes.add((TypeDescriptorNode)tempTypeNode);
        }
        List<TypeDescriptorNode> typeDescriptorNodesSorted = JsonToRecordMapperConverterUtils.sortTypeDescriptorNodes(typeDescriptorNodes);
        TypeDescriptorNode fieldTypeName = JsonToRecordMapper.createUnionTypeDescriptorNode(typeDescriptorNodesSorted, false);
        NodeList arrayDimensions = NodeFactory.createEmptyNodeList();
        ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)openSBracketToken, null, (Token)closeSBracketToken);
        arrayDimensions = arrayDimensions.add((Node)arrayDimension);
        return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)fieldTypeName, (NodeList)arrayDimensions);
    }

    private static TypeDescriptorNode createUnionTypeDescriptorNode(List<TypeDescriptorNode> typeNames, boolean isOptional) {
        if (typeNames.isEmpty()) {
            Token typeName = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD);
            return NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)typeName.kind(), (Token)typeName);
        }
        if (typeNames.size() == 1) {
            return typeNames.get(0);
        }
        TypeDescriptorNode unionTypeDescNode = JsonToRecordMapper.joinToUnionTypeDescriptorNode(typeNames);
        Token openParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
        Token closeParenToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        Token questionMarkToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        ParenthesisedTypeDescriptorNode parenTypeDescNode = NodeFactory.createParenthesisedTypeDescriptorNode((Token)openParenToken, (TypeDescriptorNode)unionTypeDescNode, (Token)closeParenToken);
        return isOptional ? NodeFactory.createOptionalTypeDescriptorNode((Node)parenTypeDescNode, (Token)questionMarkToken) : parenTypeDescNode;
    }

    private static TypeDescriptorNode joinToUnionTypeDescriptorNode(List<TypeDescriptorNode> typeNames) {
        Token pipeToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN);
        TypeDescriptorNode unionTypeDescNode = typeNames.get(0);
        for (int i = 1; i < typeNames.size(); ++i) {
            unionTypeDescNode = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)unionTypeDescNode, (Token)pipeToken, (TypeDescriptorNode)typeNames.get(i));
        }
        return unionTypeDescNode;
    }

    private static TypeDescriptorNode convertUnionTypeToInline(TypeDescriptorNode typeDescNode, Map<String, RecordTypeDescriptorNode> visitedRecordTypeDescNodeTypeToNodes) {
        List<TypeDescriptorNode> extractedTypeDescNodes = JsonToRecordMapperConverterUtils.extractUnionTypeDescNode(JsonToRecordMapperConverterUtils.extractArrayTypeDescNode(typeDescNode));
        ArrayList<TypeDescriptorNode> updatedTypeDescNodes = new ArrayList<TypeDescriptorNode>();
        if (extractedTypeDescNodes.size() == 1) {
            Object arrayExtractedNode = JsonToRecordMapperConverterUtils.extractArrayTypeDescNode(typeDescNode);
            String fieldTypeNameText = arrayExtractedNode.toSourceCode();
            SyntaxKind fieldKind = arrayExtractedNode.kind();
            if (JsonToRecordMapperConverterUtils.extractArrayTypeDescNode(typeDescNode).kind().equals((Object)SyntaxKind.SIMPLE_NAME_REFERENCE)) {
                SimpleNameReferenceNode fieldNameRefNode = (SimpleNameReferenceNode)JsonToRecordMapperConverterUtils.extractArrayTypeDescNode(typeDescNode);
                fieldTypeNameText = fieldNameRefNode.name().toSourceCode();
                fieldKind = fieldNameRefNode.name().kind();
            }
            if (fieldKind.equals((Object)SyntaxKind.IDENTIFIER_TOKEN) && (arrayExtractedNode = (TypeDescriptorNode)visitedRecordTypeDescNodeTypeToNodes.get(fieldTypeNameText)) == null) {
                return null;
            }
            updatedTypeDescNodes.add((TypeDescriptorNode)arrayExtractedNode);
        } else {
            for (TypeDescriptorNode extractedTypeDescNode : extractedTypeDescNodes) {
                TypeDescriptorNode updatedTypeDescNode = JsonToRecordMapper.convertUnionTypeToInline(extractedTypeDescNode, visitedRecordTypeDescNodeTypeToNodes);
                updatedTypeDescNodes.add(updatedTypeDescNode);
            }
        }
        List<TypeDescriptorNode> typeDescNodesSorted = JsonToRecordMapperConverterUtils.sortTypeDescriptorNodes(updatedTypeDescNodes);
        TypeDescriptorNode unionTypeDescNode = JsonToRecordMapper.createUnionTypeDescriptorNode(typeDescNodesSorted, false);
        if (typeDescNode.kind().equals((Object)SyntaxKind.ARRAY_TYPE_DESC)) {
            Token openSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN);
            Token closeSBracketToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN);
            NodeList arrayDimensions = NodeFactory.createEmptyNodeList();
            ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)openSBracketToken, null, (Token)closeSBracketToken);
            int numberOfDimensions = JsonToRecordMapperConverterUtils.getNumberOfDimensions((ArrayTypeDescriptorNode)typeDescNode);
            for (int i = 0; i < numberOfDimensions; ++i) {
                arrayDimensions = arrayDimensions.add((Node)arrayDimension);
            }
            unionTypeDescNode = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)unionTypeDescNode, (NodeList)arrayDimensions);
        }
        return unionTypeDescNode;
    }

    private String getRecordName(String prefix, String name) {
        String cap = StringUtils.capitalize((String)name);
        return prefix == null || prefix.isEmpty() ? cap : StringUtils.capitalize((String)prefix) + cap;
    }
}

