/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.converters.utils;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesisedTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxInfo;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.flowmodelgenerator.core.converters.utils.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class XMLToRecordConverterUtils {
    private static final String QUOTED_IDENTIFIER_PREFIX = "'";
    private static final String ESCAPE_NUMERIC_PATTERN = "\\b\\d.*";
    private static final List<String> KEYWORDS = SyntaxInfo.keywords();

    private XMLToRecordConverterUtils() {
    }

    public static String escapeIdentifier(String identifier) {
        if (KEYWORDS.stream().anyMatch(((String)identifier)::equals)) {
            return QUOTED_IDENTIFIER_PREFIX + (String)identifier;
        }
        if (((String)identifier).startsWith(QUOTED_IDENTIFIER_PREFIX)) {
            identifier = ((String)identifier).substring(1);
        }
        identifier = Utils.unescapeUnicodeCodepoints((String)identifier);
        if (((String)(identifier = Utils.escapeSpecialCharacters((String)identifier))).matches(ESCAPE_NUMERIC_PATTERN)) {
            identifier = "\\" + (String)identifier;
        }
        return identifier;
    }

    public static Token getPrimitiveTypeName(String value) {
        if (XMLToRecordConverterUtils.isBoolean(value)) {
            return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BOOLEAN_KEYWORD);
        }
        if (XMLToRecordConverterUtils.isInteger(value)) {
            return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.INT_KEYWORD);
        }
        if (XMLToRecordConverterUtils.isDouble(value)) {
            return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DECIMAL_KEYWORD);
        }
        return AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD);
    }

    public static List<TypeDescriptorNode> extractTypeDescriptorNodes(List<TypeDescriptorNode> typeDescNodes) {
        ArrayList<TypeDescriptorNode> extractedTypeNames = new ArrayList<TypeDescriptorNode>();
        for (TypeDescriptorNode typeDescNode : typeDescNodes) {
            TypeDescriptorNode extractedTypeDescNode = XMLToRecordConverterUtils.extractParenthesisedTypeDescNode(typeDescNode);
            if (extractedTypeDescNode instanceof UnionTypeDescriptorNode) {
                UnionTypeDescriptorNode unionTypeDescriptorNode = (UnionTypeDescriptorNode)extractedTypeDescNode;
                List<TypeDescriptorNode> childTypeDescNodes = List.of(unionTypeDescriptorNode.leftTypeDesc(), unionTypeDescriptorNode.rightTypeDesc());
                XMLToRecordConverterUtils.addIfNotExist(extractedTypeNames, XMLToRecordConverterUtils.extractTypeDescriptorNodes(childTypeDescNodes));
                continue;
            }
            XMLToRecordConverterUtils.addIfNotExist(extractedTypeNames, List.of(extractedTypeDescNode));
        }
        return extractedTypeNames;
    }

    public static List<TypeDescriptorNode> sortTypeDescriptorNodes(List<TypeDescriptorNode> typeDescriptorNodes) {
        List nonArrayNodes = typeDescriptorNodes.stream().filter(node -> !(node instanceof ArrayTypeDescriptorNode)).collect(Collectors.toList());
        List arrayNodes = typeDescriptorNodes.stream().filter(node -> node instanceof ArrayTypeDescriptorNode).collect(Collectors.toList());
        List<TypeDescriptorNode> membersOfArrayNodes = arrayNodes.stream().map(node -> XMLToRecordConverterUtils.extractArrayTypeDescNode((ArrayTypeDescriptorNode)node)).toList();
        nonArrayNodes.removeIf(node -> membersOfArrayNodes.stream().map(Node::toSourceCode).toList().contains(node.toSourceCode()));
        nonArrayNodes.sort(Comparator.comparing(Node::toSourceCode));
        arrayNodes.sort((node1, node2) -> {
            ArrayTypeDescriptorNode arrayNode1 = (ArrayTypeDescriptorNode)node1;
            ArrayTypeDescriptorNode arrayNode2 = (ArrayTypeDescriptorNode)node2;
            return XMLToRecordConverterUtils.getNumberOfDimensions(arrayNode1).equals(XMLToRecordConverterUtils.getNumberOfDimensions(arrayNode2)) ? arrayNode1.memberTypeDesc().toSourceCode().compareTo(arrayNode2.memberTypeDesc().toSourceCode()) : XMLToRecordConverterUtils.getNumberOfDimensions(arrayNode1) - XMLToRecordConverterUtils.getNumberOfDimensions(arrayNode2);
        });
        return Stream.concat(nonArrayNodes.stream(), arrayNodes.stream()).toList();
    }

    public static List<TypeDescriptorNode> extractUnionTypeDescNode(TypeDescriptorNode typeDescNode) {
        ArrayList<TypeDescriptorNode> extractedTypeDescNodes = new ArrayList<TypeDescriptorNode>();
        TypeDescriptorNode extractedTypeDescNode = typeDescNode;
        if (typeDescNode.kind().equals((Object)SyntaxKind.PARENTHESISED_TYPE_DESC)) {
            extractedTypeDescNode = XMLToRecordConverterUtils.extractParenthesisedTypeDescNode(typeDescNode);
        }
        if (extractedTypeDescNode.kind().equals((Object)SyntaxKind.UNION_TYPE_DESC)) {
            UnionTypeDescriptorNode unionTypeDescNode = (UnionTypeDescriptorNode)extractedTypeDescNode;
            TypeDescriptorNode leftTypeDescNode = unionTypeDescNode.leftTypeDesc();
            TypeDescriptorNode rightTypeDescNode = unionTypeDescNode.rightTypeDesc();
            extractedTypeDescNodes.addAll(XMLToRecordConverterUtils.extractUnionTypeDescNode(leftTypeDescNode));
            extractedTypeDescNodes.addAll(XMLToRecordConverterUtils.extractUnionTypeDescNode(rightTypeDescNode));
        } else {
            extractedTypeDescNodes.add(extractedTypeDescNode);
        }
        return extractedTypeDescNodes;
    }

    public static Integer getNumberOfDimensions(ArrayTypeDescriptorNode arrayNode) {
        int totalDimensions = arrayNode.dimensions().size();
        TypeDescriptorNode typeDescriptorNode = arrayNode.memberTypeDesc();
        if (typeDescriptorNode instanceof ArrayTypeDescriptorNode) {
            ArrayTypeDescriptorNode arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)typeDescriptorNode;
            totalDimensions += XMLToRecordConverterUtils.getNumberOfDimensions(arrayTypeDescriptorNode).intValue();
        }
        return totalDimensions;
    }

    private static TypeDescriptorNode extractArrayTypeDescNode(ArrayTypeDescriptorNode arrayTypeDescNode) {
        TypeDescriptorNode typeDescriptorNode = arrayTypeDescNode.memberTypeDesc();
        if (typeDescriptorNode instanceof ArrayTypeDescriptorNode) {
            ArrayTypeDescriptorNode arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)typeDescriptorNode;
            return XMLToRecordConverterUtils.extractArrayTypeDescNode(arrayTypeDescriptorNode);
        }
        return arrayTypeDescNode.memberTypeDesc();
    }

    private static TypeDescriptorNode extractParenthesisedTypeDescNode(TypeDescriptorNode typeDescNode) {
        if (typeDescNode instanceof ParenthesisedTypeDescriptorNode) {
            ParenthesisedTypeDescriptorNode parenthesisedTypeDescriptorNode = (ParenthesisedTypeDescriptorNode)typeDescNode;
            return XMLToRecordConverterUtils.extractParenthesisedTypeDescNode(parenthesisedTypeDescriptorNode.typedesc());
        }
        return typeDescNode;
    }

    private static void addIfNotExist(List<TypeDescriptorNode> typeDescNodes, List<TypeDescriptorNode> typeDescNodesToBeInserted) {
        for (TypeDescriptorNode typeDescNodeToBeInserted : typeDescNodesToBeInserted) {
            if (!typeDescNodes.stream().noneMatch(typeDescNode -> typeDescNode.toSourceCode().equals(typeDescNodeToBeInserted.toSourceCode()))) continue;
            typeDescNodes.add(typeDescNodeToBeInserted);
        }
    }

    private static boolean isBoolean(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
    }

    private static boolean isInteger(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isDouble(String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

