/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor.services;

import io.ballerina.flowmodelgenerator.core.expressioneditor.ExpressionEditorContext;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DebouncedExpressionEditorRequest;
import io.ballerina.flowmodelgenerator.core.model.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionContext;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;

public class CompletionRequest
extends DebouncedExpressionEditorRequest<Either<List<CompletionItem>, CompletionList>> {
    private final CompletionContext completionContext;
    private final TextDocumentService textDocumentService;
    private static final String RESERVED_VARIABLE_NAME = "__reserved__";

    public CompletionRequest(ExpressionEditorContext context, CompletionContext completionContext, TextDocumentService textDocumentService) {
        super(context);
        this.completionContext = completionContext;
        this.textDocumentService = textDocumentService;
    }

    @Override
    public Either<List<CompletionItem>, CompletionList> getResponse(ExpressionEditorContext context) {
        context.generateStatement();
        Position position = context.getCursorPosition();
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(context.fileUri());
        CompletionParams params = new CompletionParams(identifier, position, this.completionContext);
        CompletableFuture completableFuture = this.textDocumentService.completion(params);
        Either completions = (Either)completableFuture.join();
        String valueType = context.getProperty().valueType();
        if (Property.ValueType.LV_EXPRESSION.name().equals(valueType)) {
            List<Object> completionsList = completions.getLeft() != null ? (ArrayList<CompletionItem>)completions.getLeft() : (completions.getRight() != null && ((CompletionList)completions.getRight()).getItems() != null ? ((CompletionList)completions.getRight()).getItems() : new ArrayList<CompletionItem>());
            completionsList.removeIf(item -> !item.getKind().equals((Object)CompletionItemKind.Variable) && !item.getKind().equals((Object)CompletionItemKind.Field));
        }
        if (completions.getLeft() != null) {
            ((List)completions.getLeft()).removeIf(item -> RESERVED_VARIABLE_NAME.equals(item.getLabel()));
        } else if (completions.getRight() != null && ((CompletionList)completions.getRight()).getItems() != null) {
            ((CompletionList)completions.getRight()).getItems().removeIf(item -> RESERVED_VARIABLE_NAME.equals(item.getLabel()));
        }
        return completions;
    }

    @Override
    public String getKey() {
        return "completions";
    }

    @Override
    public long getDelay() {
        return 150L;
    }
}

