/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor.services;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.flowmodelgenerator.core.expressioneditor.ExpressionEditorContext;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.ActionOrExpressionDiagnosticsRequest;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DebouncedExpressionEditorRequest;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.ExpressionDiagnosticsRequest;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.IdentifierDiagnosticsRequest;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.LvExpressionDiagnosticRequest;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.TypeDiagnosticRequest;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.modelgenerator.commons.CommonUtils;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.lsp4j.Diagnostic;

public abstract class DiagnosticsRequest
extends DebouncedExpressionEditorRequest<Diagnostics> {
    public DiagnosticsRequest(ExpressionEditorContext context) {
        super(context);
    }

    public static DiagnosticsRequest from(ExpressionEditorContext context) {
        ExpressionEditorContext.Property property = context.getProperty();
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        return switch (Property.ValueType.valueOf(property.valueType())) {
            case Property.ValueType.EXPRESSION -> new ExpressionDiagnosticsRequest(context);
            case Property.ValueType.LV_EXPRESSION -> new LvExpressionDiagnosticRequest(context);
            case Property.ValueType.ACTION_OR_EXPRESSION -> new ActionOrExpressionDiagnosticsRequest(context);
            case Property.ValueType.IDENTIFIER -> new IdentifierDiagnosticsRequest(context);
            case Property.ValueType.TYPE -> new TypeDiagnosticRequest(context);
            default -> throw new IllegalArgumentException("Unsupported property type: " + property.valueType());
        };
    }

    protected abstract Node getParsedNode(String var1);

    protected abstract Set<Diagnostic> getSemanticDiagnostics(ExpressionEditorContext var1);

    protected Set<Diagnostic> getSyntaxDiagnostics(ExpressionEditorContext context) {
        Node parsedNode = this.getParsedNode(context.info().expression());
        return StreamSupport.stream(parsedNode.diagnostics().spliterator(), true).map(CommonUtils::transformBallerinaDiagnostic).collect(Collectors.toSet());
    }

    @Override
    public Diagnostics getResponse(ExpressionEditorContext context) {
        Set<Diagnostic> syntaxDiagnostics = this.getSyntaxDiagnostics(context);
        if (!syntaxDiagnostics.isEmpty()) {
            return new Diagnostics(syntaxDiagnostics);
        }
        return new Diagnostics(this.getSemanticDiagnostics(context));
    }

    @Override
    public String getKey() {
        return "diagnostics";
    }

    @Override
    public long getDelay() {
        return 350L;
    }

    public record Diagnostics(Set<Diagnostic> diagnostics) {
    }
}

