/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.expressioneditor.services;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.flowmodelgenerator.core.expressioneditor.ExpressionEditorContext;
import io.ballerina.flowmodelgenerator.core.expressioneditor.services.DiagnosticsRequest;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LineRange;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.Diagnostic;

public class IdentifierDiagnosticsRequest
extends DiagnosticsRequest {
    private static final String REDECLARED_SYMBOL = "redeclared symbol '%s'";
    private static final DiagnosticErrorCode REDECLARED_SYMBOL_ERROR_CODE = DiagnosticErrorCode.REDECLARED_SYMBOL;

    public IdentifierDiagnosticsRequest(ExpressionEditorContext context) {
        super(context);
    }

    @Override
    protected Node getParsedNode(String text) {
        return NodeParser.parseBindingPattern((String)text);
    }

    @Override
    protected Set<Diagnostic> getSemanticDiagnostics(ExpressionEditorContext context) {
        Stream<Symbol> symbolStream;
        ExpressionEditorContext.Property property = context.getProperty();
        String typeConstraint = property.valueTypeConstraint();
        String value = property.value();
        if ("Object".equals(typeConstraint)) {
            return Set.of();
        }
        Optional semanticModel = context.workspaceManager().semanticModel(context.filePath());
        if (semanticModel.isEmpty()) {
            return Set.of();
        }
        if ("Global".equals(typeConstraint)) {
            symbolStream = ((SemanticModel)semanticModel.get()).moduleSymbols().stream().filter(symbol -> symbol.kind() != SymbolKind.MODULE);
        } else {
            Optional document = context.workspaceManager().document(context.filePath());
            if (document.isEmpty()) {
                return Set.of();
            }
            symbolStream = ((SemanticModel)semanticModel.get()).visibleSymbols((Document)document.get(), context.info().startLine()).parallelStream().filter(symbol -> symbol.kind() == SymbolKind.VARIABLE);
        }
        HashSet<Diagnostic> diagnostics = new HashSet<Diagnostic>();
        String inputValue = context.info().expression();
        boolean redeclaredSymbol = symbolStream.anyMatch(symbol -> symbol.nameEquals(inputValue) && !symbol.nameEquals(value));
        if (redeclaredSymbol) {
            String message = String.format(REDECLARED_SYMBOL, inputValue);
            diagnostics.add(CommonUtils.createDiagnostic((String)message, (LineRange)context.getExpressionLineRange(), (DiagnosticErrorCode)REDECLARED_SYMBOL_ERROR_CODE));
        }
        return diagnostics;
    }
}

