/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Item;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public record Category(Metadata metadata, List<Item> items) implements Item
{

    public static class Builder {
        private final Builder parentBuilder;
        private final Map<String, Builder> childBuilders;
        private final List<AvailableNode> availableNodes;
        private List<Item> prebuiltItems;
        private Metadata.Builder<Builder> metadataBuilder;

        public Builder(Builder parentBuilder) {
            this.parentBuilder = parentBuilder;
            this.childBuilders = new LinkedHashMap<String, Builder>();
            this.availableNodes = new ArrayList<AvailableNode>();
        }

        public Builder stepIn(Name childName) {
            Builder builder = this.childBuilders.get(childName.name);
            if (builder == null) {
                builder = (Builder)new Builder(this).metadata().label(childName.name).description(childName.description).keywords(childName.keywords).stepOut();
                this.childBuilders.put(childName.name, builder);
            }
            return builder;
        }

        public Builder stepIn(String name, String description, List<String> keywords) {
            Builder builder = this.childBuilders.get(name);
            if (builder == null) {
                builder = (Builder)new Builder(this).metadata().label(name).description(description).keywords(keywords).stepOut();
                this.childBuilders.put(name, builder);
            }
            return builder;
        }

        public Builder stepIn(String childName) {
            Builder builder = this.childBuilders.get(childName);
            if (builder == null) {
                builder = (Builder)new Builder(this).metadata().label(childName).stepOut();
                this.childBuilders.put(childName, builder);
            }
            return builder;
        }

        public Builder stepOut() {
            if (this.parentBuilder == null) {
                throw new IllegalStateException("Cannot step out of the root category");
            }
            return this.parentBuilder;
        }

        public Builder node(NodeKind kind) {
            AvailableNode node = NodeBuilder.getNodeFromKind(kind).buildAvailableNode();
            this.availableNodes.add(node);
            return this;
        }

        public Builder node(AvailableNode node) {
            this.availableNodes.add(node);
            return this;
        }

        public Builder items(List<Item> items) {
            this.prebuiltItems = items;
            return this;
        }

        public Metadata.Builder<Builder> metadata() {
            if (this.metadataBuilder == null) {
                this.metadataBuilder = new Metadata.Builder<Builder>(this);
            }
            return this.metadataBuilder;
        }

        public Builder name(Name name) {
            this.metadataBuilder = new Metadata.Builder<Builder>(this).label(name.name).description(name.description).keywords(name.keywords);
            return this;
        }

        public Category build() {
            Metadata newMetadata;
            Metadata metadata = newMetadata = this.metadataBuilder != null ? this.metadataBuilder.build() : null;
            if (this.prebuiltItems != null) {
                return new Category(newMetadata, this.prebuiltItems);
            }
            if (!this.availableNodes.isEmpty() && !this.childBuilders.isEmpty()) {
                throw new IllegalStateException("A category cannot have both categories and nodes as items");
            }
            ArrayList<Item> items = new ArrayList<Item>();
            if (!this.availableNodes.isEmpty()) {
                items.addAll(this.availableNodes);
            } else {
                this.childBuilders.forEach((key, value) -> items.add(value.build()));
            }
            return new Category(newMetadata, items);
        }
    }

    public static enum Name {
        ROOT("Root", "The topmost category of the palette", null),
        FLOW("Flow", "Flow control nodes", List.of("Core", "Control", "Flow")),
        STATEMENT("Statement", "Fundamental executable units in a program", null),
        CONNECTIONS("Connections", "The connections used in the flow", null),
        AGENTS("Agents", "The agents used in the flow", null),
        BRANCH("Branch", "Branching nodes", null),
        FLOWS("Flows", "Flows that invoke local or utility functions", List.of("Function", "Call", "Utility", "Local")),
        TERMINATION("Termination", "Termination nodes", null),
        ITERATION("Iteration", "Iteration nodes", null),
        CONTROL("Control", "Control nodes", null),
        CONCURRENCY("Concurrency", "Concurrency nodes", null),
        ERROR_HANDLING("Error Handling", "Handle errors that occur during execution", null),
        DATA("Data", "Data nodes are used to create, read, update, delete, and transform data", null),
        CURRENT_INTEGRATION("Current Integration", "Functions defined within the current integration", List.of("Project", "Local", "Function")),
        AGENT_TOOLS("Agent Tools", "Functions used as agent tools", List.of("Project", "Local", "Function")),
        IMPORTED_FUNCTIONS("Imported Functions", "Functions imported from other integrations", List.of("Imported", "Function", "Library")),
        AVAILABLE_FUNCTIONS("Available Functions", "Functions available in the library", List.of("Available", "Function", "Library")),
        IMPORTED_TYPES("Imported Types", "Types imported from other integrations", List.of("Imported", "Type", "Library")),
        AVAILABLE_TYPES("Available Types", "Types available in the library", List.of("Available", "Type", "Library"));

        final String name;
        final String description;
        final List<String> keywords;

        private Name(String name, String description, List<String> keywords) {
            this.name = name;
            this.description = description;
            this.keywords = keywords;
        }
    }
}

