/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.flowmodelgenerator.core.model.FacetedBuilder;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.ArrayList;
import java.util.List;

public record Diagnostics(boolean hasDiagnostics, List<Info> diagnostics) {

    public static class Builder<T>
    extends FacetedBuilder<T> {
        private boolean hasDiagnostics = false;
        private List<Info> diagnostics = new ArrayList<Info>();

        protected Builder(T parentBuilder) {
            super(parentBuilder);
        }

        public Builder<T> hasDiagnostics() {
            this.hasDiagnostics = true;
            return this;
        }

        public Builder<T> diagnostics(List<Info> diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public Builder<T> diagnostic(DiagnosticSeverity severity, String message) {
            this.diagnostics.add(new Info(severity, message));
            return this;
        }

        public Diagnostics build() {
            return new Diagnostics(this.hasDiagnostics || !this.diagnostics.isEmpty(), this.diagnostics.isEmpty() ? null : this.diagnostics);
        }
    }

    public record Info(DiagnosticSeverity severity, String message) {
    }
}

