/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model;

import io.ballerina.flowmodelgenerator.core.model.Branch;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.Diagnostics;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import io.ballerina.flowmodelgenerator.core.model.Property;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record FlowNode(String id, Metadata metadata, Codedata codedata, boolean returning, List<Branch> branches, Map<String, Property> properties, Diagnostics diagnostics, int flags) {
    public static final int NODE_FLAG_CHECKED = 1;
    public static final int NODE_FLAG_CHECKPANIC = 2;
    public static final int NODE_FLAG_FINAL = 4;
    public static final int NODE_FLAG_REMOTE = 1024;
    public static final int NODE_FLAG_RESOURCE = 2048;

    public Optional<Property> getProperty(String key) {
        return Optional.ofNullable(this.properties).map(props -> (Property)props.get(key));
    }

    public Optional<Branch> getBranch(String label) {
        return Optional.ofNullable(this.branches).flatMap(bs -> bs.stream().filter(branch -> branch.label().equals(label)).findFirst());
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) == flag;
    }
}

