/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.FlowNode;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.CallBuilder;
import io.ballerina.flowmodelgenerator.core.utils.FlowNodeUtil;
import io.ballerina.modelgenerator.commons.FunctionData;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.TextEdit;

public class AgentCallBuilder
extends CallBuilder {
    @Override
    protected NodeKind getFunctionNodeKind() {
        return NodeKind.AGENT_CALL;
    }

    @Override
    protected FunctionData.Kind getFunctionResultKind() {
        return FunctionData.Kind.FUNCTION;
    }

    @Override
    public void setConcreteConstData() {
        this.codedata().node(NodeKind.AGENT_CALL);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> connection;
        sourceBuilder.newVariable();
        FlowNode flowNode = sourceBuilder.flowNode;
        if (FlowNodeUtil.hasCheckKeyFlagSet(flowNode)) {
            sourceBuilder.token().keyword(SyntaxKind.CHECK_KEYWORD);
        }
        if ((connection = flowNode.getProperty("connection")).isEmpty()) {
            throw new IllegalStateException("Client must be defined for an action call node");
        }
        return ((SourceBuilder)sourceBuilder.token().name(connection.get().toSourceCode()).keyword(SyntaxKind.RIGHT_ARROW_TOKEN).name(flowNode.metadata().label()).stepOut()).functionParameters(flowNode, Set.of("connection", "variable", "type", "checkError")).textEdit().build();
    }
}

