/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.FormBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class AssignBuilder
extends NodeBuilder {
    public static final String LABEL = "Assign";
    public static final String DESCRIPTION = "Assign a value to a variable";
    public static final String EXPRESSION_DOC = "Assign value";
    public static final String VARIABLE_LABEL = "Variable";
    public static final String VARIABLE_DOC = "Name of the variable/field";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.ASSIGN);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> variable = sourceBuilder.getProperty("variable");
        if (variable.isEmpty()) {
            throw new RuntimeException("Variable is not set for the Assign node");
        }
        sourceBuilder.token().expression(variable.get()).whiteSpace().keyword(SyntaxKind.EQUAL_TOKEN).whiteSpace();
        Optional<Property> expression = sourceBuilder.getProperty("expression");
        if (expression.isEmpty()) {
            throw new RuntimeException("Expression is not set for the Assign node");
        }
        sourceBuilder.token().expression(expression.get()).endOfStatement();
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        ((FormBuilder)((Property.Builder)this.properties().custom().metadata().label(VARIABLE_LABEL).description(VARIABLE_DOC).stepOut()).type(Property.ValueType.LV_EXPRESSION).editable().stepOut()).addProperty("variable");
        this.properties().expressionOrAction(null, EXPRESSION_DOC, false);
    }
}

