/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class BinaryBuilder
extends NodeBuilder {
    public static final String LABEL = "Assign Binary";
    public static final String DESCRIPTION = "Assign Binary";
    public static final String BINARY_DATA_DOC = "Create new Binary Data";
    private static final String DUMMY_BINARY_DATA_EXPR = "base64 `abcd`";

    @Override
    public void setConcreteConstData() {
        this.metadata().label("Assign Binary").description("Assign Binary");
        this.codedata().node(NodeKind.BINARY_DATA);
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().payload(null, "byte[]").expression(DUMMY_BINARY_DATA_EXPR, BINARY_DATA_DOC);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        sourceBuilder.newVariable();
        Optional<Property> exprProperty = sourceBuilder.getProperty("expression");
        exprProperty.ifPresent(value -> sourceBuilder.token().expression((Property)value).endOfStatement());
        return sourceBuilder.textEdit().build();
    }
}

