/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class ConfigVariableBuilder
extends NodeBuilder {
    public static final String DEFAULTABLE = "defaultable";
    public static final String LABEL = "Config";
    public static final String DESCRIPTION = "Create a configurable variable";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.CONFIG_VARIABLE);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        Optional<Property> variable = sourceBuilder.getProperty("variable");
        if (variable.isEmpty()) {
            throw new RuntimeException("Variable is not set for the Assign node");
        }
        sourceBuilder.token().keyword(SyntaxKind.CONFIGURABLE_KEYWORD).whiteSpace().expression(variable.get()).whiteSpace().keyword(SyntaxKind.EQUAL_TOKEN).whiteSpace();
        Optional<Property> expressionOpt = sourceBuilder.getProperty(DEFAULTABLE);
        if (expressionOpt.isEmpty()) {
            throw new RuntimeException("Expression is not set for configurable variable");
        }
        String value = expressionOpt.get().toSourceCode();
        if (value.isEmpty()) {
            value = "?";
        }
        sourceBuilder.token().expression(value).endOfStatement();
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().defaultableName("").expression("", "Expression");
    }
}

