/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.flowmodelgenerator.core.model.NodeBuilder;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.Property;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.lsp4j.TextEdit;

public class ExpressionBuilder
extends NodeBuilder {
    public static final String LABEL = "Custom Expression";
    public static final String DESCRIPTION = "Represents a custom Ballerina expression";
    public static final String STATEMENT_KEY = "statement";
    public static final String STATEMENT_LABEL = "Statement";
    public static final String STATEMENT_DOC = "Ballerina statement";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.EXPRESSION);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        sourceBuilder.newVariable();
        Optional<Property> expression = sourceBuilder.getProperty("expression");
        if (expression.isPresent()) {
            sourceBuilder.token().expression(expression.get()).endOfStatement();
            return sourceBuilder.textEdit().build();
        }
        Optional<Property> statement = sourceBuilder.flowNode.getProperty(STATEMENT_KEY);
        if (statement.isEmpty()) {
            throw new IllegalStateException("One of from the following properties is required: variable, expression, statement");
        }
        sourceBuilder.token().expression(statement.get());
        return sourceBuilder.textEdit().build();
    }

    @Override
    public void setConcreteTemplateData(NodeBuilder.TemplateContext context) {
        this.properties().statement(null);
    }
}

