/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.model.node;

import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.model.SourceBuilder;
import io.ballerina.flowmodelgenerator.core.model.node.ParallelFlowBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.eclipse.lsp4j.TextEdit;

public class ForkBuilder
extends ParallelFlowBuilder {
    public static final String LABEL = "Fork";
    public static final String DESCRIPTION = "Create parallel workers";

    @Override
    public void setConcreteConstData() {
        this.metadata().label(LABEL).description(DESCRIPTION);
        this.codedata().node(NodeKind.FORK);
    }

    @Override
    public Map<Path, List<TextEdit>> toSource(SourceBuilder sourceBuilder) {
        sourceBuilder.token().keyword(SyntaxKind.FORK_KEYWORD).openBrace();
        List<String> workerNames = this.generateWorkers(sourceBuilder);
        sourceBuilder.token().closeBrace();
        Boolean isNew = sourceBuilder.flowNode.codedata().isNew();
        if (isNew != null && isNew.booleanValue()) {
            sourceBuilder.token().name("map<any|error>").whiteSpace().name("waitResult").keyword(SyntaxKind.EQUAL_TOKEN).keyword(SyntaxKind.WAIT_KEYWORD).keyword(SyntaxKind.OPEN_BRACE_TOKEN).name(String.join((CharSequence)",", workerNames)).keyword(SyntaxKind.CLOSE_BRACE_TOKEN).endOfStatement();
        }
        return sourceBuilder.textEdit().build();
    }
}

