/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.search;

import com.google.gson.reflect.TypeToken;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.flowmodelgenerator.core.LocalIndexCentral;
import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Category;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.Item;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.search.SearchCommand;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.SearchResult;
import io.ballerina.projects.Module;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.tools.text.LineRange;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ConnectorSearchCommand
extends SearchCommand {
    private static final String CONNECTORS_LANDING_JSON = "connectors_landing.json";
    private static final String AGENT_SUPPORT_CONNECTORS_JSON = "agent_support_connectors.json";
    private static final Type CONNECTION_CATEGORY_LIST_TYPE = new TypeToken<Map<String, List<String>>>(){}.getType();
    private static final Type AGENT_SUPPORT_CONNECTORS_LIST_TYPE = new TypeToken<Set<String>>(){}.getType();
    private static final String CONNECTOR_NAME_CORRECTION_JSON = "connector_name_correction.json";
    private static final Type CONNECTOR_NAME_MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Map<String, String> CONNECTOR_NAME_MAP = (Map)LocalIndexCentral.getInstance().readJsonResource("connector_name_correction.json", CONNECTOR_NAME_MAP_TYPE);
    private static final Set<String> AGENT_SUPPORT_CONNECTORS = (Set)LocalIndexCentral.getInstance().readJsonResource("agent_support_connectors.json", AGENT_SUPPORT_CONNECTORS_LIST_TYPE);
    public static final String IS_AGENT_SUPPORT = "isAgentSupport";
    public static final String CALLER = "Caller";
    public static final String CLIENT = "Client";
    public static final String GRPC = "grpc";
    public static final String PERSIST = "persist";

    public ConnectorSearchCommand(Project project, LineRange position, Map<String, String> queryMap) {
        super(project, position, queryMap);
    }

    @Override
    protected List<Item> defaultView() {
        List<SearchResult> localConnectors = this.getLocalConnectors();
        Category.Builder localCategoryBuilder = this.rootBuilder.stepIn("Local", null, null);
        localConnectors.forEach(connection -> localCategoryBuilder.node(ConnectorSearchCommand.generateAvailableNode(connection, true)));
        Map<String, List<SearchResult>> categories = this.fetchPopularItems();
        for (Map.Entry<String, List<SearchResult>> entry : categories.entrySet()) {
            Category.Builder categoryBuilder = this.rootBuilder.stepIn(entry.getKey(), null, null);
            entry.getValue().forEach(searchResult -> categoryBuilder.node(ConnectorSearchCommand.generateAvailableNode(searchResult)));
        }
        return this.rootBuilder.build().items();
    }

    @Override
    protected List<Item> search() {
        List<SearchResult> localConnectors = this.getLocalConnectors();
        localConnectors.forEach(connector -> this.rootBuilder.node(ConnectorSearchCommand.generateAvailableNode(connector, true)));
        List searchResults = this.dbManager.searchConnectors(this.query, this.limit, this.offset);
        searchResults.forEach(searchResult -> this.rootBuilder.node(ConnectorSearchCommand.generateAvailableNode(searchResult)));
        return this.rootBuilder.build().items();
    }

    @Override
    protected Map<String, List<SearchResult>> fetchPopularItems() {
        Map categories = (Map)LocalIndexCentral.getInstance().readJsonResource(CONNECTORS_LANDING_JSON, CONNECTION_CATEGORY_LIST_TYPE);
        LinkedHashMap<String, List<SearchResult>> defaultView = new LinkedHashMap<String, List<SearchResult>>();
        for (Map.Entry category : categories.entrySet()) {
            List searchResults = this.dbManager.searchConnectorsByPackage((List)category.getValue(), this.limit, this.offset);
            defaultView.put((String)category.getKey(), searchResults);
        }
        return defaultView;
    }

    private static AvailableNode generateAvailableNode(SearchResult searchResult) {
        return ConnectorSearchCommand.generateAvailableNode(searchResult, false);
    }

    private static AvailableNode generateAvailableNode(SearchResult searchResult, boolean isGenerated) {
        SearchResult.Package packageInfo = searchResult.packageInfo();
        Metadata metadata = new Metadata.Builder<Object>(null).label(ConnectorSearchCommand.getConnectorName(searchResult, packageInfo)).description(searchResult.description()).icon(CommonUtils.generateIcon((String)packageInfo.org(), (String)packageInfo.packageName(), (String)packageInfo.version())).addData(IS_AGENT_SUPPORT, AGENT_SUPPORT_CONNECTORS.contains(packageInfo.moduleName())).build();
        Codedata codedata = new Codedata.Builder<Object>(null).node(NodeKind.NEW_CONNECTION).org(packageInfo.org()).module(packageInfo.moduleName()).packageName(packageInfo.packageName()).object(searchResult.name()).symbol("init").version(packageInfo.version()).isGenerated(isGenerated).build();
        return new AvailableNode(metadata, codedata, true);
    }

    private static String getConnectorName(SearchResult searchResult, SearchResult.Package packageInfo) {
        String connectorName = searchResult.name();
        String rawPackageName = packageInfo.moduleName();
        String packageName = CONNECTOR_NAME_MAP.getOrDefault(rawPackageName, ConnectorSearchCommand.getLastPackagePrefix(rawPackageName));
        if (connectorName.equals(CLIENT)) {
            return packageName;
        }
        return packageName + " " + (connectorName.endsWith(CLIENT) ? connectorName.substring(0, connectorName.length() - 6) : connectorName);
    }

    private static String getLastPackagePrefix(String rawPackageName) {
        String trimmedPackageName = rawPackageName.contains(".") ? rawPackageName.substring(rawPackageName.lastIndexOf(46) + 1) : rawPackageName;
        return trimmedPackageName.substring(0, 1).toUpperCase(Locale.ROOT) + trimmedPackageName.substring(1);
    }

    private List<SearchResult> getLocalConnectors() {
        PackageCompilation compilation = PackageUtil.getCompilation((Project)this.project);
        Iterable modules = this.project.currentPackage().modules();
        ArrayList<SearchResult> localConnections = new ArrayList<SearchResult>();
        for (Module module : modules) {
            if (module.isDefaultModule()) continue;
            SemanticModel semanticModel = compilation.getSemanticModel(module.moduleId());
            List symbols = semanticModel.moduleSymbols();
            for (Symbol symbol : symbols) {
                ClassSymbol classSymbol;
                if (symbol.kind() != SymbolKind.CLASS || !(classSymbol = (ClassSymbol)symbol).qualifiers().contains(Qualifier.CLIENT)) continue;
                Optional optModule = symbol.getModule();
                if (optModule.isEmpty()) {
                    throw new IllegalStateException("Module cannot be found for the symbol: " + String.valueOf(symbol.getName()));
                }
                ModuleID id = ((ModuleSymbol)optModule.get()).id();
                String doc = "";
                if (classSymbol.documentation().isPresent()) {
                    doc = ((Documentation)classSymbol.documentation().get()).description().orElse("");
                }
                SearchResult searchResult = SearchResult.from((String)id.orgName(), (String)id.packageName(), (String)id.moduleName().substring(id.packageName().length() + 1), (String)id.version(), (String)classSymbol.getName().orElse(CLIENT), (String)doc);
                localConnections.add(searchResult);
            }
        }
        return localConnections;
    }
}

