/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.search;

import io.ballerina.flowmodelgenerator.core.search.SearchCommand;
import io.ballerina.modelgenerator.commons.SearchResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

class DefaultViewHolder {
    private static volatile DefaultViewHolder instance;
    private final Map<Class<? extends SearchCommand>, Map<String, List<SearchResult>>> defaultViewsCache = new ConcurrentHashMap<Class<? extends SearchCommand>, Map<String, List<SearchResult>>>();

    private DefaultViewHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultViewHolder getInstance() {
        if (instance != null) return instance;
        Class<DefaultViewHolder> clazz = DefaultViewHolder.class;
        synchronized (DefaultViewHolder.class) {
            if (instance != null) return instance;
            instance = new DefaultViewHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<SearchResult>> get(SearchCommand command) {
        Objects.requireNonNull(command, "SearchCommand cannot be null");
        Class<?> commandClass = command.getClass();
        if (this.defaultViewsCache.containsKey(commandClass)) {
            return this.defaultViewsCache.get(commandClass);
        }
        Map<Class<? extends SearchCommand>, Map<String, List<SearchResult>>> map = this.defaultViewsCache;
        synchronized (map) {
            if (!this.defaultViewsCache.containsKey(commandClass)) {
                Map<String, List<SearchResult>> items = command.fetchPopularItems();
                this.defaultViewsCache.put(commandClass, Collections.unmodifiableMap(items));
            }
            return this.defaultViewsCache.get(commandClass);
        }
    }
}

