/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.search;

import io.ballerina.flowmodelgenerator.core.model.AvailableNode;
import io.ballerina.flowmodelgenerator.core.model.Category;
import io.ballerina.flowmodelgenerator.core.model.Codedata;
import io.ballerina.flowmodelgenerator.core.model.Item;
import io.ballerina.flowmodelgenerator.core.model.Metadata;
import io.ballerina.flowmodelgenerator.core.model.NodeKind;
import io.ballerina.flowmodelgenerator.core.search.SearchCommand;
import io.ballerina.modelgenerator.commons.CommonUtils;
import io.ballerina.modelgenerator.commons.PackageUtil;
import io.ballerina.modelgenerator.commons.SearchResult;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class TypeSearchCommand
extends SearchCommand {
    private final List<String> moduleNames;

    public TypeSearchCommand(Project project, LineRange position, Map<String, String> queryMap) {
        super(project, position, queryMap);
        Package currentPackage = project.currentPackage();
        PackageUtil.getCompilation((Package)currentPackage);
        this.moduleNames = currentPackage.getDefaultModule().moduleDependencies().stream().map(moduleDependency -> moduleDependency.descriptor().name().packageName().value()).toList();
    }

    @Override
    protected List<Item> defaultView() {
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        if (!this.moduleNames.isEmpty()) {
            searchResults.addAll(this.dbManager.searchTypesByPackages(this.moduleNames, this.limit, this.offset));
        }
        this.buildLibraryNodes(searchResults, false);
        return this.rootBuilder.build().items();
    }

    @Override
    protected List<Item> search() {
        List typeSearchList = this.dbManager.searchTypes(this.query, this.limit, this.offset);
        this.buildLibraryNodes(typeSearchList, true);
        return this.rootBuilder.build().items();
    }

    @Override
    protected Map<String, List<SearchResult>> fetchPopularItems() {
        return Collections.emptyMap();
    }

    private void buildLibraryNodes(List<SearchResult> typeSearchList, boolean includeAllResults) {
        Category.Builder importedTypesBuilder = this.rootBuilder.stepIn(Category.Name.IMPORTED_TYPES);
        Category.Builder availableTypesBuilder = this.rootBuilder.stepIn(Category.Name.AVAILABLE_TYPES);
        for (SearchResult searchResult : typeSearchList) {
            SearchResult.Package packageInfo = searchResult.packageInfo();
            String icon = CommonUtils.generateIcon((String)packageInfo.org(), (String)packageInfo.packageName(), (String)packageInfo.version());
            Metadata metadata = new Metadata.Builder<Object>(null).label(searchResult.name()).description(searchResult.description()).icon(icon).build();
            Codedata codedata = new Codedata.Builder<Object>(null).node(NodeKind.TYPEDESC).org(packageInfo.org()).module(packageInfo.moduleName()).packageName(packageInfo.packageName()).symbol(searchResult.name()).version(packageInfo.version()).build();
            Category.Builder builder = this.moduleNames.contains(packageInfo.moduleName()) ? importedTypesBuilder : availableTypesBuilder;
            if (builder == null) continue;
            builder.stepIn(packageInfo.moduleName(), "", List.of()).node(new AvailableNode(metadata, codedata, true));
        }
    }
}

