/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.flowmodelgenerator.core.type;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.CallSite;
import java.util.ArrayList;

public class RecordValueGenerator {
    public static String generate(JsonObject json) {
        StringBuilder builder = new StringBuilder();
        RecordValueGenerator.generateValue(json, builder, 0);
        return builder.toString();
    }

    private static void generateValue(JsonObject json, StringBuilder builder, int indentLevel) {
        boolean hasTypeName = json.has("typeName");
        if (hasTypeName) {
            String typeName;
            switch (typeName = json.get("typeName").getAsString()) {
                case "record": {
                    RecordValueGenerator.generateRecordValue(json, builder, indentLevel);
                    break;
                }
                case "union": {
                    RecordValueGenerator.generateUnionValue(json, builder, indentLevel);
                    break;
                }
                case "enum": {
                    RecordValueGenerator.generateEnumValue(json, builder, indentLevel);
                    break;
                }
                default: {
                    if (json.has("value") && !json.get("value").getAsString().isEmpty()) {
                        builder.append(json.get("value").getAsString());
                        break;
                    }
                    if (json.has("defaultValue") && !json.get("defaultValue").getAsString().isEmpty()) {
                        builder.append(json.get("defaultValue").getAsString());
                        break;
                    }
                    RecordValueGenerator.generateDefaultValue(json, builder, indentLevel);
                }
            }
        }
    }

    private static void generateEnumValue(JsonObject jsonObject, StringBuilder builder, int indentLevel) {
        if (jsonObject.has("members") && jsonObject.get("members").isJsonArray()) {
            JsonElement members = jsonObject.get("members");
            for (JsonElement member : members.getAsJsonArray()) {
                JsonObject memberObj = member.getAsJsonObject();
                if (!memberObj.has("selected") || !memberObj.get("selected").getAsBoolean()) continue;
                if (memberObj.has("value") && !memberObj.get("value").getAsString().isEmpty()) {
                    builder.append(memberObj.get("value").getAsString());
                    break;
                }
                RecordValueGenerator.generateDefaultValue(memberObj, builder, indentLevel);
                break;
            }
        }
    }

    private static void generateUnionValue(JsonObject union, StringBuilder builder, int indentLevel) {
        JsonElement members;
        if (union.has("selected") && union.get("selected").getAsBoolean() && union.has("value") && !union.get("value").getAsString().isEmpty()) {
            builder.append(union.get("value").getAsString());
            return;
        }
        if (union.has("members") && (members = union.get("members")).isJsonArray()) {
            for (JsonElement member : members.getAsJsonArray()) {
                JsonObject memberObj = member.getAsJsonObject();
                if (!memberObj.has("selected") || !memberObj.get("selected").getAsBoolean()) continue;
                RecordValueGenerator.generateValue(memberObj, builder, indentLevel);
                break;
            }
        }
    }

    private static void generateRecordValue(JsonObject jsonObject, StringBuilder builder, int indentLevel) {
        JsonElement fields;
        if (jsonObject.has("selected") && !jsonObject.get("selected").getAsBoolean()) {
            return;
        }
        String indent = RecordValueGenerator.getIndent(indentLevel);
        String nextIndent = RecordValueGenerator.getIndent(indentLevel + 1);
        builder.append("{\n");
        ArrayList<CallSite> fieldValues = new ArrayList<CallSite>();
        if (jsonObject.has("fields") && (fields = jsonObject.get("fields")).isJsonArray()) {
            for (JsonElement field : fields.getAsJsonArray()) {
                JsonObject fieldObj = field.getAsJsonObject();
                if (!fieldObj.has("selected") || !fieldObj.get("selected").getAsBoolean()) continue;
                String fieldName = fieldObj.get("name").getAsString();
                StringBuilder fieldValueBuilder = new StringBuilder();
                RecordValueGenerator.generateValue(fieldObj, fieldValueBuilder, indentLevel + 1);
                String fieldValue = nextIndent + fieldName + ": " + fieldValueBuilder.toString().trim();
                fieldValues.add((CallSite)((Object)fieldValue));
            }
        }
        if (!fieldValues.isEmpty()) {
            builder.append(String.join((CharSequence)",\n", fieldValues));
        }
        builder.append("\n").append(indent).append("}");
    }

    private static void generateDefaultValue(JsonObject jsonObject, StringBuilder builder, int indentLevel) {
        String typeName;
        if (!jsonObject.has("typeName")) {
            return;
        }
        block11 : switch (typeName = jsonObject.get("typeName").getAsString()) {
            case "record": {
                RecordValueGenerator.generateRecordValue(jsonObject, builder, indentLevel);
                break;
            }
            case "union": {
                RecordValueGenerator.generateUnionValue(jsonObject, builder, indentLevel);
                break;
            }
            case "array": {
                builder.append("[]");
                break;
            }
            case "enum": {
                if (!jsonObject.has("members") || !jsonObject.get("members").isJsonArray()) break;
                JsonElement members = jsonObject.get("members");
                if (!members.getAsJsonArray().isEmpty()) {
                    RecordValueGenerator.generateDefaultValue(members.getAsJsonArray().get(0).getAsJsonObject(), builder, indentLevel);
                    break;
                }
                builder.append("\"\"");
                break;
            }
            case "error": {
                builder.append("error(\"Custom Error\")");
                break;
            }
            case "map": {
                builder.append("{}");
                break;
            }
            case "object": {
                builder.append("object {}");
                break;
            }
            case "stream": {
                builder.append("new;");
                break;
            }
            case "table": {
                builder.append("table []");
                break;
            }
            default: {
                switch (typeName) {
                    case "any": 
                    case "anydata": 
                    case "json": {
                        builder.append("()");
                        break block11;
                    }
                    case "xml": {
                        builder.append("xml ``");
                        break block11;
                    }
                    case "string": {
                        builder.append("\"\"");
                        break block11;
                    }
                    case "string:Char": {
                        builder.append("\"a\"");
                        break block11;
                    }
                    case "int": 
                    case "byte": {
                        builder.append("0");
                        break block11;
                    }
                    case "float": {
                        builder.append("0.0");
                        break block11;
                    }
                    case "decimal": {
                        builder.append("0.0d");
                        break block11;
                    }
                    case "boolean": {
                        builder.append("false");
                        break block11;
                    }
                }
                builder.append("\"%s\"".formatted(typeName));
            }
        }
    }

    private static String getIndent(int indentLevel) {
        return "    ".repeat(Math.max(0, indentLevel));
    }
}

